+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = 2022-11-01T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "All Arts is available online nationwide through AllArts.org, the free All Arts app on all major streaming platforms and @AllArtsTV on YouTube, Facebook, Instagram, Twitter and TikTok. For all the ways to watch, visit [AllArts.org/Everywhere](https://www.allarts.org/everywhere/)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1667351068/media/2022/11/EiO_Britt-Hewitt-and-Aaron-Engebreth-Photo-by-Aaron-Siegel-scaled_thqmgp.jpg"
primary_image_credit = "Britt Hewitt and Aaron Engebreth in Experiments in Opera's production of Everything For Dawn. Photo by Aaron Siegel."
related_articles = ["articles/living-up-to-its-name-experiments-in-opera.md", "articles/confessions-art-songs-that-are-deeply-personal.md"]
related_companies = ["scene/companies/experiments-in-opera.md"]
related_people = ["scene/people/sishel-claverie.md", "scene/people/laura-strickling.md", "scene/people/meroe-khalia-adeeb.md", "scene/people/joshua-conyers.md", "scene/people/eliza-bonet-1.md", "scene/people/britt-hewitt.md"]
short_description = "short"
slug = "everything-for-dawn-eio-premieres-new-opera-serial-on-wnet-groups-all-arts-streaming-service"
title = "Everything For Dawn: EiO premieres new opera-serial on WNET Group’s All Arts streaming service"
youtube_url = ""

+++
No we're not on the cusp of rebooting [_opera seria_](https://en.wikipedia.org/wiki/Opera_seria), but serialized opera, or at least one constituting a genuine mini-series, is waiting to be watched. If operas are perceived as long and attention spans most definitely short, this newest effort from the Brooklyn-based [Experiments in Opera](/scene/companies/experiements-in-opera/) might serve to level the playing field. The series is currently available on [All Arts](https://www.allarts.org/programs/everything-for-dawn/), the streaming service of The WNET Group and widely accessible, free of charge.

_Everything for Dawn_ is an opera in 10 installments, each running 20 minutes or so, with talk-backs following most. Viewers then are obligated to only 30 minutes of viewing at a time. Six writers, who ostensibly worked in a dedicated writer's room, contributed the librettos. Further testing the spirit of collaboration, each installment, with titles like "Stick With Me, Brother," and "Into a White Box" is by a different composer.

Like any serial, the plot grows increasingly complex. Set in a working-class suburb of Detroit, Dawn is a young woman living with her mother, a post office employee and new age disciple who, after her husband Mac's suicide, rents a room to an art student. "Everything for Dawn" is also the name of an unseen painting by Mac, who discovered the medium, if not his potential, during art therapy sessions at a psychiatric hospital. Mac, who appears as a spectral presence, even when he's alive, is sung with wrenching melancholy by Aaron Engelbreth.

In addition to Englebreth, Dawn features a tremendously assured group of singers. They are cannily cast to look their parts but more importantly they embody them with convincing musical and theatrical naturalism. So in sync are they with director Allison Moritz's character-focused direction and Eric Thomas Paton's probing photography that the production often radiates the spontaneity of _cinéma vérité_.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1667351436/media/2022/11/EiO_Maggie-Finnegan-Eliza-Bonet-Britt-Hewitt-Sishel-Clavere-Meroe-Adeeb-Photo-by-Aaron-Siegel-scaled_fzlodq.jpg){{% /md %}}

<figcaption>Maggie Finnegan, Eliza Bonet, Britt Hewitt, Sishel Clavere and Meroe Adeeb. Photo by Aaron Siegel.</figcaption>  
</figure>

As the story unfolds [Britt Hewitt](/scene/people/britt-hewitt/) (Dawn), [Sishel Claverie](/scene/people/sishel-claverie/) (Gloria, Dawn's mother) and [Eliza Bonet](/scene/people/eliza-bonet/) (Carla, the tenant) play off each other with a delicate balance of tact, desperation and uncertain intention. Anya, a Detroit gallerist, sung by [Maggie Finnegan](/scene/people/maggie-finnegan/), disrupts their routine. This budding art mogul champions Mac's work as she becomes involved with Carla. Finnegan's Anya is visibly calculating, as every player in the art market must be. Her commitment to Mac's work and family versus her plan to use both towards making a splash in New York remains one of the opera’s more intriguing aspects.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1667351470/media/2022/11/EiO_Joshua-Conyers-and-Aaron-Engebreth-Photo-by-Aaron-Siegel-scaled_aidtko.jpg){{% /md %}}

<figcaption>Joshua Conyers and Aaron Engebreth. Photo by Aaron Siegel.</figcaption>  
</figure>

In a flashback to Mac's stay in a psychiatric hospital, we meet Ed, a fellow patient sung with dark gusto by [Joshua Conyers](/scene/people/joshua-conyers/), who attempts to befriend Mac during their art therapy sessions. Joy, the therapist, sung by [Meroë Khalia Adeeb](/scene/people/meroe-khalia-adeeb/), is a poignant and etherial presence countered by the menacing Dr. Slade, who for better or worse controls their destinies. [Laura Strickling](/scene/people/laura-strickling/) brings a sinister flair to Slade's clinical façade. It’s a brief but plum turn for Strickling who can also be heard on _Confessions_, her striking Grammy-nominated recording that we were pleased to [review two years ago](/confessions-art-songs-that-are-deeply-personal/).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1667351519/media/2022/11/EiO_Strickling_lrf7sb.jpg){{% /md %}}

<figcaption>Laura Strickling sings the menacing Dr. Slade in Experiments in Opera's Everything For Dawn. Photo by Arielle Doneson.</figcaption>  
</figure>

What unites the compositions and sustains our interest is the unalloyed freedom of the music. Finding its way through arioso, atonality, raw rhythm, wisps of bel canto and expressionistic passages, these fresh musical ideas from 10 composers are distinct but play as one. Conductor, David Bloom's taut five-piece ensemble consisting of piano, bass, percussion, viola and violin, greets the myriad styles and structures of the compositions with polished urgency.

Each libretto, however, springs from its own source. Spanning three time periods, characters are radically altered even if the changes are subtle. Though momentary reliance on gender stereotypes and a preponderance of art-speak (a vocabulary that doesn't travel well) give pause, the librettos pack emotional heft and emerge as a lucid if ambiguous, operatic memory play.

If this sounds like melodrama, it isn’t. The position of the artist in society, our perceptions of what constitutes art entwined with its appreciation and commodification permeate [_Dawn_](https://www.allarts.org/programs/everything-for-dawn/). The work even entertains the concept of what constitutes an artist and who gets to be one.

EiO has conducted quite an experiment.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1667351543/media/2022/11/EIO-THE-DIRECTORS-FLEA-THEATER-BY-REUBEN-RADDING-6_kvs4sj.jpg){{% /md %}}

<figcaption>EiO founders Aaron Siegel, Jason Cady, and Kamala Sankaram, all of whom were part of the composition and libretto writing teams behind Everything For Dawn. Photo by Reuben Radding.</figcaption>  
</figure>