+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = "2018-11-27T20:08:00-05:00"
lastmod = "2018-11-27T21:11:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543367230729/sqENOLabohe%CC%80meNatalyaRomaniwJonathanTetelmanRobertWorkman3.jpg.jpg"
primary_image_credit = "Jonathan Tetelman and Natalya Romaniw in La bohème, English National Opera, 2018. Photo: Robert Workman."
publishDate = "2018-11-27T20:43:00-05:00"
related_companies = ["scene/companies/english-national-opera.md"]
short_description = "Rodolfo and Mimì shared what felt like a genuine chemistry. Sung by Welsh soprano Natalya Romaniw making her ENO debut, it was a subtle and heartfelt performance. There was something classic about her sound that I really loved. It was a true triumph. Musetta, sung by ENO Harewood Artist Nadine Benjamin, was unfortunately the weakest character for me."
slug = "everyday-people-spectacular-emotions-la-bohème"
title = "Everyday people &amp; spectacular emotions: La bohème"

+++
This was the fourth remount of Jonathan Miller's classic production of *La bohème* since its premiere at the ENO in 2009, and the revival direction this time around was deftly handled by Natascha Metherell. A standard production, it takes the ideals of the original 19th century piece and moves them forward into the 1930's. 

The Bohemian lifestyle was at its peak in the years after the First World War in Paris as people distracted themselves from their sorrow in a city that was gradually becoming more liberal. It calls to mind Hemingway; the listless, wandering lifestyle of excess, spending beyond one's means. This is the Paris people love to romanticize. 

Despite being set some 90 odd years ago, the story and its memorable characters remain as relatable as ever. It was *La bohème* as it should be: a young and thrillingly charismatic cast, an enchanting set, rich in detail, and a universally understood story told with truth and sincerity. There is something rewarding about seeing a piece of art that can so accurately reflect our own lives. It is why *La bohème* remains so prevalent to this day.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543367142258/ENOLabohe%CC%80meBozidarSmiljanicandcastWorkman.jpg.jpg)
<figcaption>Bozinar Smiljanic and the cast of *La bohème*, English National Opera, 2018. Photo: Robert Workman.</figcaption>
</figure>

When Murger published his *La vie de bohème* in 1851 it was a semi-autobiographical, reflection of societal change. When Puccini's opera premiered in 1896, it was breaking new ground, moving the tradition away from the Wagnerian world people were living in into one that was often startlingly true to life. And now, over 120 years later, the story remains as close to our hearts as ever, beautiful and poignant in its simplicity. 

The atmosphere that was beautifully crafted in this production perfectly presented the pervading image we have of Paris during this time. Think romantic shop fronts on bustling squares, rows of rooftops each with a smoking chimney, soft, warm street lights, and a dusting of christmas snow. I was particularly impressed by the level of detail that went into completing this image and with the importance the small, in between moments of character building were given. It was a stage full of activity and life.


<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543367078805/ENOLabohe%CC%80meDavidSoarNicholasLesterBozidarSmiljanicJonathanTetelmanRobertWorkman.jpg.jpg)
<figcaption>David Soar, Nicholas Lester, Bozidar Smiljanic, and Jonathan Tetelman in *La bohème*, English National Opera, 2018. Photo: Robert Workman.</figcaption>
</figure>

It was people in relationship that became the main focus of this production. This is established at the very beginning between the four male friends who share a sense of camaraderie, genuine love and concern for each other's well being, and, of course, quite a lot of light humored buffoonery. Nicholas Lester, David Soar, and Bozidar Smiljanic as Marcello, Colline, and Schaunard respectively, made the perfect boisterous trio. They were led by American tenor Jonathan Tetelman who makes his European debut singing the role of Rodolfo. He was bursting with charismatic energy with a voice to match. It was a romantic, ambitious sound just on the verge of maturity. He was at times covered by the orchestra and there were a few moments of unfortunate tuning in the second half of the opera but he gave a bold and engaging performance full of depth and life. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543367112795/ENOLabohe%CC%80meJonathanTetelmanNatalyaRomaniwRobertWorkman6.jpg.jpg)
<figcaption>Jonathan Tetelman and Natalya Romaniw in *La bohème*, English National Opera, 2018. Photo: Robert Workman.</figcaption>
</figure>

Rodolfo and Mimì shared what felt like a genuine chemistry. Sung by Welsh soprano Natalya Romaniw making her ENO debut, it was a subtle and heartfelt performance. There was something classic about her sound that I really loved. It was a true triumph. Musetta, sung by ENO Harewood Artist Nadine Benjamin, was unfortunately the weakest character for me. The performance lacked in confidence and the voice was inconsistent. It is a shame because Musetta's carefree strength is needed to counterbalance Mimì's girl-next-door sweetness. Musetta is beyond extreme and this is what makes her lovable and funny. She was lacking in personality, which caused the volatile love affair between her and Marcello to be somewhat perfunctory and her overall arc to lack variation.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543367119906/ENOLabohe%CC%80meNadineBenjaminandcastRobertWorkman3.jpg.jpg)
<figcaption>Nadine Benjamin and cast in *La bohème*, English National Opera, 2018. Photo: Robert Workman.</figcaption>
</figure>

*La bohème* has always fascinated me because it is about normal, everyday people who feel spectacular, passionate emotions. It is this passion and the opportunity to see these characters in relationship with one another that carry the story. Mimì's death is perhaps one of the most unremarkable in the entire operatic repertory. She does not poison, stab or shoot herself. She does not leap from a great height or even die of a broken heart. She is simply too ill to go on. And when her moment comes, it is heart wrenching in its utter mediocrity. Admittedly, a few tears were shed, if only because Miller's production reminded me why this opera still means something.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543367271005/ENOLabohe%CC%80meJonathanTetelmanNatalyaRomaniwRobertWorkman4.jpg.jpg)
<figcaption>Jonathan Tetelman and Natalya Romaniw in *La bohème*, English National Opera, 2018. Photo: Rober Workman.</figcaption>
</figure>

>ENO's production of *La bohème* runs through February 22, 2019. For details and ticket information, [click here.](https://www.eno.org/whats-on/la-boheme/)