+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2018-10-01T11:38:00-04:00"
lastmod = "2018-10-01T13:47:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1538408590961/sq18-19-01-MC-D-0459.jpg.jpg"
primary_image_credit = "Joyce El-Khoury as Tatyana in the Canadian Opera Company's new production of Eugene Onegin, 2018. Photo: Michael Cooper."
publishDate = "2018-10-01T11:45:00-04:00"
related_articles = ["articles/ariodante-or-the-hebridean-handel.md","articles/operas-love-stories-3-reasons-theyre-doomed.md"]
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/joyce-elkhoury.md","scene/people/joseph-kaiser.md","scene/people/gordon-bintner.md","scene/people/varduhi-abrahamyan.md"]
short_description = "It&#039;s hard to get a sense of whether Tchaikovsky means us to see Onegin as an anti-hero, a villain, or some pitiful shell of a man (like Patrick Bateman&#039;s less murderous brother, Sean). By the skin of her teeth, Tatyana comes out of their whole uncomfortable relationship unscathed, but not without some doubt; she rightly turns Onegin down in the final scene, but it&#039;s frustrating that she only does so because she&#039;s married to someone else."
slug = "eugene-onegin-or-the-time-tatyana-dodged-a-bullet"
title = "Eugene Onegin, or the time Tatyana dodged a bullet"
+++

[*Eugene Onegin*](https://www.coc.ca/productions/16460) opened its month-long run at the Canadian Opera Company on a crisp afternoon that seemed to match the cool reservation of Tchaikovsky's opera. The production by director Robert Carsen and designer Michael Levine - an arresting display of minimalist storytelling - seemed to offer up a polarising mix of opera. On one stage, we saw what makes opera utterly compelling, and what makes it fall limp.

On the compelling side were the honest performances by two Canadians: [Joyce El-Khoury](/scene/people/joyce-el-khoury/) as Tatyana, and [Joseph Kaiser](/scene/people/joseph-kaiser/) as Lensky. El-Khoury has the tricky task of playing an adorably naïve young woman while singing Tchaikovsky's music, which demands an adult sound. She pulled it off: not only does El-Khoury use the delicious ring that comes from her immersion in the *bel canto* roles (Violetta in *La traviata* is one of her signatures), but she leaves room for her voice to become more confident and mature in the final act.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1538408613660/18-19-01-MC-D-0548-0547.jpg.jpg)
<figcaption>Gordon Bintner as Eugene Onegin and Joyce El-Khoury as Tatyana in the Canadian Opera Company's new production of *Eugene Onegin*, 2018. Photo: Michael Cooper.</figcaption>
</figure>

Like El-Khoury, Kaiser was a real person amid this stark, aloof world. His Act II aria, ironically delivered behind a scrim in quasi-silhouette, was a moment of throaty humanity that we were badly craving.

Where *Onegin* doesn't compel is difficult to place; perhaps it's a joint effort between Pushkin (on whose verse novel the opera is based), Tchaikovsky, Carsen, and Levine. 

First thing's first: it's hard to feel anything but disgust for the titular character. Onegin is elitist and condescending, the sociopathic sort who gets away with acting like a dick because he's good-looking. [Gordon Bintner](/scene/people/gordon-bintner/), the exciting young baritone who's in his first leading role at the COC, an eerie embodiment of Onegin. There's beauty in his sound that makes an unsettling complement to his tall, dashing physicality; his is the kind of excellent posture that seems to exude disdain.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1538408552210/18-19-01-MC-D-0637.jpg.jpg)
<figcaption>(centre) Joyce El-Khoury as Tatyana and Gordon Bintner as Eugene Onegin in the Canadian Opera Company's new production of *Eugene Onegin*, 2018. Photo: Michael Cooper.</figcaption>
</figure>

It's hard to get a sense of whether Tchaikovsky means us to see Onegin as an anti-hero, a villain, or some pitiful shell of a man (like Patrick Bateman's less murderous brother, Sean). By the skin of her teeth, Tatyana comes out of their whole uncomfortable relationship unscathed, but not without some doubt; she rightly turns Onegin down in the final scene, but it's frustrating that she only does so because she's married to someone else. Her marriage vows are low on the long list of reasons she doesn't need Onegin in her life.

When I first saw this production, it was back in 2007, broadcast from the Met, *Live in HD*. I remember being struck by Levine's design, and I remember the perfection of Dmitri Hvorostovsky as Onegin, and Renée Fleming as Tatyana. The whole thing must have been such a vehicle for these two performers, that I missed the weaknesses not just of Carsen's direction, but of the piece itself.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1538408559815/18-19-01-MC-D-0143.jpg.jpg)
<figcaption>(l-r) Varduhi Abrahamyan as Olga and Joyce El-Khoury as Tatyana in the Canadian Opera Company's new production of *Eugene Onegin*, 2018. Photo: Michael Cooper.</figcaption>
</figure>

*Eugene Onegin* is full of superfluous "opera-isms". Chorus scenes that don't advance the plot, needless character tenor scenes, unwelcome bass arias in the third act, and endless bits of demonstrative text ("I am still unhappy," whines Onegin, unnecessarily). It's as though Tchaikovsky was doing a compose-by-numbers technique with *Onegin*, checking off boxes of "opera things" without considering if they make the piece better. And Carsen doesn't help. The chorus scenes (albeit predictably well sung by the COC Chorus) were stiff and awkward, and at times even drowned out by the sounds of sweeping brooms; and the French ditty we get from Triquet (a charming sing by Christophe Mortagne) is basically park-and-bark.

We get brooms and dull parties, but what we don't get out of *Onegin* is a sense of relationship, or a sense of stakes. It's lost on me why Olga (richly sung by [Varduhi Abrahamyan](/scene/people/varduhi-abrahamyan/)) and Lensky are a couple (or even couple-adjacent), since she's flakey and rude, and he's living in a fantasy world. The opera doesn't give us a chance to understand the apparently deep friendship between Lensky and Onegin, which makes it hard to be invested in their treagic duel scene. The starkness of Carsen's direction, while it may be accurately Russian, didn't show that Lensky and Onegin were anything more than acquaintances.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1538408568704/18-19-01-MC-D-0679.jpg.jpg)
<figcaption>Joseph Kaiser as Lensky and Varduhi Abrahamyan as Olga in the Canadian Opera Company's new production of *Eugene Onegin*, 2018. Photo: Michael Cooper.</figcaption>
</figure>

And perhaps the biggest shame was that Levine's stunning set didn't seem to suit the acoustics of the Four Seasons Centre. Too often, the singers were placed too far upstage, muffling their voices and dulling their subtle choices. El-Khoury took beautiful advantage of her few chances for stunning *pianissimo* singing, and Kaiser wailed his aria right through the divisive scrim. But we lost the highs and lows of the final scene between Tatyana and Onegin, which seemed to prioritize set symmetry over sound.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1538408580688/18-19-01-MC-D-1245-1247.jpg.jpg)
<figcaption>Joyce El-Khoury as Tatyana and Gordon Bintner as Eugene Onegin in the Canadian Opera Company's new production of *Eugene Onegin*, 2018. Photo: Michael Cooper.</figcaption>
</figure>

The COC's *Eugene Onegin* is a fascinating display of success and failures, and I'm happy to have seen it. Carsen's production is a sight to behold, held at arm's length as we may be. El-Khoury and Kaiser save the whole thing from freezing over, and Bintner's performance is a professional checkpoint that's thrilling to hear live.

*Eugene Onegin* runs through November 3. For details and tickets, [click here.](https://www.coc.ca/productions/16460)
