+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = 2020-03-02T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1583170420/media/2020/03/sqETOCOSIFANTUTTEThomas_ElwinFerrandoFrederickLongGuglielmoRICHARDHUBERTSMITH_opaq12.jpg"
primary_image_credit = "Tom Elwin as Ferrando (left) and Frederick Long as Guglielmo in English Touring Opera's production of Così fan tutte, 2020. Photo: Richard Hubert Smith."
related_articles = ["articles/an-open-letter-to-audition-candidates.md", "articles/cosi-fan-tutte-misogynist-unreasonable.md", "articles/atg-boheme.md"]
related_companies = []
related_people = []
short_description = "This performance of Mozart’s Così fan tutte marks the start of English Touring Opera’s spring tour which will also feature Handel’s Giulio Cesare as well as Bach’s St. John Passion in an impressive eighteen cities across the country. ETO’s extensive tours are the direct result of their clear mandate which is to bring accessible opera to cities and theatres across England where it would otherwise not be performed."
slug = "solid-simple-cosi-fan-tutte-from-english-touring-opera"
title = "Solid & simple Così fan tutte from English Touring Opera"
youtube_url = ""

+++
The Hackney Empire – The English Touring Opera’s home in London when they are not on the road - holds a faded grandeur that adds to its sense of charm. A small space for opera, even for European standards at 1200 seats, it feels welcoming, laidback, and intimate. Every seat provides a vantage point that allows the performer to connect with the audience and an opportunity for the audience to feel close to the action which can be a thrilling way to experience live music.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1583170188/media/2020/03/ETOCosi1_soruzz.jpg){{% /md %}}

<figcaption>(l-r) Tom Elwin as Ferrando, Joanna Marie Skillett as Fiordiligi, Frederick Long as Guglielmo, and Martha Jones as Dorabella in English Touring Opera's production of Così fan tutte, 2020. Photo: Richard Hubert Smith.</figcaption>

</figure>

This performance of Mozart’s _Così fan tutte_ marks the start of English Touring Opera’s spring tour which will also feature Handel’s _Giulio Cesare_ as well as Bach’s _St. John Passion_ in an impressive eighteen cities across the country. ETO’s extensive tours are the direct result of their clear mandate which is to bring accessible opera to cities and theatres across England where it would otherwise not be performed.

In this same spirit, this production of _Così fan tutte_, directed by young, up-and-coming director Laura Attridge, is sung in English translation; a translation that unlike in most Mozart opera sung in English, does not feel its been made to fit somewhere it does not belong. All of the same humour that exists in the original Italian, exists in this translation and the language has been updated for modern audiences. Attridge has also chosen to set the piece in 1930’s Alexandria; a locale that is, if not relatable, at least provides an ambience that can be appreciated by most audiences.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1583170201/media/2020/03/ETOCOSIFANTUTTEMarthaJonesDorabellaRICHARDHUBERTSMITH_afrg6v.jpg){{% /md %}}

<figcaption>Martha Jones as Dorabella in English Touring Opera's production of Così fan tutte, 2020. Photo: Richard Hubert Smith.</figcaption>

</figure>

The production design by Oliver Townsend called up a sensuous and sun-drenched luxurious holiday feel without distracting from the action. Simple yet distinct set pieces – a gilded sitting room, a statue-strewn formal garden, an ornate chaise lounge - all painted the picture of where we were in a way that was tangible and immediate, allowing the audience to fully immerse themselves in the story.

English Touring Opera has long championed young artists who are at the cusp of their professional careers, filling a significant gap in the industry by providing young performers with these high-level, professional performance opportunities. And not only is this valuable stage time, but it is a chance to take a show on tour and perform it many times over, allowing them to gain confidence and familiarity with their respective roles. In an opera like _Cosi fan tutte_ that is all about young people and the torments of young love, this youthful casting could not have been more appropriate.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1583170263/media/2020/03/ETOCOSIFANTUTTEStephanLogeDonAlfonsoJennyStaffordDespinaRICHARDHUBERTSMITH_xmscrb.jpg){{% /md %}}

<figcaption>Stephen Loges as Don Alfonso and Jenny Stafford as Despina in English Touring Opera's production of Così fan tutte, 2020. Photo: Richard Hubert Smith.</figcaption>

</figure>

Soprano Joanna Marie Skillett and mezzo soprano Martha Jones take the lead as sisters Fiordiligi and Dorabella accompanied by their betrothed, Guglielmo and Ferrando played by baritone Fredrick Long and tenor Thomas Elwin respectively. All four gave strong, energetic, and playful though slightly predictable performances. Fiordiligi the ever responsible, pragmatic elder sister, Dorabella spirited and easily mailable, Guglielmo confident if not slightly egotistical, and Ferrando romantic and prone to oversensitivity. However, these somewhat reductionist, stereotypic roles were played with great sensitivity and did not feel at all lacking but satisfyingly familiar.

Our quartet were joined by baritone Stephan Loges as Don Alfonso who acted as our narrator, frequently directing asides to the audience, breaking the fourth wall with a certain amount of regularity. Loges was a generous stage partner both in his jovial interactions with the boys and his thinly veiled, mocking interactions with the girls. But in particular, he and Despina - played by soprano Jenny Stafford - were a marvellous comedy duo, really playing off of each other’s energies. Stafford’s Despina was easily my favourite part of the show. Her diction was impeccably clear, her physical comedy well-timed, and her ability to switch between the multiple characters the role requires was both impressive and laugh-out-loud funny.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1583170318/media/2020/03/ETOCOSIFANTUTTEJoannaMarieSkillettFiordiligiMarthaJonesDorabellaJennyStaffordDespinaStephanLogesDonAlfonsoFrederickLongTomElwinRICHARDHUBERTSMITH_iufjsh.jpg){{% /md %}}

<figcaption>(l-r) Joanna Marie Skillett as Fiordiligi, Martha Jones as Dorabella, Jenny Stafford as Despina, Stephan Loges as Don Alfonso, Frederick Long as Guglielmo, and Tom Elwin as Ferrando in English Touring Opera's production of Così fan tutte, 2020. Photo: Richard Hubert Smith.</figcaption>

</figure>

There were many of these musically timed moments of physical comedy for all of the characters onstage. These small staging details really help the humour in a piece like this to sparkle. But overall, I felt that the direction of the piece was fairly basic and lacked imagination. It was as if the piece had been blocked in broad brushstrokes with little attention to detail. Many key moments lacked specificity and some of the longer arias wore on with very little interaction on stage to keep the audience’s focus.

This was, however, an all-round solid, if not slightly simple production. I was impressed with the level of singing and the commitment to character from all the performers, the production design was sensitive to the storytelling and did not distract or overcomplicate, and I was thoroughly entertained throughout. It is a remarkable feat for English Touring Opera to be able to take such a solid show across the country. Their need for mobility requires them to be simple, succinct, and clear; a luxury that larger companies do not share.