+++
author = ["authors/laura-attridge.md"]
categories = "How-To"
date = 2022-07-12T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "For more in this series, see the related links below. To read Laura Attridge's _Tuning In_ newsletter, [start here](https://us5.campaign-archive.com/?u=22295b68044fd4abb2a3aa0b0&id=28fe261072). "
preamble = "This essay is from a series titled \"The Things They Didn't Teach You At Conservatoire\" by director, writer, and Schmopera contributor Laura Attridge. They are originally [published through her newsletter](https://us5.campaign-archive.com/?u=22295b68044fd4abb2a3aa0b0&id=28fe261072),  crossposted and edited here with her permission."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1657653372/media/2022/07/Essay_unique_naiaoz.jpg"
primary_image_credit = ""
related_articles = ["articles/essay-tuning-in-to-looking-after-yourself.md", "articles/essay-tuning-in-to-developing-your-craft.md", "articles/essay-tuning-in-to-getting-ahead.md"]
related_companies = []
related_people = []
short_description = "From: The Things They Didn't Teach You At Conservatoire"
slug = "essay-tuning-in-to-what-makes-you-unique"
title = "Essay: Tuning In to What Makes You Unique"
youtube_url = ""

+++
> "There is a vitality, a life force, an energy, a quickening that is translated through you into action, and because there is only one of you in all of time, this expression is unique. And if you block it, it will never exist through any other medium and it will be lost. The world will not have it. It is not your business to determine how good it is nor how valuable nor how it compares with other expressions. It is your business to keep it yours clearly and directly, to keep the channel open. You do not even have to believe in yourself or your work. You have to keep yourself open and aware to the urges that motivate you. Keep the channel open." - [Martha Graham](https://en.wikipedia.org/wiki/Martha_Graham)

The longer I work in the arts, the more fundamentally I believe that every artist has something powerfully unique to offer to the world. But the longer I work in the arts, the more I also notice this idea missing from the primary narratives encountered by artists in traditional training routes into opera and classical music.

Instead, the message - often delivered via unspoken means, which makes it even more insidious - tends to be that there is one way to be an artist in any particular discipline: one way to measure excellence (whatever that even means), one kind of career towards which everyone in a department should strive, one vision of a successful future. By the same token, says that message, there is one way to be worthy - to be valid. And if you can't or won't follow that path, you and your art are a failure.

This damaging messaging shows up in all sorts of ways and all sorts of places. I’ll explore just a few of them here.

## What makes you unique?

No one asked me this when I was at music college. No one ever even hinted that the things I brought to the table - my singular combination of skills, experiences, knowledge, passions, and so on - might be something to explore, much less celebrate. In fact, I was told multiple times, by multiple teachers and mentors, to "turn my brain off", because apparently no one wants an intellectual soprano. The message was clear: there are a set number of kinds of soprano you can be; we'll decide what kind you are and you can try to live up to that.

The few times I furtively indicated that I had interests or ideas outside of that set model, it was strongly suggested that I lacked commitment to my primary training, and that those other interests or ideas would get in the way. As a result, my reliance on external validation grew and grew, while my faith in my own instincts dwindled to nearly nothing.

Once I left college, it took me a few years to begin untangling myself from that messaging: even having moved away from performance-based practice, I was still trying to be what I thought other people wanted me to be, trying to live up to what my new career trajectory should look like, what would traditionally constitute "success" as a writer and director.

First things first, it meant getting my story right: I should definitely not tell anyone that I trained as a singer, because that would immediately convey a narrative of failure. In other words, I was warned that I'd be seen, by the industry in which I was still working, as someone trying to pivot to a Plan B because she wasn't good enough or committed enough to make it as a singer.

Second, it meant downplaying the fact that I was working in two disciplines: if I shared that I was splitting my time and energy between directing and writing I'd be seen as lesser in my skill and expertise because I was spreading myself too thin.

Bull - if you'll excuse my language - shit.

I'm sure you won't be surprised to hear that the moment I decided to own my own story, to celebrate the richness of the experience and skill I was bringing to my work as a result of my unique ongoing journey as an artist, everything changed. Not least because that's when I became acutely aware of the ways in which those same dangerous narratives I'd received at conservatoire, myself, were affecting so many of the artists around me. And the more I looked for those effects, the more I saw them. And the more I saw them, the more I wanted to help others break free of them.

So what is it that you bring to the table? What is your specific combination of skills, strengths, experiences, ideas, passions and tastes? Has anyone ever asked you? Have you ever asked yourself? And if they have, or you have, has the question been asked without judgement? Because, as Martha Graham says, your job isn't to decide how good or valuable that uniqueness is, but rather to simply keep the channel open. To trust that it is your uniqueness that renders itself good and valuable simply by its own existence, and that you do it - and the world - a disservice by getting in its way or trying to mould it to someone else's expectations.

Here's how I work with singers now: by starting from an assumption that what they have to offer is unique and beautiful, and that my job is to support the expression of that uniqueness and beauty by meeting it half way with my own artistry. Sometimes that looks like collaboration in a rehearsal room, sometimes it's the creation of a safe space for exploration in a workshop or coaching, and sometimes it's me being the first person to ask someone, without judgement, "what is it that you bring to the table?" Because it never gets old seeing someone step into their power by embracing what makes them _them_.

## What does success look like?

If there are innumerable unique artists out there, the same can be said of how many ways there are to move through the world as an artist. The prevailing narrative that there are a limited number of ways to be a valid or valuable artist is, as I said before, complete and utter bullshit. It's also, when you really think about it, literally impossible, so for our training programmes to suggest that they're preparing students to follow a set path is, frankly, absurd.

I want to address a couple of areas before I wrap up, but here's the main thing I need you to know: however you are showing up as an artist is as legitimate and as important and as needed as any other artist. Even if that looks completely different to the way "success" was sold to you during your training.

Sure, success can look like performing at top opera houses or touring with a renowned orchestra, but it can also look like session work, teaching, corporate gigs, music therapy, workshop facilitation, community engagement, self-producing, chorus or choral work, gigging at weddings and funerals, performing on cruises or in variety shows, and so on and so forth. If you are out there sharing your gifts in some way, you are a valid artist.

And if you are sharing those gifts while doing other work to make ends meet? If you have to take time away from your art for your physical or mental health? If you have parenting or caring duties, or any other responsibilities that require time and energy that eat into your time and energy for your art? You are still a valid artist. No matter what.

In fact, I would go as far as to say that any and all of these things - these unique elements that make up who you are as a human - make you even more complex and singular as an artist. Bring it all with you. Because, as Martha Graham says, "There is a vitality, a life force, an energy, a quickening that is translated through you into action, and because there is only one of you in all of time, this expression is unique. And if you block it, it will never exist through any other medium and it will be lost. The world will not have it."

Keep the channel open.