+++
author = ["authors/laura-attridge.md"]
categories = "How-To"
date = 2022-07-12T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "For more in this series, see the related links below. To read Laura Attridge's _Tuning In_ newsletter, [start here](https://us5.campaign-archive.com/?u=22295b68044fd4abb2a3aa0b0&id=28fe261072)."
preamble = "This essay is from a series titled \"The Things They Didn't Teach You At Conservatoire\" by director, writer, and Schmopera contributor Laura Attridge. They are originally [published through her newsletter](https://us5.campaign-archive.com/?u=22295b68044fd4abb2a3aa0b0&id=28fe261072),  crossposted and edited here with her permission."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1657654576/media/2022/07/Essay_lookingafteryourself_p9flbi.jpg"
primary_image_credit = ""
related_articles = ["articles/essay-tuning-in-to-developing-your-craft.md", "articles/essay-tuning-in-to-getting-ahead.md", "articles/essay-tuning-in-to-what-makes-you-unique.md"]
related_companies = []
related_people = []
short_description = "From \"The Things They Didn't Teach You At Conservatoire\""
slug = "essay-tuning-in-to-looking-after-yourself"
title = "Essay: Tuning In to Looking After Yourself"
youtube_url = ""

+++
> "The voice of doubt, shame, and guilt blaring in our heads is not our voice. It is a voice we have been given by a society steeped in shame." - [Sonya Renee Taylor](https://en.wikipedia.org/wiki/Sonya_Renee_Taylor)

## 10+ areas to explore to improve your wellbeing

I recently reached out on social media to friends and colleagues for the tools and techniques they use as freelance artists to look after themselves, and the response was incredible. Below is a round-up of what was recommended, with a few additions from me along the way, BUT before we get to that I want to flag something important…

What works for one person - even if it's proven scientifically to be super effective in theory - may not work for someone else. And that's OK. There's a dreadful irony in someone punishing themselves because a popular wellbeing practice or idea isn't for them (eg. "Yoga works for everyone else but not for me. There must be something wrong with me!"). You can't fail with this stuff: keep being curious and explore what works best for you.

OK. Here we go.

### 1. Movement

The advice that came up most often across the board was to find a way to regularly move your body. Whether you’re running, walking, swimming, riding a bike, dancing, doing yoga or Pilates, going climbing, or just doing some stretching, moving in a way that feels right for you makes a world of difference. Emily and Amelia Nagoski note in their brilliant book _Burnout: the Secret to Unlocking the Stress Cycle_ that movement is the no.1 most effective way to bring your body back into balance from a state of stress and anxiety. So it's a sneaky two-birds-with-one-stone sort of situation, addressing both your physical and mental wellbeing.

As someone who for a very long time had a complicated relationship with exercise (thanks, secondary school and diet culture!), I'm all too aware that it can take time to find ways of moving one's body that feel like self-care rather than self-torture; if you find yourself in that position, please be kind to yourself, take the pressure off and just experiment for a while - what ultimately works best for you is up to you and your body. And it doesn’t need to be hours of commitment: so many people mentioned to me how much change they see for their physical and mental health even in taking five minutes regularly do some stretching, or making sure they get out the door and walk around the block every day. Anything that connects you with your body in a positive and meaningful way, however simple.

And if you're looking to boost the benefits of your chosen movement, invite someone to join you! There's a lot of scientific evidence to say that moving with someone else, or even with a group of people, has an incredibly powerful effect on our wellbeing. Additionally, you get the added psychological benefits of social connection, also proven to be a powerful tool. More on that later…

### 2. Harnessing the elements

For a while in first lockdown in 2020, all I could manage to achieve was to aim to leave the house every day without fail and get some fresh air (sometimes I didn't even manage that!). Those (almost) daily walks helped me get through some very difficult weeks, and I know I’m not the only one. These days I struggle to get outside every day because I find it very easy to get chained to my desk, but I do make a concerted effort to get my shoes on and step out of the door as consistently as I can because the impact on my wellbeing is palpable.

If you want to go a bit further than just getting out of the house, many of the people who sent me suggestions talked about the power of intentionally getting out into nature, whether that be a walk somewhere in the countryside, strolling through a forest or by a river, or spending time in a garden. And you can do this in any way that feels good to you - actively, socially, meditatively, spiritually… find what feels good for you.

There were also quite a few suggestions related to water, including getting in the sea or going to a spa, or even cold-water swimming! I’ve recently been encountering more and more friends and acquaintances who swear by the endorphin high you get from cold water, but also speak highly of the opportunity for meeting and connecting with new people when joining local cold-water swimming groups. Again, that extra bonus of social connection is a great one to add in.

### 3. Mindfulness

Like movement, this is another area where it’s easy - and understandable - to give one thing a go and decide you’re doing it wrong or it’s not for you, ultimately preventing yourself from reaping the benefits of a practice that's more tailor-made. I had some fantastic suggestions for ways that people have adapted a classic mindfulness practice to suit them; here are just a few:

* Find something active to do with your hands which allows your brain to take a break from everyday spirals of thinking and helps you get into a more mindful state. You could crochet, knit, draw, paint, chop vegetables, whittle, clean the bathroom, whatever works for you!
* Make a mini-ritual to deliberately spend time alone with yourself: put your electronic devices away, light a candle, listen to some beautiful music or mindfully read a book. If you are so inclined, this could be an extension of an existing spiritual practice, or help form a new one.
* Experiment with being in complete silence, allowing your brain to rest and recover from the onslaught of stimulation so many of us experience for a great deal of our day. Step away from distractions, take your headphones out, put your phone down, etc., and allow yourself to be in silence, however briefly. Just _be_ for a bit.
* Explore various types of meditation or breathing through guided practice: there are all sorts of resources out there to help you find what kind practice might work for you; some free, some paid. Popular apps like [Ten Percent Happier](https://www.tenpercent.com/) and [Headspace](https://www.headspace.com/), for example, offer a wide range of different kinds of meditative practice so you can figure out what you like best!

### 4. Nourishing yourself

Remembering to drink enough water and feed yourself well as a priority when you’re stressed or overwhelmed can sometimes feel like a difficult task, but - like the simplicity of just making sure you leave the house at least once a day - can make the world of difference.

Again, if you want to combine a couple of ideas, taking the time to cook a lovely meal offers a potentially mindful activity resulting in some nourishing food, _and_ if you cook for others as well as yourself you can make it a social occasion and benefit from the interpersonal connection that offers. Boom!

Of course, there are other ways of nourishing yourself that can make a big difference: intellectually, creatively, spiritually, socially, and so on. I'm certainly on my own journey towards acknowledging, and really believing, that getting this kind of nourishment for myself is as important - if not more-so - than being "productive" or achieving things professionally. It's so tough in our hustle culture!

Which brings me on to another great suggestion…

### 5. Hobbies

Having hobbies outside of your professional life can be a powerful outlet. Crucially, the pursuit of a hobby for the sake of itself - rather than within a narrative of being "successful" or "productive" - can be incredibly impactful, particularly for artists, who often have a complicated relationship with the interplay between their professional and personal identities. A hobby can allow you to just be you for a while.

Hobbies, again, offer the potential to combine a number of beneficial factors for your wellbeing in one fell swoop: if, for example, you’re a singer who takes up dancing classes (as is the case with one of the people who highly recommended hobbies to me!) you could benefit from regular movement, learning a skill for the sake of learning, finding a supportive community of friends who know you outside of your professional life, and giving your brain a break from thinking about work now and then!

### 6. Setting boundaries

This is an unsexy one, but important all the same. In order to factor in any/all of the advice on this list, and prioritise your wellbeing, you'll need to set clear boundaries in your professional life and maybe also in your personal life. As painful as that might initially sound, making sure you have boundaries in place to prioritise looking after yourself will ultimately make you not only happier and healthier, but also more productive in the long-run.

Here are some of the suggestions I received, plus a few of my own, for the kind of boundaries that might be helpful:

* If you struggle to take time for yourself (like I do!), schedule it in your diary as you would a work commitment. Whether that's an evening, a day, a week or more, give yourself permission to not work, be productive or achieve anything.
* Put boundaries around your working hours: this could look like scheduling a particular time in the day to check your emails, scheduling a regular "working day" at your desk to avoid continuing to work indefinitely, or anything that gives a definitive time-frame within which you’re in work-mode.
* Practise spending time without picking up your phone to see if you've had any messages (I recommend putting it in another room if you can).
* Turn off alerts for any apps on your phone that allow others to contact you at any moment of the day: emails, messaging apps, social media and so on. Remove the expectation that you are contactable at someone else's convenience. Your time belongs to _you_.
* Delete social media apps from your phone altogether. Make your interaction with social media deliberate, rather than reactive in moments of boredom or stress.
* Try going off the radar entirely for a few days a year, and see what happens!
* Set your out-of-office at will, including during periods in which you’re still officially working but you've got limited time in which to engage in additional dialogues - I always put mine on, for example, when I’m in full-time rehearsals for a project, and it gives me peace of mind to know it's on and anyone who emails me has some warning that replies might take a little while longer than usual.
* Add a footer about your working hours to your email signature, whether that's clarifying your days in the office or at your desk, or warning recipients that your hours - and therefore reply times - are flexible. Here’s mine, for example: "Please note that as a freelancer my designated office hours and access to emails will vary week to week depending on my other commitments, and response turnaround time may therefore also vary. I acknowledge that your schedule may be different from mine, so please don't feel the need to respond right away to any messages from me arriving outside of your own chosen working hours."
* Be willing to put boundaries around any relationships - professional or personal - that are proving damaging to your wellbeing. This can feel scary at first, but ultimately is a really impactful form of self-care, as explored by experts such as [Brené Brown](https://www.youtube.com/watch?v=xATF5uYVRkM).

### 7. Mindset shifts

I received quite a few suggestions to do with practising changing your mindset about, or relationship to, toxic narratives in our industry and in wider society. I believe this can be a powerful tool for building a foundation for long-term wellbeing: after all, tackling some of these toxic narratives and trying to create change is at the core of most of my work.

The suggestions I received specifically for this round-up included the following areas for re-evaluation and re-framing:

* Failure and rejection
* What success looks like
* Goal-setting
* Comparison
* Inherent biases

I personally love engaging with books, talks, articles and social media content from practitioners and experts working in these areas. With this in mind, another of the most helpful steps I've taken, myself, is to deliberately curate the accounts I follow on Instagram to ensure that the messaging I'm getting as I scroll through posts is from some of these brilliant people and organisations breaking free from damaging cultural norms and narratives. There are, I'm finding, ways to engage in social media that can be uplifting and inspiring, but it takes some work (and some boundary-setting!) to create that for myself.

Underpinning so much of this work, and foundational to any steps you might take to shift your mindset and thereby improve your wellbeing, are two of the most powerful words I know…

### 8. Curiosity and compassion

No word of exaggeration: the world changes dramatically for the better the more you begin to approach it with curiosity and compassion. Not only the way you experience the world, but also how you have impact in the world.

There's a whole other essay (if not a whole book!) to dedicate to these two words and how transformative they can be, but for now, here are a few suggestions I received from colleagues and friends about applying this idea in real life:

Use curiosity to connect with the world around you. Ask lots of questions, whether they feel stupid or smart. If in doubt, encourage rather than criticise (yourself and others). Forgive yourself: every mistake is a learning opportunity. Give it a go in the little things - how you approach a practice session, the way you phrase an email, the way you look around you as you sit on the bus…

What matters most is that a curious and compassionate approach moves away from what is so often at the core of toxic narratives: judgement and fear.

### 9. Reaching out

Of course, you don’t have to do any of this alone. As animals, we're hardwired for connection. Social interaction is therefore not just important - it's imperative. So if you're having a hard time, if you need a boost or you want to work something through, reach out to trusted friends and loved ones; that's what they're there for. You should certainly never feel you have to suffer in silence.

Of course, depending on what you need, there are sometimes limits to what those loved ones can provide, and that's when you might reach out to someone who can provide professional help: a doctor, a therapist, a counsellor, coach or mentor, all equipped with expertise to support you in specific areas that require specialist knowledge. Again, you should never suffer in silence; there's no shame in reaching out for the help you require.

More broadly speaking on the subject of connection, so many of the suggestions I received for this list had elements of seeking/finding/creating communities, through shared activities and interests. In addition to the benefits of social interaction, being part of a community makes us feel like we belong, and feeling like we belong can often gives a sense of meaning to our lives, and that's a powerful thing.

### 10. Processing emotion

I received fantastic suggestions for various outlets to help process emotion and experience, including things like journalling, but it feels most important to mention two big-hitters: laughing and crying. An unapologetic release of whatever it is you need to let go of can be incredibly freeing in a visceral way, allowing stress or tension to move through the body and be processed healthily.

This is another of the Nagoski sisters' suggestions for completing the stress cycle and getting the body back into balance. You can get creative, too, if you want to intentionally engage in laughter or tears. Whatever gets you going - a particular film, tv show, song, comedian, meme, person, etc., etc. - go for it, and don't hold back!

### + Much, much more

There's so much more, of course, than there is room for in this article, but here are a few final suggestions I wanted to include in this issue as a sort of "misc" section. While they didn't fit neatly into any of the categories above, you’ll see how they all connect with at least one - if not several - of those categories. Here goes:

* Figure out your individual baseline for how much sleep, quiet time, food, movement, and so on that you need each day, and _do not_ compromise on it.
* Create your own toolkit of wellbeing techniques you can draw upon so that if one thing isn't working for you you can try another.
* It's often useful to think and work cyclically, both in terms of your body's cycles and the natural cycles out in the world. I like to know that energy levels, or good times, will come back round again, and it's OK that these things are always in flux - they're meant to be. "This too shall pass" relates both to the bad and the good times.
* Use and create rituals that work for you. ([Click through](https://www.happinesslab.fm/season-2-episodes/episode-3-the-power-of-a-made-up-ritual) for a great podcast episode on the science behind the power of ritual.)
* Massage and other therapies for the body are not just a luxury.
* Spirituality - whether that's a religious faith or simply feeling part of something greater than oneself - offers connection, to others and to the world around us, and a sense of meaning.

And there you have it. Just a few of the many ways available to explore to improve your wellbeing as an artist. Let me know how you get on.