+++
author = ["authors/laura-attridge.md"]
categories = "How-To"
date = 2022-07-12T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "For more in this series, see the related links below. To read Laura Attridge's _Tuning In_ newsletter, [start here](https://us5.campaign-archive.com/?u=22295b68044fd4abb2a3aa0b0&id=28fe261072)."
preamble = "This essay is from a series titled \"The Things They Didn't Teach You At Conservatoire\" by director, writer, and Schmopera contributor Laura Attridge. They are originally [published through her newsletter](https://us5.campaign-archive.com/?u=22295b68044fd4abb2a3aa0b0&id=28fe261072),  crossposted and edited here with her permission."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1657653562/media/2022/07/Essay_gettingahead_fvsnqh.jpg"
primary_image_credit = ""
related_articles = ["articles/essay-tuning-in-to-looking-after-yourself.md", "articles/essay-tuning-in-to-developing-your-craft.md", "articles/essay-tuning-in-to-what-makes-you-unique.md"]
related_companies = []
related_people = []
short_description = "From \"The Things They Didn't Teach You At Conservatoire\""
slug = "essay-tuning-in-to-getting-ahead"
title = "Essay: Tuning In to Getting Ahead"
youtube_url = ""

+++
> "The world is full of people who are grabbing and self-seeking. So the rare individual who unselfishly tries to serve others has an enormous advantage." ― [Dale Carnegie](https://en.wikipedia.org/wiki/Dale_Carnegie)

There's a particular word in the English language that makes me feel a little sick anytime I read or hear it, and I'm sure I'm not the only one...

"Networking"

Now, I don't think that's solely because I'm a massive introvert and would rather set myself on fire than work a room full of industry big-wigs, although I'm sure that's part of it. I think my reaction - and, no doubt, many of yours as well - comes from an impulse that hits at the heart of what makes us all human: the need for authentic interpersonal connection. "Networking", at least in the way we usually understand the term, tends to imply the very opposite: shallow, brief interactions with others with the agenda of getting something out of them.

Whether, like me, you find that type of "networking" challenging or not - I've got friends and colleagues who excel at things like working a room, and it's certainly a skill not to be sniffed at - I want to explore a few ideas on the subject of getting ahead that might offer you some helpful new perspectives, no matter what your favoured approach.

## Starting from a place of authenticity

Let me flip the script: what kind of interaction would you prefer to have with a potential new collaborator, colleague or employee? A shallow, impersonal copy-and paste email or conversation that someone is offering around in an effort to cast as wide a net as possible? Or a genuine connection with someone who shares your interests or values, and wants to foster a relationship?

I know which one I'd go for.

Dale Carnegie knew all about this when he wrote _How to Win Friends and Influence People_ in 1936. It reads like a beginners manual on being a nice person and making connections with others, which might make you giggle to begin with, but when you go a bit deeper it's a reminder that moving through the world just not being a dickhead really can be incredibly powerful. Because the approach I outlined above - prioritising authentic connection over shallow impersonal contact - isn't necessarily the prevailing one in our society. So if you take said approach, you will always have, as Carnegie puts it, "an enormous advantage", because it will transform the relationships you build as a result.

It has some other advantages, too...

## Finding your people

Here's what I've discovered in recent years: the more I prioritise pursuing authentic connections with people I'm genuinely interested in, the more work I make that is aligned with my own values, and the more I find satisfaction and validation as an artist through that work. That's because I'm making it with teams and collaborators who are, for want of a better phrase, "my people". And because that work is aligned with what really matters to me, it leads to more authentic connections, and those connections lead to more work. And so on, and so forth. It's a self-fulfilling system (more detail on this in a bit). If we're talking networking, it's building a strong network that's going to last you a long, long time.

It's also an ingenious time-and-energy-saving device. Because the more I see how rich the vein of genuine connection is, the more confident I feel weeding out relationships that don't feel like that. Goodness knows I've come out of enough meetings in my time feeling awkward or undervalued or misunderstood, and for a long time I thought that was my fault - that I wasn't trying hard enough to connect, or I hadn't prepared well enough, or my ideas weren't good enough. But now I know not to take it personally: I won't be for everyone, and not everyone will be for me, and that's OK. Coming out of a meeting feeling a bit "meh" (or, in some cases, worse than "meh") means that that person is simply not one of my people.

Which brings me on to...

## Do I dare eat a peach?

One of my favourite quotes to use with singers when talking about auditions is from Dita Von Teese: "You can be the ripest, juiciest peach in the world, and there's still going to be somebody who hates peaches." In other words, if the panel isn't buying what you're selling, it doesn't mean there's something wrong with you - they might just not like peaches (or whatever delicious fruit or vegetable you'd like to identify with!).

I like to take the metaphor further, though, so stay with me: if you're a ripe, juicy peach but you're trying to be a crisp, shiny apple... you'll do neither fruit justice. So the panel members looking for an apple won't see what they're looking for, and meanwhile any panel members who just adore the taste of peaches will have no idea an incredible specimen has just stepped into the room.

This applies outside of auditions, too, of course. If you move through the world trying to be something or someone you're not, trying to make connections that don't honour your authentic self, you risk not connecting with the people who are your people. You risk not being able to make the work you are capable of making. You risk building a flimsy network, or no network at all.

## Planting seeds

I want to reclaim "networking", because it's a useful term when applied correctly. As an artist and/or a freelancer, networks of support - professional and personal - are key to making a successful career (whatever that looks like to you) and living a fulfilling life. We are creatures who thrive on connection, and what - after all - is making art if not striving for some kind of connection?

I also want to reclaim the old cliché, "it's not about what you know, but who you know". Now, I'm not pretending by any means that we live in an equitable industry or society that allows for equal opportunities free from the influences of privilege or nepotism. However, what I'd like to propose is that, much like the idea that just not being a dickhead can get you further than you think, you have more power in every professional (and, let's face it in this industry, personal) interaction than you might be aware of.

Let's go back to the example of auditions. The most common mentality I come across in performers - a mentality often instilled through messaging in our traditional training environments - is that the function of an audition is to get a particular gig. In other words, I'm going to go and audition to sing Ferrando for company X, and if I don't get it, game over - I've failed. I've turned up as a peach but they wanted apples, simple as that. Now, while I'd be commending that singer on their healthy approach to turning up as themselves and not thinking there's anything wrong with them when they didn't get the gig, there's still a massive piece of the equation missing. Because here's the thing: our industry is relatively small, and - for better or worse - often functions on the basis of recommendations and reputation. We've all been there: those projects that come out of nowhere because so-and-so recommended you to whatshername.

So if you turn up at your audition being the juiciest, most gosh-darn delicious peach for a production that turns out to need apples, you are still sowing the seeds for opportunities in the future that need peaches just like you. Any one of those panel members could remember you for a future project, or recommend you to a friend or colleague. The same goes, of course, for any and all professional environments, whether that's a rehearsal room or a casual introduction over coffee. All of these situations offer you the chance to show up as your best and most authentic self, planting those seeds as you go.

## Gardening

This approach takes courage, because the seeds you sow won't necessarily sprout when you want them to, where you want them to, or in the way you expected them to. Your job is to be the gardener: watering them, ensuring they get plenty of light, and weeding when necessary. And remember, no one else has a garden quite like yours, so it's no good popping your head over the fence to try to copy your neighbour's flowerbeds, or to judge the size of your vegetables based on the ones in their veg patch.

All fruit, vegetable and plant-based metaphors aside, that self-fulfilling system I mentioned above and promised to come back to? It's pretty simple: trust that your uniqueness will lead you to the right people and the right places. Use it to make authentic, long-lasting relationships with collaborators, colleagues and employers/employees who share your values and interests. The work will come, I promise.