+++
author = ["authors/laura-attridge.md"]
categories = "How-To"
date = 2022-07-12T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "For more in this series, see the related links below. To read Laura Attridge's _Tuning In_ newsletter, [start here](https://us5.campaign-archive.com/?u=22295b68044fd4abb2a3aa0b0&id=28fe261072)."
preamble = "This essay is from a series titled \"The Things They Didn't Teach You At Conservatoire\" by director, writer, and Schmopera contributor Laura Attridge. They are originally [published through her newsletter](https://us5.campaign-archive.com/?u=22295b68044fd4abb2a3aa0b0&id=28fe261072),  crossposted and edited here with her permission."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1657653841/media/2022/07/Essay_developingcraft_ikoszn.jpg"
primary_image_credit = ""
related_articles = ["articles/essay-tuning-in-to-looking-after-yourself.md", "articles/essay-tuning-in-to-getting-ahead.md", "articles/essay-tuning-in-to-what-makes-you-unique.md"]
related_companies = []
related_people = []
short_description = "From \"The Things They Didn't Teach You At Conservatoire\""
slug = "essay-tuning-in-to-developing-your-craft"
title = "Essay: Tuning In to Developing Your Craft"
youtube_url = ""

+++
> "Experts know that they can never stay still. It's like being in a boat, rowing slowly against the current. If you're not moving forward, you start to drift back. You can be proud of the work you've done, but you can never say that you have become as good as you will ever be. You have to keep moving, putting in energy, or you stagnate." ― [Roger Kneebone](https://en.wikipedia.org/wiki/Roger_Kneebone)

There are too many sub-topics under the umbrella of "developing your craft" – artistic practice, skill and perspective, as well as process and professional approach – to include in a single article, but I hope the ideas and provocations below offer a useful starting point from which to consider the "how" of being an artist.

## Adding to your toolkit

Let's start somewhere obvious: the skills you have in your toolkit for making your art, whatever that art is or the form it takes. In my experience, what's often missing across the board in traditional training environments is encouragement to explore different ways of expanding your artistic practice by adding new tools to your toolkit and seeking new perspectives from which to view your art and the world.

There is always so much more to be learned. Life as an artist, I find, is a constant journey of exploration and discovery. But - as we know - the opera and classical music worlds can be rather snobbish about what should make up an artist's practice and which opinions or expertise on that practice matter; this can lead to a limited number of skills, resources, experts and points of view being seen as valid or worthwhile. Just as there is a limit on what "success" looks like, there is therefore also a limit on the elements of an artistic practice seen as valuable.

But in order to really embrace your own uniqueness, and go all-in on your own lifetime journey of making art, you have to keep feeding yourself, and if you keep on practising the same few things you got taught in your formal training you're going to get stuck in a rut. So. What other skills and tools might benefit you or add another layer to your work? Where are the new places you might go looking to acquire those tools? What new ideas or stories might energise you? How can you explore different ways of seeing and engaging with the world around you? How can you ask questions about the art you make and how you make it?

Follow the thread of the things that interest and challenge you. Adopt a curiosity mindset, exploring for the sake of exploring, rather than putting pressure on the results of that exploration. Nourish yourself by engaging in other art forms, practices and perspectives. Get out of your comfort zone when the opportunity arises. What can you add to your toolkit? New performance skills? New collaborative skills? New intellectual or philosophical or political ideas? New and different ways of working with different kinds of people? How can you keep growing and developing?

Not only does this approach contribute to making your art more interesting, it makes the process far more interesting for you as well!

## Building your community

One of the best ways to contribute to this approach, and support your development, is to harness your growing community of other artists and practitioners. I've written previously about flipping the idea of "networking" on its head and prioritising authentic relationships in order to move forward in one's career; now I want to talk about the other benefits of building your "network" or - as I prefer to call it - your community. There are three main areas to consider as a starting point:

### 1. Other artists

Sticking with the idea of nourishing yourself artistically, one of the best ways to do this is to deliberately seek out diverse artists and practitioners to inspire and challenge you. Whether you simply engage with their artistic output as an audience member, listener, reader or viewer, whether you attend a talk or a practical workshop by them, whether you engage with them in conversation or even in artistic collaboration, your efforts to go beyond the safety of your own discipline, perspective or demographic will benefit both you and the future of the art form in which you work.

When you go about seeking new relationships to add to your network, remember that "your people" (as I called them in a [previous issue of this series](/essay-tuning-in-to-getting-ahead/)) are not just the obvious candidates who already operate in the same circles: "your people" can and should be people who expand and diversify those circles.

### 2. Teachers, mentors and coaches

The next part of your community needs to be a support team, in the form of mentors, teachers and/or coaches, and many of the same principles and questions apply here. Ask yourself: am I being challenged to grow and develop? Who do I trust to hold a safe space for me in which I can explore without judgement? Who is invested in my long-term growth and flourishing? Remember, this doesn't have to be a whole battalion of people with whom you constantly engage, but rather a community you can turn to when you need extra support or guidance. Furthermore, once you have a set of people whose opinions and feedback about your work you trust and respect, it frees you up from seeking validation from audiences, audition panels, and any others who haven't earned their place in your team and don't necessarily have your growth and development at the heart of their response to you.

### 3. Peers and colleagues

And, finally, a suggestion that strikes at the heart of the competitive messaging we are fed not only in our training environments but also in the industry: your peers can be an invaluable source of support, and a resource for growth and development. If you accept that every one of us has something unique to offer, it means that you simply cannot be in direct competition with others in your field: you may be applying or auditioning for some of the same opportunities, sure, but there's no use in comparing yourself to anyone else, because you are fundamentally offering completely different things.

Once I accepted this and began to see other directors and writers working in opera not as competition but as peers to celebrate, support and/or learn from, a profound shift happened in my mindset. I was able to step away from toxic narratives about comparison and jealousy (which had been terrible for my mental health!), and have since established many of my most prized connections and friendships with some of those artists that I would previously have seen as competitors. The support and feedback I share with them is particularly special because we have an intimate understanding and appreciation of one another&#39;s experiences. So, if you aren't already, start sharing with your peers - practice, tips, materials, recommendations, advice, and so on - and consider the ways you can resist that competitive messaging and instead lift one another up.

## Developing your process

Here's a final "how" to consider: how you go about practising your craft, and by that I don't just mean technical practice, although that's a good place to start.

So let's do just that: whether you're an instrumentalist or a singer, an actor or a dancer, a painter or a photographer, a writer or a director, or any other kind of artist, how do you approach your technical practice? I'm not asking what that practice involves, but rather how you undertake it. How do you manage scheduling it or working it around other commitments? What is your mindset? What is your learning style? And how do you incorporate input from your community to best advantage?

Get curious about process: books like the classic _The Inner Game of Tennis_ are a great place to start for some suggestions about how you can transform your approach to practising. You might find ideas from other disciplines - whether artistic or not - really helpful, if you can't find the right ideas within your own circles.

And then what about when you're actually out there doing the work itself: _that_ sense of the word "practice"? What's your process there? If you're a singer, for example, how do you navigate your way through a rehearsal period and take responsibility for your own journey so that you're where you want to be by the time the show opens to the public? If you're a writer, how do you manage the process of drafting and refining towards the completion of a commission so that you're happy with what you end up with in the final version? Have you figured out the structures within which you work best?

And thinking more generally, how do you manage your day-to-day, week-to-week, month-to-month practice in the broadest sense of the word? What are the structures in place to help you do that? Do you use goal-setting methods, a To Do List app (like [ToDoist](https://todoist.com/)), time-management techniques (like [Pomodoro](https://en.wikipedia.org/wiki/Pomodoro_Technique)), weekly time-blocking, or longer-term scheduling? Do you know what time/s of day you are most focused or productive? Do you prefer an electronic or paper diary? What works best for you, for your lifestyle, your brain and your art, and what experiences can you learn from?

The more understanding you can gather about what works best for you, the better you can take responsibility for your practice, in all its manifestations, and work to your best abilities. In my experience, you can only make these discoveries through trial and error. What works for someone else won't necessarily work for you - and discovering that doesn't mean you're a failure; it just means you've received some really useful information to help you move forward.

And remember, as we've established, you don't have to go it alone to figure this stuff out: use your community to help you explore and develop an approach that works best.

Again, this is all an exercise in a curiosity mindset: figuring out what works best for you takes time and energy and mistakes along the way, but if you commit to staying curious it will contribute to a joyful lifelong journey of getting to know yourself and your art better and better.

So there you have it: a whistle-stop tour through just some of the areas of enquiry that come under "developing your craft". There are, of course, many, many more questions to be asked, but the most important thing is that you start by asking some of them and see where they take you.

Good luck!