+++
author = ["authors/greg.md"]
categories = "Review"
date = "2017-12-15T12:00:00-05:00"
lastmod = "2017-12-15T17:12:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1513357165751/sq---Danika-Lore%CC%80n-Darryl-Block-Photography.jpg.jpg"
primary_image_credit = "Danika Lorèn in BOUND, Against the Grain Theatre, 2017. Photo: Darryl Block Photography."
publishDate = "2017-12-15T12:08:00-05:00"
related_articles = ["articles/atgbound-a-shocking-immediate-connection.md"]
related_companies = ["scene/companies/against-the-grain-theatre.md","scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/danika-lorn.md","scene/people/victoria-marshall.md","scene/people/miriam-khalil.md","scene/people/michael-uloth.md","scene/people/christopher-mokrzewski.md","scene/people/joel-ivany.md","scene/people/asitha-tennekoon.md","scene/people/justin-welsh.md","scene/people/david-trudgen.md"]
short_description = "Never a stranger to tackling contemporary subject matter, Against the Grain once again confirms its position as a leader of the pack in the world of underground, indie opera. BOUND is currently finishing the first stage of its multi-year workshop journey, and the direction it&#039;s heading in is both exciting and scary - in very good ways."
slug = "equal-parts-stressful-and-reverent-atgbound"
title = "Equal parts stressful and reverent: #AtGBound"
+++

Since its debut, [Against the Grain Theatre](/scene/companies-against-the-grain-theatre/) has been turning opera on its ear, and turning heads. Their award-winning, innovative programming takes the tried-and-true classics (*Così fan tutte*, *Messiah*, *La bohème*) and brought them to life with a new, modern perspective. 

Thursday night showed how AtG's Artistic Director Joel Ivany isn't afraid to tackle serious questions. Know for his "transladaptations: (I think I kinda love that word) of classic works - [*La bohème*](/hype-atg-boheme/) and the Mozart/Da Ponte trilogy (*Figaro's Wedding*, *#UncleJohn*, [*A Little Too Cozy*](/in-review-a-little-too-cozy/)) - Ivany sets those skills to work in a series of arias from Handel's canon. [*BOUND*](http://againstthegraintheatre.com/bound/) features gems from operas like *Rodelinda*, *Tolomeo*, *Ariodante*, *Semele* and more, all with new texts written by Ivany. With musical consultation by Kevin Lau and with [Topher Mokrzewski](/scene/people/christopher-mokrzewski/), AtG's resident Music Director at the keyboard, the night was equal parts stressful and reverent. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1513356548561/BOUND_MEDIA_308-1.jpg.jpg)
<figcaption>*BOUND*, Against the Grain Theatre, 2017. Photo by Darryl Block.</figcaption>
</figure>

The characters are being held by "The State" and interrogated in conneection with violating immigration policies. I was selected to undergo "further processing by The State" during the preamble to the show before we were all ushered into the performance space. It was a dramatic and effective touch. Each of the seven characters is interrogated in turn, and the scenes alternate between interrogation and aria. All the detainees are lit in a tight "cell" by lighting designer Jason Hand, giving the disjunct material a sense of continuity and grounding the entire production. The show started in a moment of extended, and poignant silence.

The singing was glorious. 

Tenor [Asitha Tennekoon](/scene/people/asitha-tennekoon/) sang with a fire and passion while managing a legato through Handel's devilish melismas. His bright upper-end shone through the space and his handsome, affable face made him extremely charismatic in his struggle. You wanted him to be released. You felt that. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1513356802752/Asitha-Tennekoon-Darryl-Block-Photography.jpg.jpg)
<figcaption>Asitha Tennekoon in *BOUND*, Against the Grain Theatre, 2017. Photo by Darryl Block.</figcaption>
</figure>

Mezzo [Victoria Marshall](/scene/people/victoria-marshall/) sang the role of a young woman who seems to have been framed by her brother - or is incarcerated in a McCarthy-witchhunt-like scenario for her relation to him (I was a little unclear) - showed some great promise. The voice is there. She has a quick vocal action and deliciously precise accuracy. I feel like I'm seeing Marshall at the precipice of a breakthrough as an actor. I was so moved by her delivery that I'm excited to see what more she can do - and I hope it's a LOT more Handel. 

Baritone [Justin Welsh](/scene/people/justin-welsh/) gave a poignant portrayal of a man incarcerated for finding his way later in life. A man by the name of Mr. Washington who now resides as Ahmed Habib, a muslim, in "The State" is forced to answer for his change in faith. His singing was richer than the last time I've heard him. I felt like he found an untapped reservoir of unbridled tone in his voice since then, and it was delicious. Justin had a similiar legato approach to the melismas and runs as Tennekoon and it was a smart choice, but also a nice point of continuity in the show. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1513356819117/Justin-Welsh%2C-Miriam-Khalil%2C-Asitha-Tennekoon%2C-Victoria-Marshall-Darryl-Block-Photography.jpg.jpg)
<figcaption>(l-r) Justin Welsh, Miriam Khalil, and Victoria Marshall (background) in *BOUND*, Against the Grain Theatre, 2017. Photo by Darryl Block.</figcaption>
</figure>

Soprano [Danika Lorén](/spotlight-on-danika-loren/) brought her thrilling coluratura in spades. She portrayed the most politically explosive character detained in the show. Her delivery was fiery, passionate, and dramatic. Lorén is definitely one of the brightest young stars on our scene right now. 

Playing the role of a man being detained for the faults of his predecessors, bass [Michael Uloth](/spotlight-on-michael-uloth/) brought a rich, melifluous tone and a striking figure to the stage. His singing is rich and low without feeling woofy or manufactured. He has a handsomeness that reminds me of Chevy Chase in the *National Lampoon's Vacation* movies. He's very dashing, but not intimidating - a combination that allows the audience to really focus on the dialogue he's presenting.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1513356860564/Michael-Uloth%2C-Justin-Welsh%2C-Miriam-Khalil%2C-Victoria-Marshall%2C-Danika-Lore%CC%80n-Darryl-Block-Photography.jpg.jpg)
<figcaption>Michael Uloth (foreground), Justin Welsh, Miriam Khalil, Victoria Marshall, and Danika Lorèn in *BOUND*, Against the Grain Theatre, 2017. Photo by Darryl Block.</figcaption>
</figure>

The two strongest vignettes for me were delivered from countertenor [David Trudgen](/scene/people/david-trudgen/) and soprano [Miriam Khalil](/scene/people/miriam-khalil/). Trudgen plays a transgendered man incarcerated because the sex on his birth certificate doe not match that of his state-issued passport. The chill in the air was palpable when the state announces "You have 21 days to comply." Trudgen's singing is top-drawer and Handel is totally his wheelhouse. His agility and strength of tone were a perfect match to communicate his emotional struggle. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1513356905183/Asitha-Tennekoon%2C-David-Trudgen-Darryl-Block-Photography.jpg.jpg)
<figcaption>David Trudgen and Asitha Tennekoon (foreground) in *BOUND*, Against the Grain Theatre, 2017. Photo by Darryl Block.</figcaption>
</figure>

Khalil played Noor Haddad, a woman incarcerated because the state views her wearing of the hijab as a form of protest, as opposed to "a form of expression between me (her) and my maker." Her singing, as always, was brilliant. Taking a cue from her amazing work in last years *Ayre*, Khalil added a "cadenza" of sorts to the end of her aria featuring Middle-Eastern/Arabic melodic turns added a world-conscious touch that was breathtaking. These two storylines seemed to echo the strongest through the hall, and I think that has to do with the public discourse happening worldwide. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1513356926301/Miriam-Khalil-Darryl-Block-Photography.jpg.jpg)
<figcaption>Miriam Khalil in *BOUND*, Against the Grain Theatre, 2017. Photo by Darryl Block.</figcaption>
</figure>

We can not ignore "The State" though. Canadian screen icon and all-around national treasure Martha Burns (*Slings and Arrows* - one of my favourite shows) was our disembodied voice of authority. Speaking through a shoddy public address system that would cut in and out, her cold, callous, and calculating characterization was chilling. My favourite part was how adeptly she handled speaking an accompagnato recit. This partnership was incredible, and she brought a much required sense of gravitas. It also helped with our sense of the characters' feelings of impotence against a society that only sees in black and white.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1513356990006/InfinityPoster.Black.Flat.12-12-2017-01.jpg.jpg)
<figcaption>Illustration by Dmitry Bondarenko.</figcaption>
</figure>

Never a stranger to tackling contemporary subject matter, Against the Grain once again confirms its position as a leader of the pack in the world of underground, indie opera. BOUND is currently finishing the first stage of its multi-year workshop journey, and the direction it's heading in is both exciting and scary - in very good ways. It's joining the discussion that Indie Opera here in Toronto has been having with companies like Tapestry Opera ([*Oksana G.*](https://www.schmopera.com/tough-to-watch-oksana-g/)), Loose TEA Music Theatre ([*Carmen*](https://www.schmopera.com/erica-iris-singing-a-radically-revisionist-carmen/)) and many others. This is not your typical holiday fare - but it's a perfect palate cleanser to all the other holiday delights that Toronto has to offer. 

Most shows are sold out, but there is [limited rush seating](http://againstthegraintheatre.com/bound/) that is made available one hour before showtime. Get out and see [#AtGBound](http://againstthegraintheatre.com/bound/). It may not be *Messiah*, but it's definitely Handel.
