+++
author = ["authors/michael-pecak.md"]
categories = "Interview"
date = 2020-12-08T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1607278872/media/2020/12/sqEnriqueMazzola-ToddRosenberg_ed1dyh.jpg"
primary_image_credit = "Photo: Todd Rosenberg."
related_articles = ["articles/piotr-beczala.md", "articles/talking-with-conductors-enrique-mazzola.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/enrique-mazzola.md"]
short_description = "\"Our city\" – It was a phrase that came up often in our conversation. It's clear Maestro Mazzola already has one foot firmly planted in his newly adopted hometown. As he confessed, he is excited to spend his first holiday season in Chicago despite health restrictions and cancellations."
slug = "catching-up-with-enrique-mazzola"
title = "Catching up with Enrique Mazzola"
youtube_url = ""

+++
When I [first spoke](/talking-with-conductors-enrique-mazzola/) with conductor Enrique Mazzola in October 2019, he had just been announced Lyric Opera of Chicago's new music director designate and preparing Verdi's _Luisa Miller_. Brimming with energy and excitement, the Maestro was keen to share his vision and ambitions for the future of Lyric and setting the tone for his tenure as its new leader.

Since that time, the whole world has been flipped upside down due to COVID-19. Yet despite the ongoing pandemic, Mazzola's enthusiasm and optimism remains infectious (forgive the pun). In a recent Zoom interview, I caught up with Maestro, who is currently in the U.S. balancing regional conducting work (most recently with the Detroit Symphony Orchestra) and meeting the pandemic-related challenges facing Lyric with a smile and an eye toward the future, laying the groundwork for when he officially takes the reins as Lyric's music director in the 2021-2022 season.

Then as now, Verdi weighs heavily on Mazzola's thoughts. Following last season's _Luisa Miller_, Mazzola was scheduled to conduct this fall’s production of _Attila_, the next instalment of an early-Verdi series Mazzola is curating for Lyric. Cancellations, however, necessitated pivots in programming, and like so many others, Mazzola took to a digital platform to connect with audiences. The result is [_Breaking Down the Score_](https://www.lyricopera.org/shows/upcoming/2020-21/breaking-down-the-score-attila-with-maestro-enrique-mazzola/), a twelve-part web series with Maestro Mazzola guiding listeners through the twelve musical numbers of Verdi's _Attila_.

***

**Enrique Mazzola:** _This began during the first wave of the pandemic. At that time, I was in my home in Montepulciano, Italy, and I wanted to do something for the Lyric. My idea was to open the full score and to go through it with viewers. But I didn't want to make an academic lecture with dates and facts and things that people can read on Wikipedia. I wanted the delivery to be spontaneous, not from a script. I wanted to say, "listen to this passage. Do you hear these emotions? Here are the challenges of this section."_

Released weekly and accessible through [Lyric's YouTube channel](https://www.youtube.com/user/lyricoperaofchicago), each roughly-ten-minute-long episode of the series features Mazzola's charming commentary and engaging insights about the early-Verdian masterpiece. And, like virtually every other musician today, Mazzola has embraced the very relatable need to expand his skill set, both recording and editing the videos himself.

**EM:** _At first, I recorded with my phone and used an editing app, but after six hours of editing the first episode on the tiny screen, it was too difficult. Then, I discovered iMovie on my laptop and this opened whole new possibilities. I hope viewers notice an improvement in the quality of the videos from the first to the last. I'm quite pleased with how this series turned out and I am thinking of continuing it for future operas._

> "One my big objectives for Lyric is for it to be not only a cultural center of Chicago, but the opera house open to all of its communities – the opera house of everybody."

_Attila_ is not a title one comes across often, at least not at American opera houses. For Mazzola, selecting repertoire is part of a broader roadmap he outlines both for himself and for the companies he works with.

**EM:** _In the last ten years I have conducted a lot of bel canto repertoire and I have many more Verdi plans for the future with Lyric. There’s a personal element for me: I like very much to make connections between pieces, in how I develop my repertoire. For example, if I want to conduct_ Aida_, then I first want to conduct earlier Verdi. I feel this great heritage Verdi is taking from the bel canto traditions before him and I love following how he transforms those forms into something new and makes them his own. Generally speaking, I love seeing how composers develop and how their language changes over the course of their lives. For example, like_ I due Foscari _– I feel the darkness of_ I due Foscari _is like a precursor to_ Simon Boccanegra_. Also, I feel these early Verdi operas are still sadly underestimated today and I am fighting this underrepresentation of early Verdi._

> It's clear Maestro Mazzola already has one foot firmly planted in his newly adopted hometown.

As the incoming music director of a major American opera house, Mazzola is ever mindful of the present moment and the role of a company of Lyric's stature in serving the community. "Opera houses cannot simply circulate the same ten major titles," he says. "It's our duty to offer audiences opportunities to experience new works." One such offering was to be _Blue_ by Tony Award-winning composer Jeanine Tesori and NAACP Theatre Award-winning librettist Tazewell Thompson. Mazzola was slated to conduct the Chicago premiere of this 2019 opera about an African American couple in Harlem, anticipating the birth of their firstborn son, and navigating a cultural landscape of racism, violence, and reconciliation. Unfortunate COVID cancellations will postpone this event to a future season. Nonetheless, the message of the piece reflects Mazzola's goals for Lyric's profile as it enters the next decade of the 21st-century. Reiterating his views from earlier conversations, Mazzola goes on to say:

**EM:** _One my big objectives for Lyric is for it to be not only a cultural center of Chicago, but the opera house open to all of its communities – the opera house of everybody. Being music director of a major institution like Lyric is more than just high artistry as a conductor. It’s a position of great responsibility, of making decisions beyond just rhythms and phrases, but that address social aspects as well._

Despite Lyric's cancelled season, the company is putting on virtual events that highlight its artists, including a recital featuring members of the Ryan Opera Center to be premiered on February 21, 2021. ["Sole e Amore"](https://www.lyricopera.org/shows/upcoming/2020-21/sole-e-amore/), the brainchild of Mazzola, is a program of songs—not arias—by Italian operatic masters, including Donizetti, Bellini, Puccini, and Mascagni, among others. As the title of the recital suggests, love is the central theme of the program, but love in various guises and relationships: love/religion, love/passion, love/seduction. Singers from the ROC will be accompanied by Maestro Mazzola himself at the piano. "I thought it is important for the future music director to be in close contact with the Ryan Opera Center. I wanted to do a project just with them and to get to know them. I want to be a good ambassador for them both in our city and abroad."

"Our city" – It was a phrase that came up often in our conversation. . It's clear Maestro Mazzola already has one foot firmly planted in his newly adopted hometown. As he confessed, he is excited to spend his first holiday season in Chicago despite health restrictions and cancellations.

**EM:** _Although we had to make the difficult decision to cancel this season, I feel my place is to be here in Chicago. I want to be with my people, I want to encourage the company and support everyone. I am an optimistic, positive person by nature and I want to send this message to everyone. Of course, we are currently in a horrible situation, but a temporary situation. I know that we will be back soon and with double the energy – this is the message I want to pass on to everyone._

All I could say to that was: "Bravo ed auguri, Maestro!"