+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = "2019-05-22T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "[_Dido_](https://www.eno.org/whats-on/dido/) runs at the Unicorn Theatre through 2 June."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1558571246/media/2019/05/sqEyraNormanasBelindainDidoattheUniocrnTheatre.jpg"
primary_image_credit = "Eyra Norman as Belinda in Dido at the Unicorn Theatre, English National Opera, 2019. Photo: Tristam Kenton."
related_articles = ["articles/aria-guides-didos-lament.md"]
related_companies = ["scene/companies/english-national-opera.md"]
related_people = ["scene/people/njabulo-madlala.md", "scene/people/rachael-lloyd.md"]
short_description = "The sense of companionship the chorus seemed to share extended to their singing which was some of my favourite of the afternoon. Together with the 7-piece ensemble led by conductor Valentina Peleggi they created some absolutely sublime, stylistically considered music."
slug = "youthful-collaborative-dido-at-the-unicorn-theatre"
title = "Youthful & collaborative Dido at the Unicorn Theatre"
youtube_url = ""

+++
This stripped back and updated version of Purcell's classic [_Dido and Aeneas_](https://www.eno.org/whats-on/dido/) is a joint effort between the English National Opera and the Unicorn Theatre; one of the UK's leading theatre companies for young audiences. In this reimagined version of the opera, the three main characters become the centre focus as we watch Dido struggle to raise her teenage daughter, Belinda on her own. This take on the opera removes the magical and mystical elements of the original story and updates it for the modern audience, giving a greater sense depth and meaning to Dido's suffering, breakdown, and eventual death.

>As the audience took their seats in the intimate Weston theatre, the performers were already on stage chatting and preparing themselves for the performance.

Former Artistic Director of the Unicorn, Purni Morell returns to direct this production, exhibiting a deft familiarity with staging of youth theatre in this colourful, simplistic, and collaborative imagining of the piece. There was a real sense of camaraderie amongst the performers which led me to believe that the process of putting this piece together would have been a very collaborative and organic one.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1558571379/media/2019/05/RachaelLloydasEyraNormanasBelindainDidoattheUnicornTheatre.jpg){{% /md %}}

<figcaption>Rachael Lloyd as Dido and Eyra Norman as Belinda in Dido at the Unicorn Theatre, English National Opera, 2019. Photo: Tristam Kenton.</figcaption>

</figure>

Morell played with the idea of the actors taking on their roles in a way that commented on the artistic process. As the audience took their seats in the intimate Weston theatre, the performers were already on stage chatting and preparing themselves for the performance. The wings of the stage were open for the audience to see and there was never a moment when the performers weren't visible though throughout, they would noticeably switch from "actor" to "character" as they moved around the stage and interacted with each other between singing.

>Together with the 7-piece ensemble led by conductor Valentina Peleggi they created some absolutely sublime, stylistically considered music.

This was an interesting take on the traditional Greek chorus which was most effective at the very end of the piece when the chorus sing the glorious "with drooping wings" as a farewell to Dido. During the postlude the chorus begin to reset the stage and we understand that they have once again become themselves once again and with a heavy poignancy, the performance ends.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1558571394/media/2019/05/RachaelDidoEyraNormanasBelindainDidoattheUnicornTheatre.jpg){{% /md %}}

<figcaption>Rachael Lloyd as Dido and Eyra Norman as Belinda in Dido at the Unicorn Theatre, English National Opera, 2019. Photo: Tristam Kenton.</figcaption>

</figure>

The sense of companionship the chorus seemed to share extended to their singing which was some of my favourite of the afternoon. Together with the 7-piece ensemble led by conductor Valentina Peleggi they created some absolutely sublime, stylistically considered music. Where the chorus could have been a more effective communicative tool was in their staging. Morell often had them stand and deliver the choruses straight on to the audience which, though it is very much in line with the tradition of the impassive yet sympathetic commentating Greek chorus, it lacked engagement, physical variation, and interest. It was a real missed opportunity.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1558571405/media/2019/05/NjabuloMadlalaasAeneaDanielRudgeoftheChorusinDidoattheUnicornTheatre.jpg){{% /md %}}

<figcaption>Njabulo Madlala as Aeneas and Daniel Rudge of the Chorus in Dido at the Unicorn Theatre, English National Opera, 2019. Photo: Tristam Kenton.</figcaption>

</figure>

In general, there seemed to be a lack of clear character motivation where it counted, particularly in the interactions between Dido, played by mezzo soprano Rachel Lloyd and Belinda, played by soprano Eyra Norman. This relationship is the crux of the piece and central to the story they have chosen to tell in this production.

>This production reimagined Purcell's time-honoured piece in a way that was original and sensitively done despite its downfalls.

They made the decision to cast Belinda very young (Norman is a teen in her first year of music studies at university) and therefore has an appropriately light and undeveloped sound. Though she gave a very accomplished performance for her age, she lacked the ability to match Lloyd in their dramatic interactions. There needed to be a stronger bond between the two and a clearer sense of Dido's erratic, and frighteningly deranged tendencies on Lloyd's part. The level of emotional intensity required simply wasn't there.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1558571417/media/2019/05/RachaelLloydasDidoEyraNormanasBelindainDidoattheUnicornTheatre.jpg){{% /md %}}

<figcaption>Rachael Lloyd as Dido and Eyra Norman as Belinda in Dido at the Unicorn Theatre, English National Opera, 2019. Photo: Tristam Kenton.</figcaption>

</figure>

Similarly, Njabulo Madlala in the role of Aeneas gave a somewhat emotionally tepid performance. He has an incredible instrument which was constrained by the limits of the small theatre, but it was a self-conscious performance that lacked the sharp severity of Aeneas' character needed to justify Dido's heartbreak. Clear diction was lacking here as well as Madlala had a tendency towards an over darkened sound. I was hoping for clearer text across the board. It is one thing for those know are familiar with the opera but for the many young people and newcomers to opera in the audience, I fear there would have been a lot that was missed out.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1558571428/media/2019/05/EyraNormanasBelindacentralwiththeChorusinDidoattheUnicornTheatre.jpg){{% /md %}}

<figcaption>Eyra Norman as Belinda (central) with the Chorus in Dido at the Unicorn Theatre, English National Opera, 2019. Photo: Tristam Kenton.</figcaption>

</figure>

This production reimagined Purcell's time-honoured piece in a way that was original and sensitively done despite its downfalls. Re-invention is the way that we move opera forward into the future and I think younger audiences should always be included in this process, but a lot seems to be done in the name of "accessibility" and in having these conversations, we need to be conscious of not underestimating audiences. Nevertheless, it was a joy to see this timeless story being enjoyed by a theatre full of young people.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1558571438/media/2019/05/NjabuloMadlalaasAeneasRachaelLloydasDidoinDidoattheUnicornTheatre.jpg){{% /md %}}

<figcaption>Njabulo Madlala as Aeneas and Rachael Lloyd as Dido in Dido at the Unicorn Theatre, English National Opera, 2019. Photo: Tristam Kenton.</figcaption>

</figure>