+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = "2019-02-13T17:11:56+00:00"
disclaimer = ""
image_gallery = []
postamble = "ENO's production of _Akhnaten_ runs through 7 March. For details and tickets, [click here](https://www.eno.org/whats-on/akhnaten/)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1550078281/media/2019/02/sqENOAkhnaten2019KatieStevensonandAnthonyRothCostanzoJaneHobson.jpg"
primary_image_credit = "Anthony Roth Costanzo and Katie Stevenson in Akhnaten, English National Opera, 2019. Photo: Jane Hobson."
related_articles = ["articles/transparent-glass-the-composer-turns-80.md"]
related_companies = ["scene/companies/los-angeles-opera.md", "scene/companies/english-national-opera.md"]
related_people = ["scene/people/anthony-roth-costanzo.md"]
short_description = "Every bit of this production was beautifully and intricately crafted; from the dazzling, elaborate costumes, to the evocative colour palette, it was a fully immersive experience that was moving in the most unexpected ways."
slug = "a-moving-spectacle-akhnaten"
title = "A moving spectacle: Akhnaten"
youtube_url = ""

+++
[_Akhnaten_](https://www.eno.org/whats-on/akhnaten/) (1983) is the final in Philip Glass's trio of "Portrait" operas and centres around the 17-year reign of 18th-Dynasty Egyptian Pharaoh Akhnaten. The operas each focus on a great historical figure while exploring the fields of science, politics and in the case of _Akhnaten_, religion. A worshipper of the sun god, Aten, Akhnaten moved Egypt towards a quasi-monotheistic view which it has been speculated, may have partially inspired the monotheistic religion now known as Judaism. In this Olivier Award-winning joint production between the ENO, LA Opera, and Improbable, Glass's mesmerizing score is brought to life in a transcendent and moving spectacle.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1550078416/media/2019/02/ENOAkhnaten2019AnthonyRothCostanzoandGandiniJugglersJaneHobson.jpg){{% /md %}}

<figcaption>Anthony Roth Costanzo and the Gandini Jugglers in Akhnaten, English National Opera, 2019. Photo: Jane Hobson.</figcaption>

</figure>

Every bit of this production was beautifully and intricately crafted; from the dazzling, elaborate costumes, to the evocative colour palette, it was a fully immersive experience that was moving in the most unexpected ways. Glass's minimalistic, pulsating score rolled endlessly on, supporting a rich, and reverent performance piece. Director Phelim McDermott elevated this piece to a very exciting place, challenging the traditional structures and limitations of opera to create a piece that was spectacular and theatrical. The score lends itself well to a more experimental style of production, but I think it was primarily McDermott's experience in experimental theatre with his company Improbable that inspired such an imaginative production.

> Some of the most astounding vocal writing was in the intertwining of Akhnaten and Nefertiti's voices.

Though visually stunning and an impressive design feat with lighting design by Bruno Poet and set designs by Tom Pye, it was really a production that used the performers bodies and abilities to create art; a concept that is often lacking in opera and seen more regularly in circus, theatre, and dance productions. The production featured Gandini Juggling, a group of world-renowned jugglers who wowed the audience with their acrobatic antics. These skilled performers carried the piece forward performing complicated juggling routines choreographed to the music, as well as complicated lifts and acrobatics.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1550078483/media/2019/02/ENOAkhnaten2019ZacharyJamesJaneHobson.jpg){{% /md %}}

<figcaption>Zachary James in Akhnaten, English National Opera, 2019. Photo: Jane Hobson.</figcaption>

</figure>

It was a physically challenging piece for all the performers and one that was driven by an engaged, focused physical energy. Every movement on stage was in slow motion; an incredible physical challenge for even the most seasoned and physically adept performer. Counter-tenor [Anthony Roth Costanzo](/scene/people/anthony-roth-costanzo/) in the role of Akhnaten may have had the biggest challenge of all in that not only was the role vocally challenging but required a great amount of physical strength. There was quite a lot of stillness and careful calculated movement required and as his character was the focus of the audience's attention, every move he made was viewed under a microscope. He employed an impressive amount of physical and mental control to achieve this in a remarkably effective way.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1550078574/media/2019/02/ENOAkhnaten2019AnthonyRothCostanzoJaneHobson.jpg){{% /md %}}

<figcaption>Anthony Roth Costanzo in Akhnaten, English National Opera, 2019. Photo: Jane Hobson.</figcaption>

</figure>

The singing was secondary to work overall, simply becoming an integral part of the texture. The text, sung in English and taken from the original Egyptian found by archaeologists on what remained of Akhnaten's reign, was minimal. Most of this text was spoken by the character of the scribe played by bass Zachery James who gave some very powerful orations. Very little of the text was sung at all and that which was, was nearly intelligible. There were great lapses of instrumental interludes interspersed with technically challenging, repetitive polytonal chords that were more about creating an atmosphere than about storytelling through melodic singing.

> There was a timelessness to the score; it was both archaic and ever-surprising.

The most traditional bit of singing was Akhnaten's hymn to Aten in which Glass created a baroque passacaglia like base line over which Costanzo's ethereal counter-tenor hovers. Some of the most astounding vocal writing was in the intertwining of Akhnaten and Nefertiti's voices with each other and with the voices of their six daughters as they all sing in the same range crossing over each other and blending into one. It was a very effective way to establish the intimate, and devoted love between Akhnaten and Nefertiti and the familial relationship to their children. In a way, it was very challenging music to listen to. It wasn't always beautiful and required patience. There were moments when I felt it was growing tiresome, when I felt it was requiring my focus for too long with too little plot development. But it was a challenge that ultimately rewarded the listener with music that is poignant, generous and fulfilling.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1550078636/media/2019/02/ENOAkhnaten2019KatieStevensonAnthonyRothCostanzoRebeccaBottoneandZacharyJamesJaneHobson.jpg){{% /md %}}

<figcaption>Katie Stevenson, Anthony Roth Costanzo, Rebecca Bottone, and Zachary James in Akhnaten, English National Opera, 2019. Photo: Jane Hobson.</figcaption>

</figure>

This was a transcendent experience and moving in a way I couldn't have predicted. There was a timelessness to the score; it was both archaic and ever-surprising. The entirety of the piece carried a great weight and a sense of reverence. I found myself struck by the feeling that time is not linear. That important events in history have a way of seeping through time to change the course of the future. This is not the first opera to be written about ancient Egypt nor is it by far the first one to be written about a significant historical figure, but it does so in a way that is unique, introspective, and completely captivating.