+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2017-01-27T12:33:00+00:00"
lastmod = "2017-01-27T14:40:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1485526137668/2017-01-27---Library.jpg.jpg"
publishDate = "2017-01-27T14:34:00+00:00"
short_description = "Perhaps my knowledge of singing technique and what it takes to create opera puts me among the &quot;elite&quot; (or maybe it&#039;s even a form of &quot;opera privilege&quot;). It doesn&#039;t change the fact, though, that the more you know, the more you hear. If you know the singers personally, their performances are more meaningful. If you know the score well, you can hear the choices being made by different artists."
slug = "enjoying-opera-its-not-snobby-to-be-informed"
title = "Enjoying opera: it&#039;s not snobby to be informed"
+++

The other night, I was at a performance of the Royal Opera's *La traviata*, and a strange thing dawned on me: there just may be a legitimate case for being "elitist" with opera.

Now, I don't mean that people have a right to be snobby. I only mean that there are rich rewards in store for the person who does their homework.

This elitist-apologist stance occurred to me during *La traviata* because it's an opera I know well. I've seen it many times, I've studied and played the score, and I've coached singers in most of the roles. And instead of getting bored by hearing *yet another Trav*, all the knowledge I had of the piece simply amplified my enjoyment of Richard Eyre's famed production at ROH. (Now, that doesn't always happen. Often I'm simply not in the mood for yet another *Magic Flute* or yet another *Barber of Seville*. *Traviata*, decidedly, has a special place in my heart.)

Like many of you, readers, I'm aware that I go to hear an opera with a different set of tools than the average person; just like how every movie-goer isn't an actor, not every opera-goer has played opera scores, or even seen very many operas at all. Being knowledgeable about opera doesn't make you a "better" audience member, but it certainly lets you get more out of the performance.

Perhaps my knowledge of singing technique and what it takes to create opera puts me among the "elite" (or maybe it's even a form of "opera privilege"). It doesn't change the fact, though, that the more you know, the more you hear. If you know the singers personally, their performances are more meaningful. If you know the score well, you can hear the choices being made by different artists.

These things are true, and I reap the rewards every time I go to the opera. The more I've learned about it, the more I notice how I respond more viscerally to live opera, laughing out loud or weeping shamelessly. I've become a champion of the singers, knowing that they're kind and generous people who work their asses off to do their jobs. I've spent time backstage at opera houses, so I'm wowed by stunning sets and well-done theatrical sleight-of-hand.

Learning to love opera is like learning how to cook or [save money](/how-much-money-makes-an-artist/) or speak a [new language](/6-creative-ways-to-learn-a-language-affordably/): the more you put into it, the more you get out of it.

But why, you ask, should people put in the time to learn about something like opera? Because frankly, it's worth it. Opera is bigger than you; it's universal in that the human voice profoundly affects us all, and it's superhuman in that the singers onstage are among the very, very few who can do what they do. Opera has always been a form of escape, and in the 21st century, it's also a chance to turn off our phones and slow down.

It's absolutely worth it do a YouTube search for 5 different renditions of "Un bel dì vedremo", or check out [interviews with singers](https://www.youtube.com/channel/UCbNNVvl8UZY-3ghpG2YhTtg/videos) about how they work. If you live near a major opera house, they may offer backstage tours to the public. If you go to the opera, show up early and catch the pre-show talk. These are the operatic equivalents of "Making of..." specials and biographical documentaries; if you've seen [*Amy*](http://www.imdb.com/title/tt2870648/), or [*What Happened, Miss Simone?*](http://www.imdb.com/title/tt4284010/), you know what I mean.

After all that studying, you may just feel like a member of the opera elite. No one *actually* cares about that (except a passionate few), and what's more important is this: in the best-case scenario, your eyes and ears are opened to better operatic expreriences, and in the worst-case scenario, you can say you're not an opera fan, this time with conviction.
