+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = 2021-10-24T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Enigma Chamber Opera's _Curlew River_ will be [available to stream](https://www.eventbrite.com/e/enigma-chamber-opera-presents-benjamin-brittens-curlew-river-tickets-180418415337) October 29-November 5."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1635101011/media/2021/10/sqEnigmaOpera_CurlewRiver_Matthew_DiBattista_and_Linus_Schafer_Goulthorpe_in_Enigma_Chamber_Opera_s_CURLEW_RIVER_Photo_by_Ashlee_Rose_Scott_gq2vjl.jpg"
primary_image_credit = "Michael DiBattista as the Madwoman and Linus Schafer Goulthorpe as Spirit of the Boy in Enigma Chamber Opera's Curlew River, 2021. Photo: Ashlee Rose Scott."
related_articles = ["articles/death-in-venice.md"]
related_companies = []
related_people = []
short_description = "I chose my words very carefully when I call this Curlew River a transcendent experience: I am afraid I cannot fully explain the power that this particular production had and why it had that power, but I remember leaving the Cathedral Church of St. Paul feeling somewhat transformed by the experience. "
slug = "enigma-operas-curlew-river-a-transcendent-experience"
title = "Enigma Opera’s Curlew River a transcendent experience"
youtube_url = ""

+++
Whenever someone thinks of an opera, one of the first things that comes to mind is inevitably the scale of opera: typically, even at its most intimate it feels like it exists on a scale far grander than anything most people could ever put together. Thus, Benjamin Britten’' church operas present an interesting production challenge: what does a work specifically designed for performance in a church look like? And how does one convey anything like setting and such in a building with an immutable purpose?

[Enigma Chamber Opera](https://www.facebook.com/enigmachamberopera/), a company formed just before the pandemic hit, sought to return to live performance with his _Curlew River_, and the answer they turned to was, for the most part, to play into a particular production conceit of the whole performance being a passion project more or less staged by poorer people, with the idea being that the production is a gift to us that the performers use to impart a message of "take comfort, things will get better". For my money, it was a production conceit that worked quite well on the whole, because it felt very integrated into the church setting.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1635101164/media/2021/10/EnigamOpera_CurlewRiver_The_cast_of_Enigma_Chamber_Opera_s_CURLEW_RIVER_Photo_by_Ashlee_Rose_Scott_bqu4qj.jpg){{% /md %}}

<figcaption>The cast of Enigma Chamber Opera's Curlew River, 2021. Photo: Ashlee Rose Scott.</figcaption>

</figure>

For one thing, I distinctly remember when the performance started with a single singer starting the plainchant that opens the work from within the audience. It was a little bit of a shock to further realize that most of the other players were also seated within the audience for the introduction (including David McFerrin as the Traveller, who just happened to be seated in front of me at the beginning of the performance), but it ended up conveying a sense of communion between performer and audience that played right into the way the character of the Abbot addresses the audience throughout the show's runtime.

It also provided an interesting outlet for the costuming and the props: the yew tree that formed a grave for a child was constructed from cut-up umbrellas, and most of the singers paraded around in either service worker outfits or the kind of thing I might expect a homeless person to wear.

It was a fairly solid production conceit, but ultimately such production conceits tend to fade into the background when you consider it was staged in a church where, by necessity, you cannot dress the venue too much. The focus, therefore, remains solidly on the music and the performances therein, and both were quite strong.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1635101195/media/2021/10/EnigmaOpera_CurlewRiver_Linus_Schafer_Goulthorpe_as_Spirit_of_the_Boy_in_Enigma_Chamber_Opera_s_CURLEW_RIVER_Photo_by_Ashlee_Rose_Scott_j45ntw.jpg){{% /md %}}

<figcaption>Linus Schafer Goulthorpe as Spirit of the Boy in Enigma Chamber Opera's Curlew River, 2021. Photo: Ashlee Rose Scott.</figcaption>

</figure>

I admit to not being familiar with Britten's church operas before this production of _Curlew River_, and now that I have seen it I have to say they present a very intriguing duality I have never seen in an opera, and that I wish more opera would exhibit. There is an uncannily ritualistic quality to the music of _Curlew River_, perhaps owing to the intersection of Christian morality plays and the Japanese Noh tradition; tempo-wise, it moves rather slowly, and a vast majority of the music is heavily heterophonic a lot of the time.

At the same time, however, it also has to balance that with being a vehicle for a certain kind of drama, and here Britten balances this with how he writes for his voices, and also breaking up the action with a few recognizable motifs that center parts of the drama. And of course, there is Britten's reliably functional vocal writing, which imparts strong character throughout.

For my money, there were two displays where this is best exemplified. The first case is in the writing of the Madwoman, who here was played to rather striking effect by Matthew DiBattista. This is a role that is no doubt very demanding on a singer on all fronts, something that is admittedly helped by how Britten writes the part; the vocal writing alternates frequently between mad chittering and slower, clearer lines that help the singer navigate a part that alternately has to be the most obtuse and the clearest role in the whole opera.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1635101234/media/2021/10/EnigmaOpera_CurlewRiver_Aaron_Engebreth_front_plays_the_Ferryman_in_Enigma_Chamber_Opera_s_CURLEW_RIVER_Photo_by_Ashlee_Rose_Scott_k1u6na.jpg){{% /md %}}

<figcaption>Aaron Engebreth (front) as the Ferryman in Enigma Chamber Opera's Curlew River, 2021. Photo: Ashlee Rose Scott.</figcaption>

</figure>

But of course, this is nothing without an effective actor as the singer, and DiBattista absolutely delivered as the Madwoman here: his singular search for his child allowed him to really play into it. I remember when the Ferryman who ferries her down the titular fictional river relates the tale of a boy who was left to die by the church: my eyes were only on DiBattista, whose expression slowly dawned in realization that the dead child was in fact hers, and the way she cowered into herself even as the music moved on instilled a certain pathos in me as I watched.

But then comes the climax of _Curlew River_; this is one of those rare opera climaxes that makes the opera, in that it feels like the inevitable climax the work demands and it performs exactly the function that it needs to perform to tie the rest of the work together. Musically, it kind of creeps up on you: the voice of the child soprano that plays the spirit of the Madwoman's child emerges from out of the chamber orchestra's sound so suddenly that, just like the characters, you can hardly believe it is there.

And then, the child repeatedly comes back in, soaring above the resonance left from the orchestra's rather loud chords at that point. And then, he comes out, sings words of comfort to his mother, and promptly leaves. In total, the child is only singing for two minutes in the whole work, but they are the two most important minutes of the work, and the success of any _Curlew River_ lives or dies on this moment.

This production pulled this moment off beautifully: they had young singer Linus Schafer Goulthorpe (who I found to be much improved from when I last saw him in NEMPAC's Little Prince a couple of years ago) emerge from the back of the orchestra holding a flashlight in a way that was quite sudden but fit in with the way his voice rises from the texture.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1635101257/media/2021/10/EnigmaOpera_CurlewRiver_Matthew_DiBattista_as_the_Madwoman_in_Enigma_Chamber_Opera_s_CURLEW_RIVER_Photo_by_Ashlee_Rose_Scott_unwafh.jpg){{% /md %}}

<figcaption>MIchael DiBattista as the Madwoman in Enigma Chamber Opera's Curlew River, 2021. Photo: Ashlee Rose Scott.</figcaption>

</figure>

Schafer Goulthorpe has to ground the entire rest of the work, and he absolutely rose to the occasion, with a fully confident singing voice and some beautifully directed hand gestures with DiBattista. The whole moment left me teary-eyed, and it all coalesced into what is, to me, a transcendent experience.

To be sure, there were lots of other moving parts: Aaron Engebreth's Ferryman imparted a lot of strength of character that made for a good foil against the Madwoman, and David McFerrin provided an empathetic traveller who really aligned with the her in a really nice way. Paul Soper also deserves props for stepping in for James Demler at the last minute as the Abbot who narrates the work. But these, like the projections that were flashed onto the back of the church walls, very quickly faded away from my awareness in the face of the work's climax.

I chose my words very carefully when I call this _Curlew River_ a transcendent experience: I am afraid I cannot fully explain the power that this particular production had and why it had that power, but I remember leaving the Cathedral Church of St. Paul feeling somewhat transformed by the experience.

It is exceedingly rare that I can say that an opera has left me feeling this particular way, but it is moments like that which makes me love the art form so much.