+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2014-11-11T13:37:00-05:00"
lastmod = "2015-04-13T23:12:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428981045243/luciano-pavarotti-720x1081.jpg.jpg"
publishDate = "2014-11-11T13:37:00-05:00"
related_articles = ["articles/fab-nights-whose-opera-is-it-anyway.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md"]
short_description = "I was in rehearsal for an upcoming concert, and the only thing left to look at was the encore. I always feel like a lame impostor, rehearsing an encore. "
slug = "encore"
title = "Encore?"
+++

I was in rehearsal for an upcoming concert, and the only thing left to look at was the encore. I always feel like a lame impostor, rehearsing an encore. The whole idea of the encore is that it's a repetition of a song that the audience clearly loved ("encore" is French for "again"), or it's a bonus number, understood that it's of the _impromptu_ sort. So here I am, rehearsing my spontaneity, all the while assuming (somewhat narcissistically, I might add) that the audience will love me so much that they will _demand_ more. It's one of those conundrums of Classical music that's hard to defend to the layperson.

The word "encore" comes from the French for "again"; but we all knew that, and I did some more digging on the history of the encore. Before the time of recorded music, an encore was the only way someone could hear their favourite song again. It was like putting a song on repeat. If it was a bonus-track-type of encore, it wasn't the crowd-pleaser of the night; it was likely a more obscure piece, perhaps newly written yet uncirculated. When you think about it, it's almost more of a compliment to warrant an encore when the audience has already heard your greatest hits. Today, it's traditional to save something light, funny, famous, or jaw-dropping for the encore, and audiences are in on the plan, too. Maybe today's classical musicians are passive-aggressively securing themselves an encore by withholding the most desirable music all night long.

In the world of opera, encores are pretty rare. I think it's a really special moment for the singer, but others disagree. Toscanini famously banned encores at La Scala and The Metropolitan Opera for the better part of the 20th century, saying they brought too much focus to individual singers and broke the flow of the opera. The bans are also in place to avoid show times running long and costing the companies in overtime pay. The bans have been broken a few times, mostly by irreverant tenors. Peruvian high-note-machine [Juan Diego Flórez](https://www.youtube.com/watch?v=3aS6M8j3pvQ) actually broke _both_ encore bans, 9 high Cs at a time, with "Ah, mes amis" from _La fille du regiment_; he encored it at La Scala in [2007](http://seattletimes.com/html/nationworld/2003586868_encore24.html), and at the Met in [2008](http://www.theguardian.com/music/2008/apr/24/classicalmusicandopera.world). _Plus_,[ he did it again](https://www.youtube.com/watch?v=JQY19jmxCvI) at the Met in 2012 with "Una furtiva lagrima", complete with new high notes for the second cadenza. Earlier this year, Mexican tenor [Javier Camarena](http://www.wqxr.org/#!/story/javier-camarena-gives-rare-encore-metropolitan-opera/) also sang an encore of "Si, ritrovarla" during the Met's _La Cenerentola_ (fun fact: he was filling in for Juan Diego Flórez). Naturally, [Luciano Pavarotti](https://www.youtube.com/watch?v=p8-APBmCQyQ) broke the Met's encore ban too, reprising "E lucevan le stelle" during the [1994 _Tosca_](http://www.nytimes.com/1994/10/07/arts/opera-review-vaness-and-pavarotti-in-tosca.html) with Carol Vaness.

While we're on the subject of records, Pavarotti had the most curtain calls ever recorded: 165, after a 1988 performance of _L'elisir d'amore_ at the Deutsche Oper Berlin. Apparently the applause lasted 1hr, 7 minutes, less than his personal record of 1hr, 30 minutes. Plácido Domingo, not to be forgotten, enjoyed a 1hr, 20 minute applause after a 1991 _Otello_ at the Wiener Staatsoper, with 101 curtain calls in total (there's a bit of [discrepancy](http://www.mervinblock.com/?q=node/34) over the details of this record, but they still average out to _impressive_). What is _with_ these tenors?

Perhaps Toscanini was right, that encores miss the point of the opera as a whole experience, that it's tacky for one singer to steal the night. But take, for example, a performance like [Rolando Villazón's](https://www.youtube.com/watch?v=h8_AfrqbT5k) as Nemorino in the Weiner Staatsoper's _L'elisir d'amore_ in 2005\. He sings "Una furtiva lagrima" (again with the Donizetti-tenor combo-pack!) and brings down the house, finally singing it, beautifully, again. And, I mean, look at [these eyes](http://www.youtube.com/watch?v=h8_AfrqbT5k&t=5m4s). If Rolando's face doesn't tell you what a special experience an encore is for a singer today, I refer you to [these eyes ](http://www.youtube.com/watch?v=h8_AfrqbT5k&t=5m37s)instead. Oh, just watch the whole thing:

My point is this: encores are anti-dramatic, and they miss the big operatic picture. But, you know, if a singer has worked their tush off to sound the way they do, and the audience reacts in proportion to that mountain of work, I'd say a bow is in order. Singers get instructed up to their eyeballs their whole life long. If they get the chance to have That Moment they're all striving for, sit back and let them have it.
