+++
author = ["authors/oliver-munar.md"]
categories = "Review"
date = 2022-01-01T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Calgary Opera’s production of Ravel's _The Enchanted Child_ (_L'enfant et les sortilèges_) ran December 10-12 at the Mamdani Opera Centre. Directed by Rob Herriot with a chamber orchestra conducted by Mark Morash, the production featured all eight artists of the McPhee Artist Development Program singing in French with English subtitles. Calgary Opera's next production is in January-February 2022, with Lehar's [_The Merry Widow_](https://calgaryopera.com/21-22/merry-widow)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1640984509/media/2021/12/sqEnfant_CalgaryOpera_Photo1-Company_cwdcnl.jpg"
primary_image_credit = "Surrounding Alanna Fraize from bottom left: Jeremy Dubé, Simran Claire, Jeffrey Strand, Eden Tremayne, Tayte Mitchell, Dominic Veilleux and Juliana Krajčovič in Calgary Opera's L'enfant et les sortileges, 2021. Photo by Kaitlyn Kerr."
related_articles = ["articles/calgary-opera-names-jonathan-brandani-new-artistic-director.md", "articles/calgary-opera-delivers-comedy-gold-with-wellcast-barber.md"]
related_companies = ["scene/companies/calgary-opera-emerging-artist-development-program.md", "scene/companies/calgary-opera.md"]
related_people = ["scene/people/jeffrey-strand.md", "scene/people/simran-claire.md", "scene/people/dominic-veilleux.md", "scene/people/eden-tremayne.md", "scene/people/alanna-fraize.md", "scene/people/andrew-love.md"]
short_description = "On this night, the company’s full roster of emerging artists (now branded as the McPhee Artists in honour of the company’s longtime Artistic Director and CEO) enchanted the audience with a whimsical production that the whole family would enjoy. "
slug = "enchanting-production-brings-calgary-opera-back-to-live-in-person-audience"
title = "Enchanting Production Brings Calgary Opera Back to Live, In-Person Audience"
youtube_url = ""

+++
Performing for an online audience is one thing. It's altogether different when your audience is staring at you wide-eyed in the same room, waiting for you to enchant them with your performance. For the first time in twenty months, [Calgary Opera](/scene/companies/calgary-opera/) has a live audience for one of its productions, Ravel's _The Enchanted Child_ (_L'enfant et les sortilèges_).

On this night, the company's full roster of emerging artists (now branded as the [McPhee Artists](/scene/companies/calgary-opera-emerging-artist-development-program/) in honour of the company's longtime Artistic Director and CEO) enchanted the audience with a whimsical production that the whole family would enjoy.

First performed in 1925, _L'enfant_ is the story of an unnamed brat of a child who learns a valuable lesson on how they interact with the world around them, when innocuous objects spring to life. From the pet cat to the grandfather clock to a book of fairy tales, the McPhee Artists, most of whom are cast in multiple roles, bring Ravel's music to life. It is music that Calgary Opera has included in its offering before; the company last produced this whimsical opera in 2015 as a vehicle for the emerging artists program.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1640982183/media/2021/12/Photo1-Company_xqpprl.jpg){{% /md %}}

<figcaption>Surrounding Alanna Fraize from bottom left: Jeremy Dubé, Simran Claire, Jeffrey Strand, Eden Tremayne, Tayte Mitchell, Dominic Veilleux and Juliana Krajčovič. Photo by Kaitlyn Kerr.</figcaption>  
</figure>

#### Honouring the late Bob McPhee

Calgary Opera announced the rebranding of its emerging artists program in November 2021 in honour of the late Bob McPhee, who served as the company's general director and CEO from 1998 to 2017. McPhee died in March 2021 after a long battle with cancer.

"The Emerging Artist Program was one of Bob's 'Big Hairy Audacious Goals'," says Mel Kirby, Manager of the [McPhee Artist Development Program](/scene/companies/calgary-opera-emerging-artist-development-program/). "I always think of it as 'his' program: he was proud of it, he got energy from it."

McPhee's reach went well beyond Calgary Opera. During his tenure as President and CEO of the Edmonton Symphony Society and Edmonton Concert Hall Foundation, McPhee led both organizations to the on-time, on-budget completion of the Francis Winspear Centre for Music, one of the premiere concert halls in the country. "For all the work he'd done, nothing had his name on it," says Kirby. "Now with the McPhee Artist Development Program, there's something in the world that has Bob McPhee's name on it."

"It's such a beautiful way to honour him," says Calgary-born baritone [Andrew Love](/scene/people/andrew-love/), who was among the first singers to go through what is now the McPhee Artist Development Program. "He focused on Canadian singers - nobody else was doing that. So many of us owe him our careers and to think about how best to honour him, I think training young singers would be where he’d want his name attached."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1640982663/media/2021/12/Photo2-AndrewLove_BobMcPhee_mjgtl4.jpg){{% /md %}}

<figcaption>Calgary-born baritone Andrew Love (bottom right) with the late Bob McPhee (centre), surrounded by Elizabeth Turnbull, Ernesto Ramirez and Lida Szkwarek in the 2017 Calgary Opera production of Filumena (Estacio/Murrell). Photo courtesy of Andrew Love.</figcaption>  
</figure>

Love says McPhee's name carries a responsibility to be true to yourself: to do what you love and to deepen your relationship with your voice, your art and your talent. "I walked into the program knowing only three arias and the names of the operas those arias were from. The program will help you figure it out. Your biggest responsibility is how you present yourself, both on and off stage."

#### McPhee Artists deliver magical performance

On this night, the current roster of McPhee Artists would certainly make their program's namesake proud.

The performance was anchored by the strong performance of mezzo soprano [Alanna Fraize](/scene/people/alanna-fraize/). The Newfoundland-born singer is blessed with a warm, silky voice that is well suited for the role of the Child, who is on stage for the whole opera. From throwing a tantrum to expressing fear and then remorse, Fraize accesses beautiful vocal colours that complement her wide array of acting skills befitting of the role.

The award for most costume changes would go to mezzo soprano [Simran Claire](/scene/people/simran-claire/), who played six roles including the two characters that bookend the response for the central Child: the Mother and the Squirrel. Claire shows great versatility and acting range for each of her roles. From her first entrance as the Child's colourful mother to her portrayal of the Squirrel (who sets the Child on the road to redemption), the audience can't help but be drawn by Claire's sultry stage presence and warm tone. Her cat duet with baritone [Jeremy Dubé](https://calgaryopera.com/202122mcphee-artists/m2zzmarnltf8j4u8feju6bgx0m47r8) is especially hilarious, conjuring up images of the famous cat duet by Gioachino Rossini.

While his turn as the male cat is crowd pleasing, baritone Jeremy Dubé impresses in his role as the Clock. Dubé is blessed with a piercing, rich sound that grabs your attention from the moment he starts to sing. In this time as a Clock without a pendulum, Dubé adds a welcome and exciting flair to the production.

Tenor [Tayte Mitchell](https://calgaryopera.com/202122mcphee-artists/lo56w9f584p7kenlf4kckx9m74qjfm) impresses in his portrayal of the Arithmetic Man, among the other ensemble roles he performed on this night. Mitchell's bright, full vocals were well matched with the frenetic nature of the Arithmetic Man's song, in which he leads the cast in a flurry of nonsensical mathematical equations.

As an English teapot, a dancing bear and a treefrog, [Jeffrey Strand](/scene/people/jeffrey-strand/) endears himself to the audience with grace and humour that complement his pleasing lyric tenor sound. His teapot-teacup duet with Simran Claire was especially well-performed on this night.

Not everyone can make a Chair or a Tree sound sultry, but the liquid tone of bass-baritone [Dominic Veilleux](/scene/people/dominic-veilleux/) brings Ravel's music to life. In his limited stage time, Veilleux stands out in both roles, first in a sultry chair duet and then as the sweet voice of a Tree who bleeds sap as a result of the Child’s actions.

Sopranos [Juliana Krajčovič](https://calgaryopera.com/202122mcphee-artists/67uhkcvobpfsgtnfmobmndp3cmh02k) and [Eden Tremayne](/scene/people/eden-tremayne/) turned in perhaps the most memorable performances on this night. In her roles as both the Princess and the Bat, Krajčovič shows great versatility with both her rich, robust voice and her acting ability. Tremayne navigates the composer's high-flying vocals with poise and ease, conquering the demanding coloratura passages that Ravel sets in the stratosphere. Tremayne’s roles as both Fire and the Nightingale were standout performances on this night.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1640982999/media/2021/12/Photo3-Fraize-Tremayne_thjqid.jpg){{% /md %}}

<figcaption>Eden Tremayne (right) and Alanna Fraize delivered standout performances in Calgary Opera's production of Ravel's The Enchanted Child. Photo by Kaitlyn Kerr.</figcaption>  
</figure>

Ravel’s orchestration for _L'enfant_ is quite extensive and lush, which would surely overpower the space of the Mamdani Centre. Calgary Opera reduced this requirement to four musicians: two pianists, a woodwind specialist playing both flute and piccolo, and a cellist. Led by the company's Music Director Mark Morash, the musicians offer a performance that sets the right balance for the production. Indeed, less was certainly more to allow the McPhee Artists to weave their magic with _The Enchanted Child_.