+++
author = ["authors/greg.md"]
categories = "Review"
date = "2017-11-11T14:13:00-05:00"
lastmod = "2017-11-11T21:42:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510427443354/2017-11-11---Jonathan-Crow_The-Lark-Ascending-Jag-Gundu.jpg.jpg"
primary_image_credit = "Jonathan Crow, TSO concertmaster. Photo: Jag Gundu."
publishDate = "2017-11-11T17:14:00-05:00"
related_companies = ["scene/companies/toronto-symphony-orchestra.md"]
related_people = ["scene/people/allyson-mchardy.md","scene/people/colin-ainsworth.md","scene/people/brett-polegato.md","scene/people/measha-brueggergosman.md"]
short_description = "AFGHANISTAN: Requiem for A Generation was not only a solemn concert to remember those men and women who have served, and just as importantly - continue to serve, in our Armed Forces, but also to remember those whose lives are touched by war. It was equal parts celebratory for our freedoms, respectful that we still have a way to go, and reverent to those who have gone before us."
slug = "emotional-nights-with-the-tso"
title = "Emotional nights with the TSO"
+++

It was a very emotional night at Roy Thomson Hall. Audience were greeted at the door by an honour guard on horseback outside the main doors, service men and women in uniform dotted the lobby, and the bright red of poppies leapt from the lapels of people milling about. 

*AFGHANISTAN: Requiem for A Generation* was not only a solemn concert to remember those men and women who have served, and just as importantly - continue to serve, in our Armed Forces, but also to remember those whose lives are touched by war. It was equal parts celebratory for our freedoms, respectful that we still have a way to go, and reverent to those who have gone before us. 

The program featured bagpipes and military trumpets along with readings interspersed with pieces by Ralph Vaughan Williams in the first half. The second half introduced another of the TSO's 40 commissions to celebrate #CANADA150. The evening rounded up with *AFGHANISTAN: Requiem for a Generation* by Jeffrey Ryan and Suzanne Steele, featuring an incredible lineup of Canadian supertalents. [Measha Brueggergosman](/scene/people/measha-brueggergosman/), [Allyson McHardy](/scene/people/allyson-mchardy/), [Colin Ainsworth](/scene/people/colin-ainsworth/), [Brett Polegato](/scene/people/brett-polegato/), The Toronto Mendelssohn Choir, and the Toronto Children's Chorus joined their mighty forces to present this important and relevant piece. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510427509234/2017-11-11---Afghanistan-Requiem-for-A-Generation_all--Jag-Gundu.jpg.jpg)
<figcaption>*Afghanistan: Requiem for a Generation*. Photo by Jag Gundu.</figcaption>
</figure>

The evening opened with four military bagpipers playing George Stewart's "The Unknown Soldier" a haunting tune that evoked the memorries of soldiers long lost to battle. Followed by a reading from "Creed" by Richard Diespecker, the TSO crept into the "Lento" (Mvt. II) from Vaughan Williams's *A London Symphony*. The orchestra, under the baton of Tania Miller, played sensitively and sensually. The plaintive song of the English horn was beautiful as each nuance of the score musically depicted the London cityscape in quiet anticipation of the turmoil that awaits with WWI on the horizon. 

Then the "Last Post" and "Reveille" bookended *Piper's Lament* (*Flowers of the Forest*) which is the official lament of the Canadian forces. To hear this music played by military musicians is something special indeed. Being a Cape Bretoner, obviously pipes and drums hold a dear place in my heart, but as most of you may know, I'm a huge emotional softy (and proud of it!) so needless to say, the "Last Post" destroyed me - as it always does. 

Wrapping up the first half was a reading of "For the Fallen" and then Vaughan Williams beautiful piece for violin and orchestra, *The Lark Ascending*. TSO violinist Jonathan Crow played the solo violin from the first level balcony seats adding to the birdlike quality of the violin part. Crow played with deft accuracy and emotional depth. The harmonies have an inherently hopeful quality, and in a lovely bit of semi-staging, the last few repetitions of the lark's song were played as Crow exited the hall, and the piece ended with the echo of his violin throughout the outer corridors.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510427519230/2017-11-11---Tania-Miller_eyes-closed-Jag-Gundu.jpg.jpg)
<figcaption>Conductor Tania Miller. Photo by Jag Gundu.</figcaption>
</figure>

After intermission, a lively premiere performance of Julien Bilodeau's *La fantaisie du pendu* (*Hangman's Fantasy*), the 34th commissioned sesquie in honour of Canada's 150th anniversary of confederation lead the way for the title piece of the night. AFGHANISTAN takes the setting of the Requiem mass and intersperses it with texts that represent the memories of a soldier living with PTSD. The texts happen simultaneously in the past and present. The choirs and the soloists alternated between the two, creating a sense of disorientation. Hearing the singers repeating "Hang on, son" during the chaotic cacophony of the orchestra behind them felt like one of the most real and artistic representations of what it must be like to be there amongst it all.  

The soloists were a who's-who of Canadian talent. Soprano Measha Brueggergosman sang with a big, bright, soulful sound. Her melismas flowed with ease and grace throughout Roy Thomson Hall bringing every ounce of distress and beauty to the text. Her connection with the audience and the orchestra was organic and palpable. Her duet work with mezzo-soprano Allyson McHardy was clean, precise and brought an array of vocal colours you don't hear often around Toronto. The vocal harmonies between the two voices were hollow and haunting. McHardy brought her trademark technical accuracy and vibrant, active vocal production. I really enjoyed hearing McHardy singing a contemporary score, since my experience with her singing deals mostly in Handel. Tenor Colin Ainsworth sang with a strong, flexible tone that danced with the orchestra. His communication of the desperation in some of his texts was breathtaking. Rounding out the soloists was baritone Brett Polegato. His bright, steely tone sailed over the rather large orchestrations that supported most of his singing. I was quite fond of his storytelling. During one movement, the men switch to spoken texts recounting the action ofsoldiers on the ground. Polegato and Ainsworth deftly carried out some seriously tricky duet music as well and their voices marry perfectly together. The two choirs sang with clarity and conviction and produced some of the best choral diction I've heard in a while.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510427543567/2017-11-11---Brueggergosman%2C-McHardy%2C-Miller%2C-Ainsworth%2C-Polegato-Jag-Gundu.jpg.jpg)
<figcaption>(l-r): Measha Bruggergosman, Allyson McHardy, Tania Miller, Colin Ainsworth, and Brett Polegato. Photo by Jag Gundu.</figcaption>
</figure>

A beautiful piece that explores serious subject matter and utilises creative and unique instrumentation, still felt like it ran a little long for my tastes. I felt like some of the musical themes and explorations were a little overdeveloped. There were moments where the extra length and size played well for the story (e.g., the relentlessness of battle) but in some of the other movements I felt like a little less could have accomplished a lot more. Composed in 2012, I think this is a piece that will hold up. I think we need to have more pieces like this become part of the classical music landscape here in Canada, and I think we should all be championing works like this.  

In a time when being proud of our country comes loaded with difficulties in reconciling past iniquities, I think it's still important to remember and celebrate the sacrifices and services of the actual people who have served - and continue to serve. As a gay man who enjoys many freedoms that my fellow LGBTQ brothers and sisters around the world don't, every day I am grateful for those who fought for my freedom. We should never forget the horrors of past conflicts, but it's the people we are honouring and celebrating with this day. I feel like Ryan and Steele have done a remarkable job of putting the actual people before the battle in their thoughts, and we should follow suit. 

Lest we forget.
