+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-08-14T17:36:00-04:00"
lastmod = "2017-08-14T22:07:00-04:00"
preamble = "Next month at [Opera Philadelphia](/scene/companies/opera-philadelphia/)'s O17 Festival, opera goers can catch the world premiere of [*Elizabeth Cree*](https://www.operaphila.org/whats-on/on-stage-2017-2018/elizabeth-cree/), the new work by [Kevin Puts](/scene/people/kevin-puts/) and [Mark Campbell](https://www.operaphila.org/whats-on/on-stage-2017-2018/elizabeth-cree/librettist/) that stars mezzo-soprano [Daniela Mack](/talking-with-singers-daniela-mack/) in the title role. Well-known for the success of their earlier collaboration, *Silent Night*, the composer-librettist team have adapted Peter Ackroyd's novel, *The Trial of Elizabeth Cree* into a fascinating chamber opera straddling the worlds of London's 19th-century music halls, and a woman on trial for the alleged poisoning of her husband.\n\nIt was a total treat to chat with composer Kevin Puts about his newest opera; he offers appetizing details about his work, and the evolution of his creative partnership with Mark Campbell."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502746775347/2017-08-15---elizabeth_cree_1.jpg.jpg"
primary_image_credit = "Daniela Mack as Elizabeth Cree. Photo: Dominic M. Mercier"
publishDate = "2017-08-14T21:39:00-04:00"
related_articles = ["articles/talking-with-singers-daniela-mack.md","articles/kevin-puts-i-know-who-i-am-as-a-composer.md","articles/a-stunning-premiere-elizabeth-cree.md","articles/ryan-mckinny-modern-meaning-in-a-gold-rushera-opera.md"]
related_companies = ["scene/companies/opera-philadelphia.md"]
related_people = ["scene/people/daniela-mack.md","scene/people/kevin-puts.md"]
short_description = "&quot;Just before the noose tightens she sings, cryptically, &quot;Here we are again!&quot; We are then immediately thrust back to her trial, in which she is on the stand for the murder of her husband. She is sarcastic and grandiose, playing to the crowd.  Then she herself takes us back to the squalid reality of her childhood and we feel for her as she dreams of the music hall and its wonders. She is very complex and interesting.&quot;"
slug = "elizabeth-cree-kevin-puts"
title = "Elizabeth Cree: &quot;The story begins with her hanging.&quot;"
+++

## What do you find most fascinating about the story of Elizabeth Cree?

It is different from anything I have done before. That is probably what made it most interesting. In the story, the impoverished Elizabeth dreams of one day seeing the music halls of 1880's London and rises quickly as a performer on those stages. And what drew me in instantly was how many sides of Elizabeth were thrown at me in such quick succession. 

The story begins with her hanging. Just before the noose tightens she sings, cryptically, "Here we are again!" We are then immediately thrust back to her trial, in which she is on the stand for the murder of her husband. She is sarcastic and grandiose, playing to the crowd.  Then she herself takes us back to the squalid reality of her childhood and we feel for her as she dreams of the music hall and its wonders. She is very complex and interesting. And of course, the story's taking place in and around the music halls of 1880s London is extremely appealing because it invites more music into an already operatic story.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502746897418/2017-08-15---the-crypt-sessions-elizabeth-cree-credit-andrew-ousley-05.jpg.jpg)
<figcaption>Kevin Puts and Daniela Mack perform an excerpt of *Elizabeth Cree* in The Crypt. Photo: Andrew Ousley.</figcaption>
</figure>

## What kind of musical aesthetic has come out of this world of 1880s London?

The harmonic language for the opera is often dark and moody and it is established right from the start. In the "music hall" numbers which are scattered throughout the show, I made no attempt to imitate the popular music of this period in London and instead decided to approach them in my own way. One will undoubtedly hear the influence of musical theater from the 20th century, but this is often infused with the darker hues of Elizabeth's harmonies, which are made of combining chords of disparate keys in various ways. In terms of the opera's pace, I tried to maintain drive and momentum across the entire 90 minutes.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/QNscKHmL2LA" frameborder="0" allowfullscreen></iframe>
</figure>

## What do you find "operatic" about brutal murders, and an accused woman on trial?

There is great passion involved in each. But I do not labor under any preconceptions of what opera should or should not be. I did not grow up with opera, but rather with instrumental music (most of it for piano or orchestra) and with film. I believe an opera can be anything, BUT it should be, first and foremost, about music. It is not enough just to get through a libretto adequately, attach something that resembles music to each word and scene and leave it at that. WHY should the audience listen? 

Sure, there will be arias and ensembles, and even orchestral interludes, of which there are many in *Silent Night*, for example, and these are necessarily about the music. But even when the characters are just imparting information, moving the story along, etc., there has to be something interesting, something memorable and arresting about what is happening in the harmony and in the orchestra, even if the singing is of a kind of recit style. We can't be lazy as composers! The piece has to be a MUSICAL experience that the audience wants to have again, otherwise it is all a waste of time. They could just read the book.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/67bToXRihsI" frameborder="0" allowfullscreen></iframe>
</figure>

## How has your work with Mark Campbell evolved over your various collaborations?

I treasure my work and my friendship with Mark. I would say, while we have always worked easily together, we understand each other's methods even better after having done three operas together. There is a lot more back and forth, even before I begin composing. We are very honest with each other. If something doesn't work for him, I know it and vice versa! We both just want the piece to work and we are tireless in trying to achieve that. And after three operas now, what I have learned is that when he tells the waiter he just wants a half glass of white wine but he will pay for the whole thing, just to tell them to bring the whole glass. Now how many teams can boast that kind of intimacy??

## What do you hope audiences will take away from this world-premiere run of *Elizabeth Cree*?

I hope they will be entertained, by the story and the music. I hope they will want to see it again.

>Elizabeth Cree runs September 14-23 at the Perelman Theater, 300 S. Broad Street, Philadelphia. For details and ticket information, [click here.](https://www.operaphila.org/whats-on/on-stage-2017-2018/elizabeth-cree/)
