+++
author = ["authors/greg.md"]
categories = "Op-ed"
date = "2014-07-14T06:00:00-04:00"
lastmod = "2015-04-23T14:46:00-04:00"
preamble = "This is a guest post by singer and Schmopera contributor [Gregory Finney.](https://twitter.com/gregory_finney) He has written for us before, [to much success](http://schmopera.com/how-i-acted-my-way-into-an-opera-career/). Catch him onstage later this summer with [LooseTEA Music Theatre](http://looseteamusictheatre.com/current-productionautocorrect-operas/)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429814655560/GregElitism.jpg.jpg"
publishDate = "2014-07-14T06:00:00-04:00"
related_articles = ["articles/schmopera-is-one.md","articles/and-i-know-things-now.md","articles/bocelli-grande-could-be-an-opera-duo-except-theyre-really-really-not.md","articles/the-life-of-a-comprimario-or-oh-youre-that-guy.md","articles/dillon-parmer-mozarts-masonic-journey.md","articles/grease-live-a-rant.md","articles/organizing-your-scores-a-serious-business.md","articles/in-review-isis-and-osiris.md","articles/be-in-on-the-secret-confidential-opera-project.md","articles/what-the-eff-is-a-zarzuela-anyway.md","articles/why-we-all-love-florence-foster-jenkins.md","articles/yannick-nezet-seguin-musicals-and-great-timing.md","articles/new-works-the-imaginings.md","articles/when-lost-find-roots.md","articles/oh-look-its-the-elitist-argument-again.md","articles/its-beginning-to-look-a-lot-like-sub-needed.md","articles/sweeney-todd-demon-of-disguise.md"]
short_description = "Guys, maybe we are a little elitist...\n\nSo. On quartz.com recently there was a piece by a young soprano named Chelsea Feltman entitled &quot;Don&#039;t Ask a Young Opera Singer These Three Questions&quot;. This piece has kinda been written before, but that&#039;s fine, and there were some pretty funny animations done about it from a stage actor&#039;s perspective circling around about four years ago."
slug = "elitism-irony-and-the-phantom-of-the-opera"
title = "Elitism, Irony, and The Phantom of the Opera"
+++

Guys, maybe we are a little elitist...

So. On [quartz.com](http://quartz.com/) recently there was a piece by a young soprano named Chelsea Feltman entitled ["Don't Ask a Young Opera Singer These Three Questions"](http://qz.com/228483/dont-ask-a-young-opera-singer-these-three-questions/#/h/83373,2/). This piece has kinda been written before, but that's fine, and there were some pretty [funny animations done about it](https://www.youtube.com/watch?v=S6UPzuQvFjE) from a stage actor's perspective circling around about four years ago.

In her piece she says some pretty powerful things. I can get behind her statements about American Idol. That's a popular music competition and our remarkable techniques don't always translate well to the Debbie Gibson I - V - IV chord progressions. Her third argument about Jackie Evancho I don't really want to entertain until that young lady has gone through some conservatory training, we don't know, she could be the next Callas.

Her second point revolves around a quintessential masterwork of Sir Andrew Lloyd Webber. "_The Phantom of the Opera_,” despite having the word in its title, is not actually an opera," she says.

I. Beg. To. Differ.

So because I've had this conversation (I'm not joking) with most of my colleagues in the professional Canadian opera scene, I thought it might be nice to put it to pen, and enlist some special help.

Through my association with [Toronto Operetta Theatre](http://torontooperetta.com/), I've had the opportunity to work with excellent singers and actors, truly some of the best in the biz. I'll never forget the day I showed up to rehearsal to work with one of my high school heroes - Ms. Elizabeth DeGrazia. For the painfully unaware, Ms. DeGrazia was Toronto's resident Christine in _Phantom_ for the majority of its run. I thought I'd ask her what she thought of all this.

"Andrew's _Phantom of the Opera_ in my opinion is an opera." Yes, obviously she would be on a first name basis with one of the most successful musical composers of the 20th century, and I totally agree with her. "It has half a dozen leading roles, a chorus of opera singers, and a ballet core. The three elements in most of the traditional operas." she said to me in an email recently. "It is almost completely sung from downbeat to the final curtain." 

A great point. "One might argue that the spoken dialogue, what little there is, could be _sprechstimme_ ("songspeak") - including some of the recitatives before the arias." The main point surrounding the dialogue being they didn't receive a separate script (called, aptly, 'the book') it was all included and underscored. To be fair, it has far less spoken dialogue than either _Die Zauberflöte_ or _Carmen_ so that can't be it... 

So clearly it's gotta be the subject matter that's holding _Phantom_ out of the realm of opera. Well, Elizabeth points out that the themes of _Phantom_ are no different than that of most other grand operas that involve a tragic love story. 

So, then it's got to be the technique employed to sing the score, right? Well, looking back, we have had some serious opera singers grace the stage of the Pantages in this production, and good luck singing Carlotta as a belter. Also, as a crossover artist myself, I take exception to that line of thought. 

So what is it then? I think Elizabeth hits the nail on the head when she said "The only thing to me that makes _The Phantom of the Opera _a musical form is that it is performed eight times week. If it was performed three nights a week, musical terminology would never even come into the fray..." Oddly enough though, _La bohème_ ran on Broadway for eight shows a week (albeit with rotating casts) for 228 shows, and clearly no-one is running to re-classify "Quando m'en vo" or "Che gelida manina" as showtunes.

So by all these arguments it's totally an opera. Top to bottom. So why does Ms. Feltman make such a statement after being educated in a top-of-the-heap conservatory at Juilliard? To be fair, I've heard this argument from more than just her, some of my "purist" colleagues (whom I respect and admire very much) have said the same thing. Why? And why this show in particular? Opera houses have started appropriating a fair amount of Broadway in recent memory; I think of a fully-operatic cast singing _Phantom,_ and you know what? In my head, it sounds exactly the same.

Let's not forget the inclusion of pieces like Kurt Weill's [_Street Scene_](https://www.youtube.com/watch?v=lmzscAYfSWI), Bernstein's [_West Side Story_](https://www.youtube.com/watch?v=74UmUhAsMgM), and Sondheim's [_Sweeney Todd: The Demon Barber of Fleet Street_](https://www.youtube.com/watch?v=qWA-eRewQrA) in the modern operatic canon. If there's a place in an opera house for "[America](https://www.youtube.com/watch?v=GB4lOWfgD5s)" in _West Side Story_, then there's room for "[Prima Donna](https://www.youtube.com/watch?v=U0n04m__mJ0)" from _Phantom_.

About halfway through, she changes the thesis of her piece to pontificate lightly on the perceived death of opera and offers this gem "Every morning, I see at least five new articles lamenting the 'death of opera' in the USA and around the world. Major houses are struggling to stay afloat financially, and smaller houses are simply closing down... Everyone agrees that something is wrong, but how to fix it?"

Ahhh.... so that's what this article is actually about.

She mentions the different opinions of various people (audience, performers, creatives, etc..), the view that it's "elitist or irrelevant", that opera needs to "get with the times" to attract more audiences. Ironically, she's propagating the "elitist" image with the very opening of this piece.

People think that opera is pretentious and elitist exactly because of shit like this. It wasn't written by Verdi, or Mozart, or Puccini, or one of the "-inis or -ettis", so it's not opera. Look: just because it ran for eight shows a week, doesn't mean it's any less of a full score. I feel perhaps some of this pretense is born out of envy for fact that they lack the kind of stamina needed to do eight performances in a week (oddly enough, a lot of them totally could do right a week and not break a sweat). Think about it, singing a double-header of _Butterfly_ or _Tosca_ on Wednesdays and Sundays at 230PM and 730PM so that you can have your one day a week off (removes to the corner in fetal position).

So what's my point?

With regards to _The Phantom of the Opera_ itself, the score is really worth a re-listen. I recommend the Canadian Cast Recording featuring Rebecca Caine as Christine Daae. Listen to it, but don't focus on the popular gems ("Wishing You Were Somehow Here Again", "Music of the Night", "All I Ask Of You") and really spend time with the big, intricately composed ensemble numbers ("Masquerade", "Notes", and the "Rehearsal Scene for _Don Juan Triumphant_") and you'll hear a lush, intricate piece that harkens to turn-of-the-century Romantics like Puccini and Cilea with some remarkably difficult, complex ensemble singing. (Yes, I'm aware of the whole _La fanciulla del West_ hullabaloo, but that's been settled by the parties involved and should be left where it is, in history, so we can focus on enjoying the fact that at least it was good music.)

These are the kinds of conversations I like having with my colleagues. Showing them how opera isn't dying, it didn't disappear, it's just that we behaved like pretentious jerks at the time new pieces were introduced.

And then we turn around almost 30 years later and wonder why everyone calls us elitist.

P(arting)S(hots) in the words of Elizabeth DeGrazia: "I can only tell you that when I sang six shows a week of _Phantom_ (two shows a week went to the understudy - ed.) I was very happy I was operatically trained at the Conservatory of Music."
