+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-07-07T11:20:00-06:00"
lastmod = "2016-07-08T08:32:00-06:00"
preamble = "The [Crested Butte Music Festival](http://crestedbuttemusicfestival.org/) is celebrating its 20th season this year; helping to celebrate is the new Spiegeltent, a new venue for all mainstage CBMF events with a stunning view of Mt. Crested Butte. Each year the Festival welcomes the young artists of the [Crested Butte Opera Studio](http://crestedbuttemusicfestival.org/opera-in-paradise/opera-studio/), and this summer they present a fully staged production of *La bohème*, under maestro David Stern.\n\nWe spoke with CBOS Artistic Director [Lynn Baker](http://crestedbuttemusicfestival.org/opera-in-paradise/faculty/), and tenor [Dane Suarez](/scene/people/dane-suarez/), Opera Studio Artist, about what the Festival has to offer young singers, and how they all feel about singing at 9,500ft elevation."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1467911972818/2016-07-07---Crested-Butte-Music-Festival-Opera-Studio-with-conductor-David-Stern-Xavier-Fane.jpg.jpg"
primary_image_credit = "The Crested Butte Opera Studio with conductor David Stern. Photo by Xavier Fane."
publishDate = "2016-07-07T21:04:00-06:00"
related_people = ["scene/people/dane-suarez.md"]
short_description = "&quot;The Crested Butte Music Festival was particularly attractive to me because there aren&#039;t many paid summer young artist programs where you have the opportunity to sing a leading role. This summer, I&#039;m eager to learn the role in a safe environment with amazing music staff and peers.&quot;"
slug = "elevated-opera-the-crested-butte-opera-studio"
title = "Elevated opera: the Crested Butte Opera Studio"
+++

## What attracted you to the CMBF Opera Studio? What do you hope to learn from the programme?

**Dane Suarez, CBOS participant**: The Crested Butte Music Festival was particularly attractive to me because there aren't many paid summer young artist programs where you have the opportunity to sing a leading role.  It's been a dream of mine to sing Rodolfo, and I was so happy to find a company that values the talent of young singers enough to cast them in the roles of the opera and not spend your summer in a chorus.  Because of this, the talent level of my peers is very high and I'm looking forward to my first *Bohème* being an excellent one. This summer, I'm eager to learn the role in a safe environment with amazing music staff and peers.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1467946577154/2016-07-07---Dane-Suarez-full.jpg.jpg)
<figcaption>Tenor Dane Suarez, Crested Butte Opera Studio Artist.</figcaption>
</figure>

## Can you tell us about the mission behind the Crested Butte Opera Studio programme?

**Lynn Baker, Opera Studio Artistic Director**: The current mission of CBOS is to provide intensive, customized study with enhanced performance opportunities that go beyond the chorus duties or minor roles typically available to young singers in apprentice programs. The program's initiative to feature Studio Artists in appropriate mainstage roles and a gala performance with orchestra serves to prepare young singers to make the difficult jump from student to professional. 

Through the preparation and rehearsal process, Studio Artists will identify and develop the necessary tools — knowledge, musicianship, professional demeanor, stagecraft, physical and vocal stamina - to prepare for and sing roles in a professional production. This is accomplished through supportive and positively-challenging instruction of Studio Artists by the opera faculty and visiting artists. 

Another tenet of the program's mission is to invest in our Studio Artists and their future careers, therefore we encourage the fostering of ongoing relationships with the Festival audiences and with our opera-loving patron sponsors, for the mutual benefit of the artists, patrons and the operatic art form. This contributes a rewarding and broad experience of community during the summer and provides opportunities to build sustaining and supportive friendships for the long-term trajectory of a singer's career. 

Because we believe strongly in the mind-body connection, in service of general health, well-being and sustenance of a long career, our program features a wholistic fitness-training component.  Studio Artists are urged to take full advantage of the stunning natural beauty of their Colorado surroundings.

## What have been some of the highlights of your time in the CBOS programme so far?

**Dane**: We've just hit the 2-week mark of 5 here at the Crested Butte Music Festival, and already we've had consultations with Cory Lippiello (Lyric Opera of Chicago), coachings, death-by-aria, and performed at a brewery.  In addition to doing all of this in what feels like a real-life postcard, the highlight for me thus far has been the first sing-through of *Bohème*.  All the feels!

## What does the new Spiegeltent offer to the programme, and what was the motivation behind its creation?

**Lynn**: The Spiegeltent offers a non-traditional venue for our updated production of *La bohème*. Given the increasing influence and ubiquity of small opera companies, portability of productions and multi-use performance spaces are more and more the norm. Young singers are already accustomed to such flexible venues and non-traditional stages, so the idea of performing *La bohème* in such a space as a Spiegeltent is not alien or anathema to them, as it might have been to singers of an earlier generation. The venue provides a challenge, acoustically and dramatically, to be creative and artistically nimble. 

The motivation behind the Crested Butte Music Festival's use of the Spiegeltent this season is to provide a gift to its supporting community on the occasion of the 20th anniversary of the festival.  As a novel and exciting venue, it will serve multiple functions--a performing space for classical and popular music performances, as well as a social and dining space before, during and after performances. The origin and design of the Spiegeltent combine European and American experiences. The tent is a uniquely European entity, but gives a nod to American saloons and dance halls of the same era.  The Spiegeltent will serve as a stepping stone to the Biery-Witt Performing Arts Center, which will be built on the same site.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1467946465765/2016-07-08---Crested-Butte-Music-Festival-Mirror-Palace-Spiegeltent-Productions.jpg.jpg)
<figcaption>The CBMF Mirror Palace Spiegeltent. Photo by Spiegeltent Productions.
</figcaption></figure>

## How does the elevation in Crested Butte affect your singing?

**Dane**: At just under 10,000 ft, Crested Butte is the highest summer festival in the U.S.  Olympic athletes come to Crested Butte to train, and essentially, that's what it feels like!  As a singer, I spend many hours preparing musical phrases in a way that makes sense musically and dramatically.  As I currently reside in Washington, DC, I'm used to singing at about 400 ft above sea level... there is MUCH less air up here and so breathing is a challenge.  Every day activities like climbing stairs is also a challenge, let alone creating a living world within an opera and still trying to do the thing I've been training for, just 9,500 feet higher!  Breathing and stamina are the first things to get used to.

## What do you think the CBOS offers young artists that is unique among summer programs?

**Lynn**: As our mission statement emphasizes, CBOS is offering appropriate mainstage roles to young artists.  This makes the program unique among summer programs. Our boutique size enables us to offer the care and coaching to make these performances possible. This individual attention and top-notch instruction provide a blueprint for future preparation and career management for these young artists, who are making the difficult leap from student to young professional.  Our commitment to them post-CBOS is ongoing, and that continued mentorship has proven to be valuable for the singers as well as for the faculty. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1467912562475/2016-07-07---CBOS-Participants.jpg.jpg)
<figcaption>The participants of the 2016 CBOS. Photo by Lynn Baker.</figcaption></figure>

## What do you look forward to in the remaining days of the programme?

**Dane**: Not only do we have 5 weeks to stage and perform *Bohème*, we also have a gala concert with orchestra where we each sing arias and ensembles, we have a cabaret concert, and we have an event that takes place at 11,000 feet.... I look forward to each of these--but more than anything--I'm looking forward to singing my first Rodolfo.
