+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = "2018-03-09T21:59:00-05:00"
lastmod = "2018-03-12T11:20:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520650683680/sq---Yannick-Parsifal.jpg.jpg"
primary_image_credit = "Yannick Nézet-Séguin conducting the Met Orchestra during a rehearsal for Wagner's Parsifal. Photo: Ken Howard / Met Opera."
publishDate = "2018-03-10T23:16:00-05:00"
related_articles = ["articles/spotlight-on-christopher-allen.md","articles/gordon-gerrard-music-doesnt-really-work-without-breath.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md","scene/companies/opera-philadelphia.md"]
related_people = ["scene/people/yannick-nezet-seguin.md"]
short_description = "When Yannick made his Met debut on New Year&#039;s Eve, 2009, he wrought perhaps the most propulsive Carmen prelude ever from the Met orchestra and fuelled crazily impassioned singing from an all-star cast."
slug = "elektra-and-parsifal-yannick-at-the-met"
title = "Elektra and Parsifal: Yannick at the MET"
+++

[Yannick Nézet-Séguin](/scene/people/yannick-nezet-seguin/), or just Yannick, as he likes to be called if the banners at Philadelphia's Kimmel Center are to be believed, is back at the Metropolitan Opera. He's back with an early start as Music Director Designate and as the conductor of a soaring reading of Strauss' *Elektra*, following on the heels of a near-perfect *Parsifal*.

When Yannick made his Met debut on New Year's Eve, 2009, he wrought perhaps the most propulsive *Carmen* prelude ever from the Met orchestra and fuelled crazily impassioned singing from an all-star cast. A few years later, after house triumphs with Verdi, Dvořák and Gounod, and the 2016 announcement of his appointment succeeding James Levine, he led a revelatory account of Wagner's *Der fliegende Holländer* after which he was pelted with flowers from the orchestra pit during his curtain call.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520715859193/CARMEN%20Garanca%20and%20Alagna_0061.jpg.jpg)
<figcaption>Elina Garanca as Carmen and Roberto Alagna as Don José in Bizet's *Carmen.* Photo: Ken Howard/Metropolitan Opera.</figcaption>
</figure>

This youthful conductor seems comfortably and brilliantly at home at the Met and with the company's esteemed orchestra. Such harmony is especially welcome, indeed critical to the Met, as it seeks to expand its audience, increase financial support, and burnish an image of administrative and artistic transparency. 

The *Elektra*, of course, is the gloriously grim Patrice Chereau production that became an instant classic when it premiered in the 2015-16 season. With its first revival, it is on its way to achieving legendary status. Remarkably, *Elektra* has not been a hot ticket at the Met in recent history. Empty seats throughout the house remain a mystery but also an opportunity for curious and last minute ticket buyers to experience intelligent opera at a reasonable price, and to witness firsthand, Yannick at work. General Manager, Peter Gelb's commitment to this opera is to be admired.

Its revival marks the appearance of [Christine Goerke](/talking-with-singers-christine-goerke/) in the title role. Suffice to say that she is the Elektra for her generation. With a boundless voice, she produces a sound that is creamy but with a frightening bite. She has a forceful sound but never sounds forced. Goerke takes to the exaggerated stage movements with demented gusto. Together with [Elza van den Heever](/talking-with-singers-elza-van-den-heever/) as Chryothemis, Elektra's more adjusted sister, they manage to show where their characters coalesce. The two sopranos bring an unexpectedly familial touch to this vengeful tale. Ms. van den Heever has a magnetic stage presence with strong and clear high notes. She is haunting in her desire for happiness. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520715740877/Elektra_0188_C.jpg.jpg)
<figcaption>Elza van den Heever (background) as Chrysothemis and Christine Goerke in the title role of Strauss' *Elektra.* Photo: Karen Almond/Met Opera.</figcaption>
</figure>

If Klytämnestra and Agamemnon did anything right, they raised articulate children, even when driving them to various stages of distraction and degradation. Of course, Klytämnestra and her current husband, Aegisth murdered Agamemnon. This is why Oreste, brother to Elektra and Chryothemis, sneaks back to the palace to kill his murderous mother and stepfather. Mikhail Petrenko's deep bass is chillingly clear and pointed as Oreste. His diction is exemplary. During the recognition scene, when Elektra realizes the stranger in the palace courtyard is her brother, whom she had thought dead, his unflinching focus and her bewildered state of mind make for an exchange of strange beauty. Yannick thrillingly sets the orchestra ablaze throughout the scene only to douse it when caressing a vocal line. This is a practice that he carries out with breathtaking precision throughout the opera.  

It is with Michaela Schuster's Klytämnestra that the full breadth of his conducting comes into play. While capably sung and with moments of breathy suffering, Ms. Schuster lacks the sense of decay and inner torment about which she sings in her scene with Elektra. She moves with such regal élan that it is hard to believe in her tortured soul. But her anguish is in the music and this is where Yannick shapes a sound that completes the character in the orchestra pit when it isn't quite happening on stage.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520715778373/_KA39701_C.jpg.jpg)
<figcaption>Michaela Schuster as Klytämnestra in Strauss' *Elektra.* Photo: Karen Almond/Met Opera.</figcaption>
</figure>

He did much the same thing for Klaus Florian Vogt who sang the title role in *Parsifal* last month. Jonas Kaufmann originated the part in Francois Girard's enigmatic 2013 Met production. It would be unreasonable to expect Vogt to replicate Kaufmann's James Dean style of acting or preternaturally expressive singing but Vogt did not find another means to convey that simple could be very complicated. He has a heroic sound but his Parsifal, while finding his way back to Gurnemanz and the Knights of the Grail, never found himself. 

When Wagner's perfect fool is adrift, Yannick reels him in. It's critical that he does so because with a running time of just under six hours including two intermissions, even the most rapt audience may cease to care. But Yannick calls on orchestral forces of startling delicacy one moment and undulating dynamics the next. We are transported to Parsifal's world of compassion, transcendence, and redemption. Influenced perhaps by the allure of the projected planets and surreal vistas that serve as a subtly changing backdrop, we can imagine seeing the shape of the sound that Yannick and the orchestra create. It hovers over the orchestra pit. We are in a cerebral and spiritual world rather than a literal time and place. The impact is staggering and it becomes less evident in this instance, the character of Parsifal is not. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520715812457/PARS_1078a.jpg.jpg)
<figcaption>Klaus Florian Vogt in the title role and René Pape as Gurnemanz in Wagner's *Parsifal.* Photo: Ken Howard/Metropolitan Opera.</figcaption>
</figure>

Of course, Yannick and the orchestra are not alone. Principals from the 2013 production including Rene Pape as the dutiful and melancholy knight, Gurnemanz, and a masterful Peter Mattei as Amfortas, the anguished and eternally wounded ruler, provide performances that have only deepened since 2013. And then there is the new Kundry, sung by Evelyn Herlitzius who has finally landed on our shores. Ms. Herlitzius sang Elektra at the premiere of the Chéreau production at Aix-en-Provence in 2013. There were rumors that she might travel to New York but instead the production arrived with Nina Stemme, who, for the record, created an *Elektra* that remains a benchmark.

Ms. Herlitzius' sang Kundry with wild emotional abandon and a vocal technique so refined that she appeared not to have one. Her sound may have struck Met audiences as unusual but it is one we will grow to appreciate the more we hear it. Perhaps it was unfair to imagine Herlitizius as Elektra while she was singing Kundry but *Parsifal* leaves room for such musings.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520715849225/PARS_0580a.jpg.jpg)
<figcaption>Evelyn Herlitzius as Kundry in Wagner's *Parsifal.* Photo: Ken Howard/Met Opera.</figcaption>
</figure>

With this production, Girard's brings a vast grayness to the Met stage. A sea of red blood, the aforementioned astral projections, and a raked stage that splits to reveal what appears to be a red stream punctuates the mass. On its own conceptual terms, it expresses the opera's pervasive spirit and, when combined with the music, comes close to achieving Wagner's quest for perfect unity in art or *Gesamtkunstwerk*. a concept he was backing away from by the time he composed *Parsifal*. Nonetheless, it remains a constant if elusive goal in his operas that Yannick eagerly pursued. It is a considerable accomplishment that this *Parsifal* comes so close to achieving it. 

In the 2018-19 Met season, Yannick will helm a new production of *La Traviata* and revivals of the atmospheric *Pelléas et Mélisande* and the powerful John Dexter production of *Dialogues des Carmélites*. His cheerful proclamation to move the Met out of its comfort zone will begin to unfold as his artistic control increases. Frankly, many have been waiting on the edge of their seats for this to happen. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520715710392/yannick-2--Hans-van-der-Woerd.jpg.jpg)
<figcaption>Yannick Nézet-Séguin. Photo: Hans van der Woerd.</figcaption>
</figure>

One thing is certain; his commitments to the Philadelphia Orchestra, Rotterdam Philharmonic and Orchestre Metropolitan (Montreal) will enrich his role at the Met. We can look forward to new collaborative programs and productions, especially with Philadelphia, that will surely enrich both cities. We have already seen and continue to anticipate his extraordinary combination of exuberance and expertise. Hopefully, Yannick will attract new audiences to the Met, help increase financial support and pave the way for new and diverse operatic adventures. It's a tall order but when he was dodging flowers after *Holländer*, he was nimble on his feet and kept smiling.
