+++
author = ["authors/oliver-munar.md"]
categories = "Review"
date = 2022-10-24T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "For more information, please visit the [Edmonton Opera website](https://www.edmontonopera.com/)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1666614289/media/2022/10/sqEO_01-Tosca_Karen_Slack_and_Cavaradossi_David_Pomeroy_Photo_by_Nanc_Price_bxjauz.jpg"
primary_image_credit = "Karen Slack (Tosca) and David Pomeroy (Cavaradossi) in Edmonton Opera's production of Puccini's Tosca, 2022. Photo: Nanc Price."
related_articles = []
related_companies = ["scene/companies/edmonton-opera.md"]
related_people = ["scene/people/etta-fung.md", "scene/people/joel-ivany.md", "scene/people/adrianne-pieczonka.md", "scene/people/vartan-gabrielian.md", "scene/people/lauren-margison.md", "scene/people/siman-chung.md", "scene/people/sharleen-joynt.md", "scene/people/mireille-asselin.md", "scene/people/david-pomeroy.md", "scene/people/peter-barrett.md", "scene/people/karen-slack.md"]
short_description = "On October 22, Edmonton Opera launched what it describes as an “electric and exciting” 2022-23 season with one of Giacomo Puccini’s well-known dramas: Tosca. "
slug = "electric-exciting-edmonton-opera-launches-2022-23-season-with-puccinis-tosca"
title = "“Electric and exciting”: Edmonton Opera launches 2022-23 season with Puccini’s Tosca"
youtube_url = ""

+++
On October 22, Edmonton Opera launched what it describes as an “electric and exciting” 2022-23 season with one of Giacomo Puccini’s well-known dramas: _Tosca_.

“Grand opera is back,” says Joel Ivany, Artistic Director of Edmonton Opera. "It's important to remind our core patrons that these big operas mean a lot to a certain group of people. And for those who don’t know these big operas, this is a wonderful introduction to what this multicultural artform is."

Starring as Tosca is American soprano [Karen Slack](/scene/people/karen-slack/) in her Edmonton Opera debut. Ivany says Slack is a strong advocate for equality in this industry. "Having her as Tosca, interacting with the cast, demonstrates that she is an artist that has something to say, is an important voice, and we want to introduce her to our company and to the city," he says.

On opening night, Slack carried herself with the right mix of grace and fire befitting one of opera's great diva roles. Blessed with luscious vibrant tones that reverberated through the auditorium, Slack embodied everything from deep passion for her beloved Cavaradossi, to desperation as Scarpia manipulates her into submission. Her performance of the famed Act II aria "Vissi d’arte" (in which her character reflects on her fate, how the life of Cavaradossi is at the mercy of Scarpia and why God has seemingly abandoned her) is heartachingly beautiful and a highlight of the evening.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1666614484/media/2022/10/EO_02-Tosca_Karen_Slack_Photo_by_Nanc_Price_xf43nx.jpg){{% /md %}}

<figcaption>Karen Slack in the title role of Edmonton Opera's production of Puccini's Tosca, 2022. Photo: Nanc Price.</figcaption>  
</figure>

In his role debut as Baron Scarpia, baritone [Peter Barrett](/scene/people/peter-barrett/) turns in a performance to be celebrated. Last seen by Edmonton Opera audiences as Marcello in the February 2022 production of Puccini's _La bohème_, Barrett demonstrates both vocal and acting versatility as the antagonistic chief of police. From his first appearance on stage, Barrett commands attention with a swagger and authoritative presence, and backs it up with vocals that make you sit up in your seat with interest. The role of Scarpia demands a performer of substantive ability, especially in Act Two when the character imprisons and tortures Cavaradossi and manipulates Tosca for his own sadistic means. Barrett’s interpretation and delivery of Scarpia is truly substantive and is a role debut to be remembered.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1666614598/media/2022/10/EO_03-Scarpia_Peter_Barrett_Photo_by_Nanc_Price_vhynmo.jpg){{% /md %}}

<figcaption>Peter Barrett as Baron Scarpia in Edmonton Opera's production of Puccini's Tosca, 2022. Photo: Nanc Price.</figcaption>  
</figure>

The cast of supporting characters should be commended for making the most of their time on stage. As Angelotti in Act One, baritone Peter Monaghan provides the necessary desperation of a condemned man that sets the drama into motion. Tenor Zack Rioux (Spoletta) and bass-baritone Giles Tomkins (Sciarrone) play their roles as Scarpia's henchmen masterfully, with Tomkins providing a gasp-worthy moment at the end of the opera (#nospoilers).

The work of Intimacy Coordinator Janine Waddell and Lighting Designer Jason Hand deserve special attention. Waddell's work in Act Two, in which Scarpia and his henchmen interact with increased violence toward both Cavaradossi and Tosca, is especially effective. Scarpia's advances on Tosca were especially menacing and spine tingling. And in some expert lighting on the "Vissi d'arte" aria, Tosca sings in a spotlight while the shadow of Scarpia looms on the wall behind her, which underscores the desperate situation about which she sings.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1666614637/media/2022/10/EO_04-Tosca_Karen_Slack_Photo_by_Nanc_Price_fasfss.jpg){{% /md %}}

<figcaption>Karen Slack in the title role of Edmonton Opera's production of Puccini's Tosca, 2022. Photo: Nanc Price.</figcaption>  
</figure>

Conductor Simon Rivard returns to the EO podium to again lead the Edmonton Symphony Orchestra in another Puccini masterpiece. On this night, Rivard led the ESO to an emotional yet grounded performance.

The Edmonton Opera chorus, expertly prepared by Chorusmaster Shannon Hiebert, performed with confidence, vigor and precision.

The night, however, belonged to tenor [David Pomeroy](/scene/people/david-pomeroy/) as the painter Mario Cavaradossi. Pomeroy has a voice that fills this hall with vibrancy and life — even when he is being tortured off stage. Edmonton Opera audiences celebrated him as Prince Calaf in the 2017 performance of _Turandot_ and were treated again to a masterful nuanced performance in _Tosca_. His on-stage chemistry with Slack is authentic while his singing is simply world-class. His rendition of the famous aria "E lucevan le stelle", which he sings as he awaits his execution, was a true highlight on this night. With such ease and fullness in his voice, especially in its higher register, Pomeroy thrills the audience with a commanding performance.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1666614655/media/2022/10/EO_05-Cavaradossi_David_Pomeroy_and_the_Sacristan_Jin_Yu_Photo_by_Nanc_Price_fas5fg.jpg){{% /md %}}

<figcaption>David Pomeroy (Cavaradossi) and Jin Yu (Sacristan, right) in Edmonton Opera's production of Puccini's Tosca, 2022. Photo: Nanc Price.</figcaption>  
</figure>

Edmonton Opera's production of Puccini's _Tosca_, conducted by Simon Rivard and directed by Alison Moritz, opened October 22 at the Northern Alberta Jubilee Auditorium and will be staged again on October 25 and 28. It is performed in Italian with English subtitles.

## Christoph Gluck's _Orphée+_

For its second of three mainstage productions, Edmonton Opera goes to the beginning of opera with a production of _Orphée+_ by German composer Christoph Gluck (1714-1787). The story is an adaptation of the Greek myth of Orpheus who ventures into the underworld to retrieve the soul of his deceased lover Eurydice.

"It's heartbreaking because it’s something we can all relate to," says Ivany. "It's taking something very old and making it brand new."

As part of making this production "brand new", Ivany says this production of _Orphée+_, which he also staged in a co-production between Against the Grain Theatre, the Banff Centre and Opera Columbus, will use technology both in the orchestra and on stage.

"We have a digital chorus, for example, by recording them all individually and having someone stitch it all together, as a precursor to what many of our artists may have experienced during COVID," says Ivany. "It's very simplistic but can illustrate the loneliness and isolation of what technology can provide and what’s important in life."

Edmonton Opera’s production of _Orphée+_ will open January 28, with additional performances on January 31 and February 3. The production stars South Korean countertenor [Siman Chung](/scene/people/siman-chung/) as Orphée, Ottawa-born soprano [Sharleen Joynt](/scene/people/sharleen-joynt/) as Eurydice, and Etta Fung as Amour. The production, to be sung in French with English subtitles, will be conducted by Sandra Horst and directed by Ivany.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1666561476/media/2022/10/EO_Orphee_f51ymt.jpg){{% /md %}}

<figcaption>Siman Chung, Sharleen Joynt and Etta Fung star in EO’s production of Gluck’s Orphée+.</figcaption>  
</figure>

## Pergolesi's _Stabat Mater_

In its final mainstage of the season, Edmonton Opera will put a new spin on a work that is more traditionally performed in concert instead of a staged production. Giovanni Pergolesi's _Stabat Mater_, one of the Italian composer's most celebrated sacred works, was composed in 1736 as he was dying of tuberculosis in an Italian monastery. It is a setting of a 13th-century Christian hymn to Mary, which portrays her suffering as Jesus Christ's mother during his crucifixion.

"The music is so heartbreaking and beautiful," says Ivany. "Once you accept the limitations of what the music is, there's so many colours in it."

For Edmonton Opera's production, both the audience and performers will be on stage together, in what Ivany says will create an intimate experience. The singers and orchestra will also be joined by a pair of dancers who will bring another artistic element to the experience.

"Unlike _Tosca_, where you know what you’re getting, this will open people's eyes and ears to a new sound," says Ivany.

The production stars soprano [Mireille Asselin](/scene/people/mireille-asselin/) and countertenor Magid El-Bushra, both of whom are making their company debuts with Edmonton Opera. "There's going to be that connection of the two of them, mother and son, and we’ll see the connection between them and how that connects to the music, the staging and choreography."

Edmonton Opera's production of Pergolesi's _Stabat Mater_ will open March 30 and has three subsequent performances on March 31 and April 1, including a matinee (note: the performances on March 31 and the evening of April 1 are reportedly sold out). It will be directed by Jennifer Tarver.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1666561373/media/2022/10/EO_StabatMater_ejzowq.jpg){{% /md %}}

<figcaption>Mireille Asselin and Magid El-Bushra star in EO’s production of Pergolesi’s Stabat Mater.</figcaption>  
</figure>

## Rumbold Vocal Prize (October 23-29)

In addition to a full season on the mainstage, Edmonton Opera launches its inaugural Rumbold Vocal Prize, a new voice competition for emerging artists, from October 23-29, 2022. Thanks to the generosity of Grace and Arnold Rumbold, four finalists will participate in a week-long residential professional development experience.

"Emerging out of this pandemic, my heart goes out to emerging singers who are entering this industry with their eyes wondering what the future is," says Ivany. "We hope this will be an opportunity for them to get on the ground running, to be put in front of people who can literally further their careers and financially support them."

This year’s finalists for the first-ever Rumbold Vocal Prize include Lauren Margison (soprano), Vartan Gabrielian (bass-baritone), Madison Montambault (mezzo soprano), and Spencer Britten (tenor). On October 29, the finalists will participate in a masterclass by renowned Canadian soprano Adrianne Pieczonka and a recital at the Northern Alberta Jubilee Auditorium. Judges for this year’s competition include Karen Slack (star of EO’s production of _Tosca_), Simon Rivard (conductor for EO’s production of Tosca) and Shannon Hiebert (EO Chorusmaster).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1666561645/media/2022/10/EO22-23_banner_website_Full_Season_Narrow_alvh9o.jpg){{% /md %}}

</figure>