+++
author = ["authors/oliver-munar.md"]
categories = "Review"
date = "2018-04-18T09:49:00-04:00"
lastmod = "2018-04-19T10:48:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524058584860/sq02PhillipAddisGiovanni.jpg.jpg"
primary_image_credit = "Phillip Addis in the title role of Don Giovanni, Edmonton Opera, 2018. Photo: Nanc Price."
publishDate = "2018-04-19T10:48:00-04:00"
related_companies = ["scene/companies/edmonton-opera.md"]
related_people = ["scene/people/phillip-addis.md","scene/people/john-tessier.md","scene/people/erik-anstine.md","scene/people/michele-capalbo.md","scene/people/whitney-leigh-sloan.md","scene/people/kirk-eichelberger.md"]
short_description = "If love is the soul of genius, as Wolfgang Amadeus Mozart once said, what would that make lustful abandon? In the case of one of opera’s best-known &quot;bad boys&quot;, a fiery eternity of damnation."
slug = "edmonton-opera-delivers-imaginative-inspired-don-giovanni"
title = "Edmonton Opera delivers imaginative, inspired Don Giovanni"
+++

If love is the soul of genius, as Wolfgang Amadeus Mozart once said, what would that make lustful abandon? In the case of one of opera’s best-known "bad boys", a fiery eternity of damnation.

To close its 2017-18 season on the mainstage, [Edmonton Opera](/scene/companies/edmonton-opera/) brought back the philandering *Don Giovanni* (performance dates April 14, 17 & 20). Directed by Oriol Tomas and conducted by Christopher Larkin, the production stars [Phillip Addis](/scene/people/phillip-addis/) as Don Giovanni, [Erik Anstine](/scene/people/erik-anstine/) as Leporello, [Michele Capalbo](/scene/people/michele-capalbo/) as Donna Anna and [John Tessier](/scene/people/john-tessier/) as Don Ottavio. The story follows the skirt-chasing Giovanni who, with the help of his servant Leporello, charms and seduces women in his travels. The opera begins with an encounter with Donna Anna that goes awry and leads to the death of Donna Anna’s father, which inevitably comes back to haunt Giovanni at the end of the opera.

Edmonton Opera marketed the show as "Spanish-inspired". That description may not mean much to the average opera patron, but if you're familiar with the story, you will recognize it is based on the legends of the fictional Spanish womanizer Don Juan. Aside from some matador costumes and poses, any semblance of Spanish inspiration was not evident.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524059044299/12-Addis-Sloan%20as%20Giovanni-Zerlina.jpg.jpg)
<figcaption>Phillip Addis (Don Giovanni) and Whitney Leigh Sloan (Zerlina) in *Don Giovanni*, Edmonton Opera, 2018. Photo: Nanc Price.</figcaption>
</figure>

The set and lighting design struck a rather dark tone, which may be the last thing one would expect from a "Spanish-inspired" production. On the one hand, the multiple levels of the stage give the production a dynamism and options for the singers to project over Mozart's orchestral writing. But visually, bright colours - aside from the gold, red and white dresses worn by the three female leads - were conspicuously absent for most of the opera. The patterned vests worn by Giovanni and Leporello reflect their colourful game with the people of the town, but most of the set was shrouded in shadow, with only spotlights on the singers. The final scene, in which Giovanni is finally damned, brings in more red to foreshadow Giovanni's fiery fate.

As the titular Giovanni, baritone Phillip Addis brings an attractive swagger and appeal to the role. Addis excelled especially at the challenging recitative, particularly in the comedic moments with his trusty servant. At times, the orchestra drowned Addis' velvety baritone somewhat, but his performance of the boisterous aria "Fin ch'han dal vino", in which he announces a lavish, hedonistic party, was a tour de force.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524059101449/11_-Capalbo-Tessier-McLeod%20as%20Anna-Ottavio-Elvira.jpg.jpg)
<figcaption>Michele Capalbo (Donna Anna), John Tessier (Don Ottavio), and Cara McLeod (Donna Elvira) in *Don Giovanni*, Edmonton Opera, 2018. Photo: Nanc Price.</figcaption>
</figure>

Soprano Michele Capalbo offers an emotionally charged performance as the grieving Donna Anna. Edmonton Opera audiences will remember her celebrated turn as Liù in last season's successful run of Puccini's *Turandot*. However, Mozart writes very differently than Puccini, and Capalbo's vocals may have benefited from more lift and agility that Mozart's writing often demands. Capalbo's voice is definitely one of the strongest in this cast, and her dramatic flair for the role is perhaps more convincing and committed among the principal singers.

Cara McLeod's portrayal of the spurned Donna Elvira is a great reminder to beware the woman scorned. The fiery red dress she wore throughout the opera reflects her volatile personality. McLeod played the role safely, stopping well short of becoming unsympathetic. However, I would have liked even more fire and, dare I say, instability to further differentiate the character from Zerlina. Of note, McLeod was originally cast as the understudy for [Miriam Khalil](/scene/people/miriam-khalil/), but McLeod took over the role after Khalil had to retire from the show  unexpectedly. Kudos to McLeod on filling some tough shoes; audiences will certainly hear more from her in the near future.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524059160119/07-McLeod-Sloan%20as%20Elvira-Zerlina.jpg.jpg)
<figcaption>Cara McLeon (Donna Elvira) and Whitney Leigh Sloan (Zerlina) in *Don Giovanni*, Edmonton Opera, 2018. Photo: Nanc Price.</figcaption>
</figure>

The role of Zerlina, played by Edmonton-based soprano [Whitney-Leigh Sloan](/scene/people/whitney-leigh-sloan/), was one of a few standout performances on this night. Sloan's voice shimmers with youthful vitality, which befits the portrayal of a simple peasant girl. Her chemistry with Masetto, played by baritone [Tyler Fitzgerald](/scene/people/tyler-fitzgerald/), is playfully romantic, and contrasts sharply with the hedonistic advances of her pursuer Don Giovanni. On this night, Fitzgerald's singing was, at times, slightly out of sync with the orchestra, but his command of the demanding recitative was first-rate. His acting was even more convincing, especially in showing his exasperation with his bride's willingness to be alone with Don Giovanni.

Despite limited stage time, [Kirk Eichelberger](/scene/people/kirk-eichelberger/) gave the Commendatore, Donna Anna's murdered further, an authoritative presence. In particular, the final scene, in which the Commendatore damns Giovanni to a hell, showcases Eichelberger's booming bass that commands attention and would make most people quake in their boots.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524059187481/08_-Addis-Eichelberger%20as%20Giovanni-Commendatore.jpg.jpg)
<figcaption>Phillip Addis (Don Giovanni) and Kirk Eichelberger (Commendatore) in *Don Giovanni*, Edmonton Opera, 2018. Photo: Nanc Price.</figcaption>
</figure>

Edmonton-based tenor John Tessier gives a thoughtful, mature performance of Don Ottavio that elicited one of the strongest responses from the audience. Singing both the Ottavio arias "Dalla sua pace" and "Il mio tesoro", Tessier makes the challenging tessitura and coloratura sound almost too easy. Whereas Addis portrayed Giovanni with a defiant swagger, Tessier's Ottavio is noble and elegant. The blocking often saw Ottavio on his own, which underscores the notion that he is perhaps the only person unaffected by the emotional turmoil brought on by Giovanni's antics.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524059228947/06_-Anstine%20as%20Leporello.jpg.jpg)
<figcaption>Erik Anstine (Leporello) in *Don Giovanni*, Edmonton Opera, 2018. Photo: Nanc Price.</figcaption>
</figure>

The standout performance on this night belonged to Erik Anstine as Leporello. Anstine displayed a wide spectrum of emotion from comedy to remorse, and backed it up with some of the best vocal production of the cast. His performance of "Madamina, il catalogo è questo", in which he admits his master's long list of conquests, was especially hilarious, and showed an ease and security in his singing. It's as if Mozart wrote this role for a performer of Anstine's calibre.

As one of the five most-produced operas in the world, it can be hard to tinker with a formula to make *Don Giovanni* indelibly your own. Edmonton Opera delivers, though, so if you haven't yet seen it, closing night is Friday, April 20th. 

For details and tickets, visit [edmontonopera.com](https://www.edmontonopera.com/).
