+++
author = ["authors/oliver-munar.md"]
categories = "Review"
date = 2022-02-07T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "_Edmonton Opera's production of_ [_Puccini's La Bohème_](https://www.edmontonopera.com/2022/boheme) _is directed by François Racine and conducted by Simon Rivard with the Edmonton Symphony Orchestra. The two remaining performance dates are February 8 and 11, 2022._"
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1644282677/media/2022/02/sqEO_Boheme_LukaKawabataPeterMonaghanAdamLutherThomasGoerzPeterBarrett_NancPrice_bffjov.jpg"
primary_image_credit = "The Bohemians (l-r): Luka Kawabata (Schaunard) Peter Monaghan (Colline), Adam Luther (Rodolfo) and Peter Barrett (Marcello), and Tom Goerz (Benoit). Photo by Nanc Price."
related_articles = ["articles/hype-atg-boheme.md", "articles/everyday-people-spectacular-emotions-la-bohme.md"]
related_companies = ["scene/companies/edmonton-opera.md"]
related_people = ["scene/people/lara-ciekiewicz.md", "scene/people/peter-barrett.md", "scene/people/miriam-khalil.md", "scene/people/andrew-haji.md", "scene/people/adam-luther.md"]
short_description = "The company has a triumphant opening night in spite of off-stage challenges."
slug = "edmonton-opera-delivers-all-the-feels-boheme"
title = "Edmonton Opera delivers \"all-the-feels\" Bohème"
youtube_url = ""

+++
What’s an operatic production without a bit of drama?

After a period of relative managerial upheaval and the challenges associated with mounting a mainstage production during a global pandemic, [Edmonton Opera](/scene/companies/edmonton-opera/) delivers a moving production of [Puccini's beloved _La Bohème_](https://www.edmontonopera.com/2022/boheme). The production marks the first mainstage performance for the company since announcing Joel Ivany as its new Artistic Director in November 2021, and the installation of Shannon Hiebert as the new Chorus Master.

COVID also threw a wrench into the production when leading man [Andrew Haji](/scene/people/andrew-haji/) (Rodolfo) tested positive within a week of opening night, which necessitated the import of tenor [Adam Luther](/scene/people/adam-luther/) to step into the role on short notice. Thankfully, opening night proceeded as planned, the behind-the-scenes drama having no perceived effect on the company's triumphant, "all-the-feels" return to the mainstage that will make even the most fickle patron fall in love with the story all over again.

> The standout performance on this night belonged to baritone Peter Barrett as Marcello, in his debut with Edmonton Opera.

The strength of _Bohème_ is understandably rooted in its core ensemble of Bohemians. Edmonton Opera has assembled a strong sextet who drive the story convincingly throughout the four acts. On this night, Adam Luther stood and delivered a passionate Rodolfo – complete with a soaring high C in the famed "Che gelida" aria at the end of the first Act. His bright vocal timbre matched well with his castmates, especially those of [Peter Barrett](/scene/people/peter-barrett/)'s Marcello and [Miriam Khalil](/scene/people/miriam-khalil/)'s Mimì. I can only imagine the adrenaline coursing through him on opening night, with less than a week to prepare the role both vocally and on the stage, but Luther showed his mettle and resolve by treating the audience with an unforgettable performance.

Note: Andrew Haji is slated to return as Rodolfo for the remaining two performances, February 8 and 11, in what will mark his company debut with Edmonton Opera. I'm eager to see Haji perform with this production because he spent much time preparing and staging the role before being sidelined. Despite the pandemic, Haji has been one of Canada's most sought-after tenors - his February 2020 performance as Pollione in the Calgary Opera production of Bellini's _Norma_ was praised for his lyric beauty and carrying power – attributes that will surely serve him well in the role of Rodolfo.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1644282691/media/2022/02/EO_Boheme_Company_cppyhc.jpg){{% /md %}}

<figcaption>The company of La bohème, Edmonton Opera, 2022. Photo: Nanc Price.</figcaption>  
</figure>

This is the second time I have seen soprano Miriam Khalil as Mimì and I hope it's not the last, especially now that she is based in Edmonton. On this night, Khalil was one of the stronger performances of the evening, impressing with her versatility as her character's health declines through the opera. Her strong vocals never waned, even when her character is in its final moments, which demonstrates her respect for Puccini’s music above all else. On this night, Khalil sang the Act III aria "Donde lieta usci" especially well: she captures both Mimì's love for Rodolfo and the agony of parting ways with him. This is a role Khalil knows well: she played Mimì with Calgary Opera in 2019, as well as for the Canadian Opera Company and Minnesota Opera.

[Luka Kawabata](/scene/people/luka-kawabata/) and Peter Monaghan turned in solid opening night performances as the musician Schaunard and the philosopher Colline, respectively. Kawabata, a member of the Yulanda M. Faris Young Artists' Program with [Vancouver Opera](/scene/companies/vancouver-opera/), offers beautiful vocal colours to the ensemble cast, delivered with a youthful exuberance that is in keeping with his character. Monaghan's rich, round tone is befitting of a more thoughtful character as Colline; his voice is well matched to his Act IV aria, "Vecchia zimmara senti", in which he parts ways with his overcoat to help pay for much-needed supplies. And in his limited stage time as both the landlord Benoit (Act I) and the rich patron Alcindoro (Act II), bass-baritone Tom Goerz shows his mastery of comedic timing for both roles.

> Her pianissimo on one of her top B's was especially jaw-dropping in its precision and beauty.

Soprano [Lara Ciekiewicz](/scene/people/lara-ciekiewicz/) impresses as the vivacious, and dare I say coquettish (my new favourite word), Musetta. Like Rodolfo's aria in Act I, Musetta's Act II aria "Quando me'n vo'" is often a litmus test for the success of any Bohème production: while inexperienced singers may focus on the vocal acrobatics, the higher echelon of artists - Ciekiewicz included - will infuse colours and personality into the lyrics. On this night, Ciekiewicz delighted the audience with a nuanced performance that showed off her ability to impress and garner attention as any scene-stealing diva should. I was especially impressed with the variety in which Ciekiewicz approached her highest notes in the aria – her pianissimo on one of her top B's was especially jaw-dropping in its precision and beauty.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1644283129/media/2022/02/EO_Boheme_LaraCiekiewicz_NancPrice_nmuxye.jpg){{% /md %}}

<figcaption>Lara Ciekiewicz as Musetta in La bohème, Edmonton Opera, 2022. Photo: Nanc Price.</figcaption>  
</figure>

The standout performance on this night belonged to baritone [Peter Barrett](/scene/people/peter-barrett/) as Marcello, in his debut with Edmonton Opera. Barrett is tailor-made for this role, which is perhaps one of the most grounded characters of _Bohème_, and demands a baritone of considerable ability and sensibility. On this night, his voice resonates with both vibrancy and authority over a full orchestra playing the exuberant Musetta's Waltz, eliciting one of the strongest audience responses for the evening.

> Conductor Simon Rivard led the Edmonton Symphony Orchestra to breathe life into Puccini's beloved score.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1644282702/media/2022/02/EO_Boheme_PeterMonaghanLukaKawabataAdamLutherMiriamKhalilPeterBarrettThomasGoerLaraCiekiewicz_qhxlhh.jpg){{% /md %}}

<figcaption>Peter Monaghan (Colline), Luka Kawabata (Schaunard), Adam Luther (Rodolfo), Miriam Khalil (Mimi), Barrett, Tom Goerz (Alcindoro) and Lara Ciekiewicz (Musetta) in La bohème, Edmonton Opera, 2022. Photo: Nanc Price.</figcaption>  
</figure>

Conductor Simon Rivard led the Edmonton Symphony Orchestra to breathe life into Puccini's beloved score. Rivard, the Resident Conductor of the Toronto Symphony Orchestra, conducted with energy and passion, with sprightly tempi especially during the market scene of Act II. Kudos should also be extended to the Edmonton Opera Chorus and members of Cantilon Children's Choir who, despite performing masked, remained clear, lively and energetic during Act II and the beginning of Act III, never missing a beat.