+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = 2022-05-26T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "_Eden_ is available on Erato. Visit [joycedidonato.com](https://joycedidonato.com/) for more information. To learn more about the International Teaching Artists Collaborative and the Eden Project, visit [itac-collaborative.com](https://www.itac-collaborative.com/)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1653487224/media/2022/05/sq_JoyceDiDonato_EDEN_gu88a4.png"
primary_image_credit = "Joyce DiDonato is out to save the world with her new Erato recording, Eden, and a 45-venue global concert tour. Photo: Sergi Jasanada."
related_articles = ["articles/why-we-all-love-florence-foster-jenkins.md", "articles/a-sunday-afternoon-at-carnegie-hall.md"]
related_companies = []
related_people = ["scene/people/joyce-didonato.md"]
short_description = "Joyce DiDonato has made a stunning recording. Since we've become accustomed to her perfect technique, rich characterizations and commitment to the message as well as the music, this is not unusual. But with Eden, her new recording on Erato, this masterful mezzo-soprano quite simply astonishes."
slug = "eden-stuns-and-the-astonishing-joyce-didonato-is-out-to-save-the-world"
title = "EDEN stuns and the astonishing Joyce DiDonato is out to save the world"
youtube_url = ""

+++
Joyce DiDonato has made a stunning recording. Since we've become accustomed to her perfect technique, rich characterizations and commitment to the message as well as the music, this is not unusual. But with _Eden_, her new recording on Erato, this masterful mezzo-soprano quite simply astonishes. As the world copes with war, the pandemic, and a politicized environment in crisis, DiDonato has chosen to embark on a spiritual journey, one guided by music, and most emphatically invites us to follow along. Her timing couldn't be better.

The journey involves our relationship with nature and our inclination, if we have one, to save it. Sixteen arias, songs and orchestral works from several genres explore the centuries old fascination that composers have had with nature. Gluck, Handel, Mahler, Wagner and less familiar names populate the same garden as Ives, Copland and Oscar-winner, Rachel Portman. DiDonato greets each composer with her requisite skill and understanding. But more to the point, she conveys a disarming earnestness that transcends interpretation and even her vocal prowess.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1653487260/media/2022/05/JoyceDiDonato_JoycewithKidsinCircle_v7hf3x.jpg){{% /md %}}

<figcaption>Joyce DiDonato meets with students at Carnegie Hall’s Resnick Education Wing. Photo: Richard Termine.</figcaption>  
</figure>

The lady is out to save the world and she's not doing it alone. DiDonato has created an unprecedented model to achieve an enduring educational—and environmental—impact. Aligning with the International Teaching Artists Collaborative, a Scotland-based worldwide network created for teaching artists and artists who work in participatory settings, this is no idle wish. She serves as ITAC's Climate Ambassador, a role that harmonizes with _Eden_'s mission to explore ways in which the recording and the _Eden_ concert experience (more on that to follow) can be a catalyst leading to positive change. "The most effective way to save our planet is not simply to tick the boxes of reducing carbon emissions" says DiDonato. "We need a change of heart."

That heart is taking her on a tour of over 45 venues across five continents earning her the accolade of _trooper_ in every sense of the word. And to both actively and symbolically commemorate each engagement, concert-goers and children in concert communities are receiving packets of native seeds provided by Botanic Gardens Conservation International, a network of 800 botanic gardens. In the 1950's Leonard Bernstein urged us via his _Candide_ to "Make Our Garden Grow." DiDonato is spreading the seeds and helping to preserve the environment for them to grow.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1653487286/media/2022/05/JoyceDiDonato_seeds_ro3i7j.jpg){{% /md %}}

<figcaption>Packets of seeds provided by Botanic Gardens Conservation International, representing 800 botanic gardens worldwide, are given to concert-goers and children in each community on the 45-venue tour. Photo: Original image by There Stands The Glass: William Brownlee.</figcaption>  
</figure>

Of course there are bound to be cynics out there, be they climate change deniers or the staunchly apathetic. But it would take a hard heart and probably a thick head to resist the gorgeous allure of this recording. Opening with Charles Ives' "The Unanswered Question," DiDonato replaces the trumpet with majestic and melismatic vocalizing. Rachel Portman's sensitive setting of Gene Scheer's poem, an _Eden_ commission, "The First Morning of the World" softly responds to Ives' cosmic piece. Mahler follows with DiDonato singing his fragrant "Ich atmet' einen linden Duft" from _Rückert-Lieder_ with engaging freshness. This sequence, evoking the mysteries and joys of nature, sends forth a deeply felt environmental message. It is also irresistibly romantic.

> DiDonato submits that war isn't only bad for people but a crime against nature as well.

_Eden_ flows with extraordinary unity but I found myself pausing after the first three tracks to marvel at how beautifully they coalesced. The next group begins with Biagio Marini's "Con le stelle in ciel che mai" a spacious piece filled with furious vitality, reflecting his association with Monteverdi. An outright eviction from _Eden_, as in the garden of, is threatened in Josef Myslivecek’s "Toglierò le sponde al mare" from _Adamo ed Eva_. Aaron Copland's setting of Emily Dickinson's "Nature, the Gentlest Mother" gently walks back the strident tone of its predecessor.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1653487310/media/2022/05/JoyceDiDonato_Il-Pomo-dOro_vawuj5.jpg){{% /md %}}

<figcaption>Pomo d’Oro, specialists in baroque and classical music, is Joyce DiDonato’s ensemble of choice. The orchestra accompanies her on EDEN and the 45-venue global tour. Photo: Julien Mignot.</figcaption>  
</figure>

Giovanni Valentini's "Sonata eharmonica" provides yet another silky transition. The marvelous Pomo d'Oro, DiDonato's ensemble of choice, here under Maxim Emelyanychev, plays the first of two instrumental works on the recording, bringing enlightening detail to this enigmatic composition. Before the group's second solo appearance we hear DiDonato's plaintive rendering of "Piante ombrose," from Francesco Cavalli's _La Calisto_. With gorgeous chest voice, delicate ornamentation and what can only be described as persistent truth, DiDonato submits that war isn't only bad for people but a crime against nature as well.

Emelyanychev and Pomo d'Oro kick up a very precise storm with Gluck's turbulent "Danza degli spettri e delle furie," from _Orfeo ed Eurydice_. While listeners may be tempted to simply revel in DiDonato's impassioned singing and the savvy programming of _Eden_, the remaining tracks; two Gluck arias from _Orfeo_; Handel arias from _Theodora_ and _Serse_; another _Rückert-Lieder_ selection, "Ich bin der Welt abhanden gekommen" and, most interestingly, "Schmerzen" from Wagner's _Wesendonck Lieder_, keep us grounded. Perhaps on the ground is a good place to be as we ponder nature, our relationship with it and a world that DiDonato reminds us, is worth saving.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1653487336/media/2022/05/JoyceDiDonato_SergiJasanada_gfwkxx.jpg){{% /md %}}

<figcaption>With EDEN, DiDonato has created an unprecedented model to achieve an enduring educational—and environmental—impact.  Photo: Sergi Jasanada.</figcaption>  
</figure>