+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-12-08T10:53:00+00:00"
lastmod = "2016-12-11T10:46:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1481194694548/2016-12-8---Venice.jpg.jpg"
publishDate = "2016-12-11T10:46:00+00:00"
related_companies = ["scene/companies/academy-of-ancient-music.md"]
short_description = "Christopher Hitchens once said of religion, that it was &quot;the race&#039;s first (and worst) attempt to make sense of reality.&quot; In later conversations, Hitchens clarified that because it was our first attempt, it was by nature, our worst. This concept doesn&#039;t seem to apply to Early Music; rather, over and over again we are stunned by the timelessness - the edginess, really - of Baroque music."
slug = "early-music-of-venice-the-academy-of-ancient-music-bridges-the-gap"
title = "Early music of Venice: the Academy of Ancient Music bridges the gap"
+++

Early Music always seems like a distilled glance at the function of music in a society - any society, really. Composers were producing a mix of works, some for their patrons, and some for having fun with their medium. The goal was the same as all art had been and would be for centuries after: to entertain, and to provoke thought. It's perhaps odd that 17th-century music seems to encompass the art as a whole, since it's also the genesis of what we consider "Western music," classical or otherwise.

Christopher Hitchens once said of religion, that it was "the race's first (and worst) attempt to make sense of reality." In later conversations, Hitchens clarified that because it was our first attempt, it was by nature, our worst. This concept doesn't seem to apply to Early Music; rather, over and over again we are stunned by the timelessness - the edginess, really - of Baroque music. In particular, Western music's first attempt at opera is by no means our worst; Baroque opera is a blending of music and text that is so comprehensive, so story-first, that it has absolutely set the bar for later masterpieces by Mozart and Verdi.

We heard the [Academy of Ancient Music](/scene/companies/academy-of-ancient-music/)'s latest concert the other night, entitled *The Glory of Venice*; the concert showcases the music of Claudio Monteverdi, and of one of his lesser-known contemporaries, Dario Castello. While Monteverdi is a household name in musical circles, Castello is more obscure; his biography is sketchy at best, and musicologists still only make educated estimations of Castello's real name. Still the two composers were at least colleagues in Venice, if not friends, and "two towering pillars of early seventeenth-century Venetian music."

The Academy of Ancient Music showed off an eclectic orchestra of period instruments - including the very curious bassoon-relative, the [dulcian](https://en.wikipedia.org/wiki/Dulcian) - and sopranos Carolyn Sampson and Rowan Pierce joined the AAM to sing the Monteverdi picks. Sampson and Pierce sang with a sisterly blend, still unique in their own qualities; Pierce had an agile focus in her voice, while Sampson sang with a more gentle, florid sound.

To see Music Director Richard Egarr dance in his seat at the keyboard, and to hear all the neat, jazzy twists and turns in these Baroque scores, it makes one think that this kind of music is really where it's at. It's an interesting thought, considering the enormous imaginative range of composers like Monteverdi and Castello, to ponder what sounds they would have created with the instrumental and acoustic technology of today. After more than on Monteverdi and Castello selection, we couldn't help but think, "that's pretty rockstar."

The AAM's performances made us consider again the dichotomy in this music; there are details abound, surprising chromaticisms and head-spinning rhythmic tricks, yet there's a huge amount of room for play. These players seemed unfettered by the rulebooks and well-researched "proper ways" of performing this music; stylistic, they absolutely were, but never stifling. 

We're already looking forward to catching the Academy of Ancient Music's February concerts, *Bach and the Italian Concerto*, at West Road Concert Hall in Cambridges on **February 13**, and at Milton Court Concert Hall **Februrary 15**. For details and ticket info, check out the AAM's [concert line-up.](http://www.aam.co.uk/#/concerts/concerts.aspx)
