+++
author = ["authors/blanche-isral.md"]
categories = "Review"
date = "2017-09-19T11:07:00-04:00"
lastmod = "2017-09-19T12:08:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505835673687/2017-09-19---3353_rinaldo17_gross.jpg.jpg"
primary_image_credit = "Countertenor Jakub Józef Orliński plays the title role in Rinaldo at Oper Frankfurt, 2017. Photographer: Barbara Aumüller."
publishDate = "2017-09-19T11:42:00-04:00"
related_articles = ["articles/in-review-the-jette-parker-young-artists-present-oreste-.md","articles/ariodante-or-the-hebridean-handel.md"]
related_companies = ["scene/companies/oper-frankfurt.md"]
related_people = ["scene/people/jakub-jozef-orlinski.md","scene/people/elizabeth-reiter.md","scene/people/daniel-miroslaw.md","scene/people/karen-vuong.md","scene/people/brandon-cedel.md","scene/people/julia-dawson.md","scene/people/ted-huffman.md"]
short_description = "Three tiny, nearly-nude dancers painted from head to toe acted as freaky humanoid henchwomen to Armida. These impish women did Armida&#039;s bidding, transforming at different points into a three-headed monster, a forest, or mermaids, and stopping time to control various characters. A particularly striking moment was when Rinaldo sang &quot;Abbruggio, avampo, e fremo&quot; while being tormented and yanked around by the imps on three long ropes. "
slug = "dynamic-and-physical-rinaldo-at-oper-frankfurt"
title = "Dynamic and physical: Rinaldo at Oper Frankfurt"
+++

A few years back, while working for [Tafelmusik](/scene/companies/tafelmusik-baroque-orchestra-chamber-choir/) in Toronto, I was introduced to the concept of Baroque music as alternative and irreverent. Baroque is, by design, full of revolution, and performances of Baroque music today are at their best when they are exploratory and used as a space to play. A new production of Georg Friedrich Handel's tricentenarian [*Rinaldo*](http://www.oper-frankfurt.de/en/season-calendar/rinaldo/?id_datum=990) at [Oper Frankfurt](/scene/companies/oper-frankfurt/), set in the company's alternative space - an old streetcar hangar turned theatre in the early 90s, the Bockenheimer Depot - took that to a delicious extreme and showcased North American style in both the cast and creative team.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505832842555/2017-09-19---DresdenFrankfurtDanceCompany_Bockenheimer_Depot.jpg.jpg)
<figcaption>The Bockenheimer Depot © Dresden Frankfurt Dance Company. Photographer: Dominik Mentzos</figcaption>
</figure>

With this baroque-as-cutting-edge concept in mind, it's no wonder that director [Ted Huffman](/scene/people/ted-huffman/), who is known for his work in new and contemporary opera, would offer such an exciting take on Handel's *Rinaldo*. Barefoot performers painted the all-black, insanely raked stage with extremely physically demanding and dynamic choreography usually reserved for the contemporary dance world. There were just two or three set pieces in the entire three hours - a chair, a boulder - which was fitting for an opera set in a pre-Jerusalem desert. There were no wings, no sets - everything was organic, nothing artificially concealed. Instead, Huffman leaned on the Bockenheimer Depot's cool open architecture and, with the help of fellow New Yorker choreographer Adam Weinert, made use of the bodies of the six singers and eight dancers on stage as the main markers and drivers of the action. Coupled with some simple fog and lighting on the deeply sloped stage, which ended at the peak of a steep mountain and dove into a versatile trench downstage for discarding bodies, the result was a clean and highly dynamic playground for the action to take place in.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505832946865/2017-09-19---3356_rinaldo14_gross.jpg.jpg)
<figcaption>Brandon Cedel (Argante), Julia Dawson (Goffredo), Jakub Józef Orliński (Rinaldo), and dancers on a strikingly raked stage. *Rinaldo*, Oper Frankfurt, 2017. Photographer: Barbara Aumüller.
</figcaption>
</figure>

The title character was played by youthful, ultra-fit countertenor [Jakub Józef Orliński](/scene/people/jakub-jozef-orlinski/), whose tireless display of daring vocal and physical gymnastics had me awestruck. It was crazy. Some of you may remember Orliński as the winner of the 2016 Metropolitan Opera Grand Finals, but his impressive vocal talents are only the half of it. This guy can wield a sword like no one's business, dive into a handstand between arias, and throw himself with Olympic grace and power across a stage with, like, a 60° rake. Okay, I may be exaggerating, but it was treacherous. What's more, his voice was beautifully supported and he showed incredible emotion. And he is a smokeshow. It wasn't even fair. (Also in the category of "not fair": Orliński is 26. Handel was 26 when he wrote *Rinaldo*. Guess who else is 26? Yours truly.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505833062945/2017-09-19---3359_rinaldo11_gross.jpg.jpg)
<figcaption>Rinaldo (Jakub Józef Orliński) being controlled by Armida's imps (dancers) in *Rinaldo*, Oper Frankfurt, 2017.</figcaption>
</figure>

Oper Frankfurt offered an energetic and ultra-physical *Rinaldo* that was highly satisfying to watch. In the absence of sets, costumes and body painting took a central role. The star costume was a dress worn by [Elizabeth Reiter](/scene/people/elizabeth-reiter/) as Armida. In the story, Armida has the supernatural ability to transfigure and take the form of Rinaldo's beloved, Almirena ([Karen Vuong](/scene/people/karen-vuong/)). Costume designer Raphaela Rose designed a magical dress made of black flippable sequins that Reiter could wipe against the grain to turn them white, thus imitating Almirena's white sparkly dress. Rinaldo is understandably enchanted until he touches the dress, turning some of the material back to black and revealing Armida's true evil identity. It is the sort of theatre costume magic a director would only dream of, and fits into the playground-like world of this stage.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505833169863/2017-09-19---3362_rinaldo08_gross.jpg.jpg)
<figcaption>Rinaldo (Jakub Józef Orliński) and Almirena (Karen Vuong) lie in a forest enchanted by imps (dancers) as Armida (Elizabeth Reiter) looks on. Rinaldo, Oper Frankfurt, 2017. Photographer: Barbara Aumüller.</figcaption>
</figure>

Three tiny, nearly-nude dancers painted from head to toe acted as freaky humanoid henchwomen to Armida. These impish women did Armida's bidding, transforming at different points into a three-headed monster, a forest, or mermaids, and stopping time to control various characters. A particularly striking moment was when Rinaldo sang "Abbruggio, avampo, e fremo" while being tormented and yanked around by the imps on three long ropes. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505833264648/2017-09-19--3350_rinaldo20_gross.jpg.jpg)
<figcaption>Dancers, Jakub Józef Orliński (Rinaldo) and Elizabeth Reiter (Armida). Armida’s dress, designed by Raphaela Rose, changes colours with a stroke of the hand. *Rinaldo*, Oper Frankfurt, 2017. Photographer: Barbara Aumüller.</figcaption>
</figure>

At various points, the impish parasites' body makeup rubbed off on the stage from their writhing, turning the black ground almost white by the end, the dust getting kicked up like desert sand by other characters' skirts, symbolizing the mess of the Crusades taking place. The dancers' athletic feats were numerous and shocking, like when a soldier rolled all the way down from upstage, finally dropping into the trench at the front.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505833273862/2017-09-19---3354_rinaldo16_gross.jpg.jpg)
<figcaption>Armida (Elizabeth Reiter) and her imps (dancers), *Rinaldo*, Oper Frankfurt, 2017. Photographer: Barbara Aumüller. </figcaption>
</figure>

Rumor has it that Oper Frankfurt has a thing for the North American sound, and this was confirmed in this cast. King Goffredo, played as an ancient and ailing old man by Canadian mezzo-soprano [Julia Dawson](/scene/people/julia-dawson/), came across as lovable and benevolent. Her sound was somewhat limited in the lower range, perhaps by the demands of her doubled-over stance, but she made up for it in physicality and character. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505833350234/2017-09-19---3363_rinaldo07_gross.jpg.jpg)
<figcaption>Daniel Miroslaw (Eustazio), Julia Dawson (Goffredo; with beard and walking sticks), Brandon Cedel (Argante; sitting, in a black coat), and dancers, *Rinaldo*, Oper Frankfurt, 2017. Photographer: Barbara Aumüller.
</figcaption>
</figure>

Bass-baritone [Brandon Cedel](/scene/people/brandon-cedel/), a new member of the Oper Frankfurt Ensemble and a graduate of the Met's Lindemann Young Artist Program, also shone in the top end. American soprano Karen Vuong, also a member of the Ensemble, was lovely as Almirena, delivering a sweet and lyrical "Lascia ch'io pianga". Reiter's Armida (also American) was superb in every way, her expressive "Ah, Crudel il pianto mio" nearly stealing the show from Orliński. As Eustazio, Juilliard-trained Polish bass [Daniel Miroslaw](/scene/people/daniel-miroslaw/) delivered a rich sound. The continuo was exquisite and daring, and the trumpet quartet triumphant. The orchestra was perfectly balanced and, save for a couple of timing issues, provided a reliable and warm blanket of sound with impressive range.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505833403851/2017-09-19---3351_rinaldo19_gross.jpg.jpg)
<figcaption>Elizabeth Reiter (Armida) and Brandon Cedel (Argante) with dancers, Rinaldo, Oper Frankfurt, 2017. Photographer: Barbara Aumüller.</figcaption>
</figure>

Catch [*Rinaldo*](http://www.oper-frankfurt.de/en/season-calendar/rinaldo/?id_datum=990) at Oper Frankfurt's trendy secondary space, the Bockenheimer Depot, before October 3, 2017.
