+++
author = ["authors/hannah-de-priest.md"]
categories = "Interview"
date = "2018-05-16T21:27:00-04:00"
lastmod = "2018-05-21T20:55:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526867790493/sqMeriem.jpg.jpg"
publishDate = "2018-05-21T20:55:00-04:00"
related_articles = ["articles/photographing-the-opera-singer.md"]
related_companies = ["scene/companies/haymarket-opera-company.md"]
short_description = "For years, she pushed her love of fashion and drawing to the side until, while studying in Lille, she happened to meet the couturiere designing and building costumes for her local amateur dance troupe. The couturiere showed Bahri how to use a sewing machine and she was hooked."
slug = "dressing-opera-singers-chatting-with-costume-designer-meriem-bahri"
title = "Dressing opera singers: chatting with costume designer Meriem Bahri"
+++

Costume designer [Meriem Bahri](http://meriembahri.com/) is beloved in the baroque opera world for her detail-oriented, imaginative work for companies including [Haymarket Opera Company](/scene/companies/haymarket-opera-company/), the Newberry Consort, and Opera Lafayette. *The New York Times* has described her costumes as "gorgeous and evocative." John von Rhein of the *Chicago Tribune* likened a production with Bahri's designs as "a veritable 17th-century fashion parade." Her work brims with historical detail and whimsy, with figures festooned with extravagant headdresses and dressed in impeccably draped brocades. 

Now based in Chicago, Bahri is a French/Tunisian citizen who came to the US initially (though ambivalently) planning on a career in science, having earned a PhD in biology from the Université de Lille (France.) For years, she pushed her love of fashion and drawing to the side until, while studying in Lille, she happened to meet the couturiere designing and building costumes for her local amateur dance troupe. The couturiere showed Bahri how to use a sewing machine and she was hooked.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526937584128/unnamed%2010.jpg.jpg)
<figcaption>Meriem Bahri's costume sketch in progress for the character of Vespetta in Haymarket Opera Company's production of *Pimpinone* by Georg Philipp Telemann (Photo: Meriem Bahri).</figcaption>
</figure>

In addition to her schedule in a biology laboratory, Bahri gamely took on sewing courses, moving a sewing machine into her home and teaching herself the rudiments of pattern-making. During a recent chat, she remembered that the first garment she ever made for herself was a khaki-coloured blouse with cap sleeves, darts, and a zipper. Bahri recalled the zipper with a smile, acknowledging that these days, she doesn't have much use for zippers; because they weren't invented until 1893, they don't feature on any of her elaborate, carefully-researched costumes for Haymarket Opera, Chicago's baroque opera company.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526937592925/unnamed%206.jpg.jpg)
<figcaption>Photo shoot for Haymarket Opera Company's production of *Amadigi Di Gaula* by George Frideric Handel (Photo: Topher Alexander; Costume design: Meriem Bahri; Set design: Zuleyka Benitez).</figcaption>
</figure>

To date, Bahri has designed costumes for thirteen Haymarket Opera productions and become an integral part of their artistic team. Haymarket specializes in reconstructing 17th- and 18th-century works and presents lavish operas with a full complement of historical instruments in the pit and impeccably-dressed dancers and singers on-stage, executing thoughtful ornaments and carefully-researched choreography. Bahri's costumes form a crucial part of their elaborate spectacles.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526937602246/unnamed%205.jpg.jpg)
<figcaption>Mezzo-soprano Suzanne Lommler and dancers Kali Page, Julie Benirschke and Joseph Caruana on the set of Haymarket Opera Company's production of *Amadigi Di Gaula* by George Frideric Handel (Photo: Benjamin Brachi; Costume design: Meriem Bahri; Set design: Zuleyka Benitez).</figcaption>
</figure>

Where singers and instrumentalists might look to treatises and ornamentation manuals that relay vital information about performance techniques, costume designers like Bahri have their own valuable sources. Delving into galleries of historical portraiture and pictorial books on historical street fashion enable designers to trace the development of crucial fashion trends from year to year. While audience members may not be able to link a silhouette or accoutrement to a specific decade, you can bet Bahri can. It's one reason Bahri says she enjoys watching the show *Outlander*, in which the protagonist timetravels to radically different places and times — the show's costume designer fills the screen with subtle hints and sartorial allusions clearly aimed at others in the know. 

Street fashion, however, is often distinct from costumes meant for the stage. That's why Bahri digs through museum archives of sketches and (in rare cases) physical costumes from the 17th and 18th centuries. Bahri points out that designers of operatic costumes at Louis XIV's court didn't just design costumes; they also designed sets, furniture, and perhaps even the King's boudoir. As designers in the broadest sense, they were intimately connected with the governmental and social life of their monarch. Indeed, the operas put on at Court were crucially political — demonstrations of the King's taste, prestige, and wealth. These designers were really propagandists with virtually-limitless funds at their disposal — a fact readily evident in their sketches of fantastic and extravagantly-detailed costumes.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526937619489/unnamed%202.jpg.jpg)
<figcaption>Soprano Chelsea Shephard and tenor Karim Sulayman in rehearsal for Haymarket Opera Company's production of *Gli Equivoci Nel Sembiante* by Alessandro Scarlatti (Photo: Charles Osgood; Costume design: Meriem Bahri).</figcaption>
</figure>

One of the primary challenges for costume designers working on period performance today is to retain the essential, spectacular nature of these designs but imaginatively reproduce them on a tightly-restricted budget. Squaring this circle is a skill Bahri honed while working under designer Anna Watkins at the Boston Early Music Festival, where she has been Assistant Costume Designer since 2013. Bahri especially admires Watkins' ability to balance colour and texture and incorporate charming details into her costumes, as well as the ability to re-vitalize costumes from prior productions with new accoutrements or trifles to work them into a new show.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526937627890/unnamed%204.jpg.jpg)
<figcaption>Mezzo-soprano Suzanne Lommler and tenor Jonathan Beyer in Haymarket Opera Company's production of *L'Isola Disabitata* by Joseph Haydn (Photo: Charles Osgood; Costume design: Meriem Bahri; Set design: Zuleyka Benitez).</figcaption>
</figure>

A designer's process is as individual as how a singer might approach learning a new role. Bahri likes to source fabrics before she begins sketching. While online sellers of fabrics have exploded in recent years, Bahri prefers the brick-and-mortar experience and travels through Chicago and its suburbs to explore, feel, and colour-match fabrics. 

Bahri begins with the opera's libretto, making careful notes of any mentions of specific costumes and props, noting any quick changes, and charting out different character "groups." Baroque opera, (notorious for complex plots and long lists of characters), benefits from costuming that subtly groups characters together through colour, textures, (think: embroidered taffeta, velvet, linen), and silhouette. It's a subtle technique barely noticed by audience members, says Bahri, but one that can build unconscious symmetry and cohesion within a production.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526937636809/unnamed%209.jpg.jpg)
<figcaption>Meriem Bahri's costume sketch for the character of Diana in Haymarket Opera Company's production of *La Calisto* by Francesco Cavalli (Photo: Meriem Bahri).</figcaption>
</figure>

Within baroque opera, she says, there are many stock characters from the *commedia dell'arte* and Greek and Roman mythology, (Pierrot, Apollo, Harlequin, Cupid), whose costumes are crucially predictable, identifying them to the audience before a single word is sung. The look of these costumes is especially well-documented. Faithfully reproducing them is a crucial part of many productions.

When Bahri began working with Haymarket Opera, she both designed and built every costume. Nowadays, with larger productions, she designs all the elements but contracts out a part of the sewing to a costume shop. This leaves her more time to fully focus on the overall aesthetic and look of a show.

In addition to working in baroque opera, Bahri designs for dance companies and has worked with Elements Contemporary Ballet, Balam Dance Theater, Nordic Baroque Dancers, and the Joffrey Academy of Dance. Bahri says that even more than in baroque opera - which can involve dancing and a lot of stylized movement - modern dance requires a special attentiveness to how the dancers will move; her designs must complement and facilitate their dancing. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526867909789/unnamed.jpg.jpg)
<figcaption>Photo shoot for Elements Contemporary Ballet production of *The Sun King* with dancers Tiffany McCord and Joseph Caruana (Photo: Topher Alexander; costume design: Meriem Bahri).</figcaption>
</figure>

When contemplating the particular joys and challenges of designing period costumes, Bahri says that she enjoys the precision required, both in the physical work of patterning and stitching an elaborate costume in addition to the research and attention to historical detail. Though designing within a historical framework might seem restrictive, as Orson Welles famously quipped, "The enemy of art is the absence of limitations."

Like many young singers building up a career, Bahri is a freelancer balancing a full schedule of short-term contracts with opera and dance companies. In addition to designing costumes, Bahri, under the name [Weriem](http://weriem.com/), accepts commissions for illustrative work and has designed everything from wedding invitations to tattoos for clients from all over the globe. Hers is a decidedly modern career story - a gritty combination of irrepressible talent, a strong work ethic, and a bit of luck. We can't wait to see what she thinks of next!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526937656416/unnamed%208.jpg.jpg)
<figcaption>Meriem Bahri in a mask she made for Haymarket Opera Company's production of *La Calisto* by Francesco Cavalli (Photo: Topher Alexander.</figcaption>
</figure>

*If you live in Chicago, you can catch Meriem Bahri's work in action in Haymarket Opera's June performances of Antonio Cesti's [L'Orontea at the Studebaker Theater](http://www.haymarketopera.org/lorontea).*



