+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-10-24T12:32:00+01:00"
lastmod = "2016-10-25T19:39:00+01:00"
preamble = "\"Orchestra Underground: Contempo-Scary Music\" is the great title that the [American Composers Orchestra](http://www.americancomposers.org/2016/09/04/orchestra-underground-contempo-scary/) gave to their [Halloween-themed season opener at Zankel Hall, **October 28 at 7:30pm**](http://www.americancomposers.org/2016/09/04/orchestra-underground-contempo-scary/). On the spooky programme are Bernard Herrmann's *Psycho Suite* (after Hitchock's film), the world premiere of Judith Shatin's *Black Moon*, Paul Moravec's *The Overlook Hotel Suite* (based on his opera, and Stephen King's novel, *The Shining*), and David del Tredici's scena for soprano/narrator and orchestra, *Dracula*.\n\nNancy Allen Lundy sings del Tredici's surreal, spooky piece, which is a setting of Alfred Corn's poem, \"My Neighbor, the Distinguished Count.\" We spoke with Allen about the singer-as-narrator, and becoming the lady who livies next-door to Count Dracula.\n\nFor full details and ticket information about \"Contempo-Scary Music\" on October 28, [click here.](http://www.americancomposers.org/2016/09/04/orchestra-underground-contempo-scary/)"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1477309061253/2016-10-24---NancyAllenLundy---Dracula---MasatakaSuemitsu.jpg.jpg"
primary_image_credit = "Photo by Masataka Suemitsu"
publishDate = "2016-10-25T09:26:00+01:00"
related_articles = ["articles/opera-in-virtual-reality-the-parksville-murders.md","articles/spooky-shows-the-telltale-heart.md","articles/6-operas-to-creep-you-out.md"]
related_people = ["scene/people/nancy-allen-lundy.md"]
short_description = "&quot;Alfred Corn is the brilliant wordsmith of this beguiling story. I can&#039;t say enough about how beautifully crafted the text is. The words are like music, tripping and bubbling off the tongue. They are a pleasure to speak, and every phrase is an economic distillation of words to convey intention.&quot;"
slug = "draculas-neighbour-nancy-allen-lundy"
title = "Dracula&#039;s neighbour: Nancy Allen Lundy"
+++

## What kind of lady is Dracula's neighbour?

My character is a woman of means in an upscale neighborhood on the East Coast (US) in the 1930s or 1940s, or so I've decided. From the text, I know she has a maid, she enjoys touring cars, silver platters, and Dracula carries a pocket watch. I’ve chosen to give her a quasi mid-Atlantic accent to make her seem a bit affected. She is at the mercy of her addiction which makes her unhinged and desperate as well as vain and egocentric. It’s quite possible that the telling of the story is in the present, since she and Dracula are undead, but I believe the "change" happened in the '30s or '40s. Either way, her reality is grounded in an earlier time.

## What sort of challenges are unique to Del Tredici's piece, and the rehearsal process of something like this?

The singer is asked to narrate as well as sing. Much of the monologue is set to music and has a relative timing coordinated with the orchestra. The difficulty lies in getting the timing right and being faithful to the drama, the same challenge the singing parts present, except I find it more difficult to keep an ear on what's happening in the orchestra while speaking. I chose to memorize the piece to free myself to commit more fully to the drama, but with limited rehearsal time with the orchestra, that work has to be done before the first rehearsal. Thankfully, my partner, pianist Stephen Gosling, reduced the orchestration, combined it with the piano part and made a midi recording so I can practice with it. However, he still has to (even more thankfully) watch the score to make sure I'm with the music when I'm practicing the timing. 

Opera singers memorize whole evenings of text, often in a foreign language, which is a challenge, but the music and staging offer triggers to use as road marks. Reciting text alone from one place on stage I find more difficult.  It is crucial for me to delve completely into the story to remember what’s next. I'm learning, too, that reciting text and singing text require different diction. The kind of English diction required for a singer in a large hall, un-amplified, tends to pop and sputter into a microphone, whereas normal speech patterns aren't quite enough. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1477309099360/2016-10-24---NancyAllenLundy.jpg.jpg)<figcaption>Nancy Allen Lundy, soprano. Photo by Masataka Suemitsu.</figcaption>
</figure>

## What kind of reaction do you sense from the audience when you perform *Dracula*?

I've only performed the piece once before, this performance with ACO at Zankel will be my second time. That first performance was entirely enjoyable. I sensed the audience was with me and wrapped up in the story. I heard a few laughs, no screams of terror.

## Do you have any favourite moments in the piece?

All of them! It is a dream for the soprano to be able to do a sizable narrative while being the only actor on stage committed to an epic scena. 

I would like a to say a few things about the prose. Alfred Corn is the brilliant wordsmith of this beguiling story. I can't say enough about how beautifully crafted the text is. The words are like music, tripping and bubbling off the tongue. They are a pleasure to speak, and every phrase is an economic distillation of words to convey intention. Each adjective is chosen with utmost care: as she realizes her inevitable fate, she has "the sudden piercing intimation" of what she will one day be, "this twilit picture of discretion, the set of his features calm as an engraving of one who lets words of gratitude pass in silence as he settles to the task". 

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/1oXHuhzj0Rc" frameborder="0" allowfullscreen></iframe>
</figure>
