+++
author = ["authors/madison-arsenault.md","authors/danielle-simpson.md"]
categories = "Op-ed"
date = "2016-11-26T14:20:00+00:00"
lastmod = "2016-11-28T12:35:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480331275889/2016-11-28---Yoga.jpg.jpg"
publishDate = "2016-11-28T12:20:00+00:00"
short_description = "On December 15th, opera singers will come together for a yoga and meditation practice specifically designed for their profession. We are Opera Yogis Madison Arsenault and Danielle Simpson, and we have designed a 2-hour workshop for singers who want to carry the benefits of yoga into their singing."
slug = "dont-miss-yoga-mindfulness-for-singers"
title = "Don&#039;t miss: yoga &amp; mindfulness for singers"
+++

Opera singing is tough. It is physically and mentally demanding, competitive, and requires complete and utter dedication to the craft. Opera singers train like elite athletes to maintain the coordination of their technique so that they can fling themselves around the stage, cry, laugh, and bend-over backwards while producing flawless, healthy, beautiful sound. Even the audience knows that these moments of operatic brilliance take several hours of working on the music, technique and stagecraft. What many people don't see is the enormous amount of mental and physical preparation that has led to these fleeting moments on stage. 

Practicing yoga can help with this preparation by cultivating physical strength and mental clarity. 

Alexander technique has become very popular in the opera world, and has proven to be immensely helpful when it comes to correcting postural alignment and moving more freely. However, yoga goes a step further and gives you insight to your mental and emotional processes. We must be able to sing challenging and beautiful repertoire, while maintaining a healthy, supported sound, all while rolling around the stage in a dramatic frenzy. A perfect example that comes to mind is Jane Archibald’s performance as Donna Anna in the Canadian Opera Company’s 2015 production of [*Don Giovanni*](/in-review-tcherniakovs-don-giovanni/). Making all of this look believable and sound amazing is not easy, and an opera singer who can successfully make this happen has done a lot of mental and physical preparation.

Practicing yoga is one of the best ways to help us achieve this, and keep our bodies strong and flexible. Not to mention the profound positive effect a regular practice can have on our emotional and mental health. Practicing yoga daily can dramatically improve your overall health. Many of the asanas (poses) target the specific muscles we use for singing. For example, practicing some gentle side bends daily can help open up and strengthen your intercostal muscles, which we depend on for breath management. Yoga is an ancient craft, and there are thousands of asanas that target every single muscle and joint in the body. So it isn’t a surprise that many of our opera idols practice yoga daily, and some actually become yoga teachers. Measha Brueggergrosman, soprano and certified Bikram Yoga Teacher, shared some perspective on her experiences with yoga in *Classical Singer Magazine* (March 2011):

"A lot of my yoga practice has to do with silencing that voice that would have you come out of the posture or not remember the words or think negative thoughts or dwell on things that aren’t important. It kind of speaks to the psychology of singing."

Hatha yoga is a physical practice, however so much of the practice involves observing the self, getting to know your thought process and making the positive changes that are necessary to achieve the highest level of performance on stage and in daily life. Developing a mental practice alongside the musical rehearsal is the best way to accelerate your rehearsal time and enhance your performance quality. Mental preparation in the form of yoga, meditation and visualization gives the artist a strong foundation on which to build the musical and technical skills.

Whether you are performing in the practice room, in an audition or in front of thousands of people, your process and your source of energy does not change. Being a master of your mind and body in each situation allows you to rename "stage fright" as performance energy to fuel an exciting performance. It allows you to be more present and precisely direct your energy on stage, becoming a magnet for the audience. By cultivating the awareness of your own body and mind, you also become more responsive to the energies of the people on stage with you. This awareness makes you a better collaborator, and creates magic on the stage as part of ensemble. 

Mental work can take on many forms. It can be as elaborate as a daily yoga practice (movement meditation) with additional meditation and visualization multiple times a day, or it can be as quick and efficient as repeating one mantra before stepping out on stage. In the beginning, give yourself small attainable goals and work your way up to a bigger practice. The more you practice the more you will notice the results carry over into your performance.

### Don't Miss: Yoga & Mindfulness for Singers Workshop

On **December 15th, 12-2pm** at Toronto's Bloor St. United Church, opera singers will come together for a yoga and meditation practice specifically designed for their profession. We are Opera Yogis Madison Arsenault and Danielle Simpson, and we have designed a [2-hour workshop for singers](https://www.eventbrite.ca/e/yoga-and-mindfulness-for-singers-tickets-29509795593) who want to carry the benefits of yoga into their singing.

The workshop includes a hatha practice to open up the parts of the body that carry stress from performance and strengthen those that support healthy singing. It also includes a guided mediation for performance preparation as well as many key take home practices.

Find us on [EventBrite](https://www.eventbrite.ca/e/yoga-and-mindfulness-for-singers-tickets-29509795593) to reserve your spot.


