+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-12-12T20:18:00+00:00"
lastmod = "2016-12-14T17:31:00+00:00"
preamble = "There's a neat irony in the fact that *The Pirates of Penzance* had its debut in New York City, where the copyright laws didn't protect Gilbert or Sullivan from the bootlegged versions that popped up around the United States after its successful premiere. Piracy aside, *Penzance* is a sure G&S classic, and this month [Toronto Operetta Theatre](/scene/companies/toronto-operetta-theatre/) puts it up on the stage of the St. Lawrence Centre for the Arts.\n\nFrom **December 27 to January 8**, [*The Pirates of Penzance*](http://www.torontooperetta.com/shows.html) stars Canadian talent like [Colin Ainsworth](/scene/people/colin-ainsworth/) as Frederic, [Vania Chan](/scene/people/vania-chan/) as Mabel, and both [Janaka Welihinda](/scene/people/janaka-welihinda/) and [Nicholas Borg](/scene/people/nicholas-borg/) sharing the role of the Pirate King.\n\nWe spoke with the four singers about TOT's latest G&S offering, and what's fun about it. [Click here](http://www.torontooperetta.com/shows.html), for more show details, and [click here for ticket info.](http://www.torontooperetta.com/tickets.html)"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1481574838530/2016-12-12---Penzance.jpg.jpg"
primary_image_credit = "From top left: Vania Chan (Mabel), Janaka Welihinda, Nicholas Borg (both The Pirate King) & Colina Ainsworth (Frederic)."
publishDate = "2016-12-14T16:33:00+00:00"
related_articles = ["articles/in-review-los-gavilanes-at-toronto-operetta-theatre.md","articles/die-fledermaus-die-flederfabulous.md","articles/tots-pirates-of-penzance-a-glorious-thing.md"]
related_companies = ["scene/companies/toronto-operetta-theatre.md"]
related_people = ["scene/people/janaka-welihinda.md","scene/people/colin-ainsworth.md"]
short_description = "&quot;Pirates is part love story, part silly romp which pokes fun at everything ranging from love, youth, getting old, authority to politics.&quot;"
slug = "dont-miss-the-pirates-of-penzance-with-tot"
title = "Don&#039;t miss: The Pirates of Penzance with TOT"
+++

## What can you tell us about your role?

**Colin Ainsworth**: Frederic is a young apprentice of pirates who has just reached the age where he can choose whether or not to stay with them or leave. Still very naïve and uneducated about the ways of the world, he slowly begins to find his way after meeting Mabel, his love interest.

**Vania Chan**: Mabel is young, idealistic and spunky. She's a daddy's girl, and usually gets what she wants. Unlike her sisters, she takes a chance on Frederic (a young former pirate), and willingly gives him her heart. Though Mabel is brave, she is also quite naïve. Both she and Frederic feel bound to "a sense of duty", and without giving too much of the plot away, let's just say Mabel is ready to wait a *long* time for Frederic to marry her.

**Nicholas Borg**: The Pirate King is a man so jaded by the hypocrisy of polite society that he believes piracy to be comparatively honest! Despite being a man of little grace and tact, the Pirate King is tender-hearted to a fault. His ship will never attack a weaker vessel than his own, and never pillages those who claim to be orphans (a loophole which is exploited by nearly every ship they meet). 

**Janaka Welihinda**: The Pirate King is someone who is a calculating, self-assured, swashbuckling, charismatic leader. He's funny and he knows it. The King is an orphan, so he had to have learned these skills and develop these qualities to survive and get to the position he is in now. Because he's had to scrape for everything he has and growing up in such a chaotic world, he doesn't feel comfortable not having control. He has to have everything going his way. When things aren't going his way, he is greatly motivated to use whatever tactics, no matter how dirty, to gain back the upper hand in a situation.

## What do you like about performing Gilbert & Sullivan? Are there any unique challenges with their work?

**Chan**: It's pure fun and farce. It's a joy to be a part of this production because the laughs are limitless, even throughout the process of rehearsing/staging. Of course, I also love the catchy G&S tunes.  I'd say the most iconic Gilbert & Sullivan challenge is their "patter songs". In other words, singing tongue-twisting text at rapid-fire speed. I think speaking the text first is always a helpful method of practice especially in the case of patter songs. 

**Welihinda**: My favourite jokes are very clever and involve wordplay.  Gilbert was very clever, and he can take something normal you've heard before, and develop it into such a funny situation. Because Gilbert is such a precise wordsmith, he often composes these long sentences with lots of complex ideas crammed into them. The biggest challenge is getting all of those ideas across in a clear and meaningful way. Sullivan compounds to this challenge by setting these long sentences to a short amount of music. Gilbert's use of consonance and alliteration, combined with Sullivan's settings give us quite the tongue-twisters with which to play.

**Ainsworth**: Performing Gilbert & Sullivan is unique in that, every performance and every cast can be completely different from another - different jokes, completely different character choices, and different cultural or local references. That is part that makes their operettas so much fun and challenging at the same time.

**Borg**: Gilbert & Sullivan combine wit, wordplay, and hilarity with brilliant music. It has the text driven immediacy of musical theatre within the tonal and vocal scope of romantic opera. Each of their operettas drip with satire: Gilbert's texts skewer the social classes and inept government officials in a way that more than ever speaks to our modern times, while Sullivan's music satirizes the melodrama of the operatic medium (an angry mob singing about how sneaky they are, at a fortissimo dynamic level!). I enjoy performing Gilbert & Sullivan because the stories are far-fetched and they don't apologize for it. A unique challenge is simply making sure the text is as clear as possible while maintaining vocal integrity! An acting challenge of working on Gilbert & Sullivan is maintaining the personal reality of each situation within a non-sensical, topsy-turvey universe where anything could happen. Working with TOT on this project brings together a team so equipped for these challenges. Our Maestro Derek Bate has a sensitivity to the music and text that brings out the best in the music, while Guillermo Silva-Marin's staging will keep you in stitches. 

## What do you think *Pirates of Penzance* is about?

**Ainsworth**: *Pirates* is part love story, part silly romp which pokes fun at everything ranging from love, youth, getting old, authority to politics.

**Borg**: *The Pirates of Penzance* is about the struggle between love and duty. Frederic's love for Mabel vs. his duty to the pirates; Mabel's resolve to Frederic in the face of insurmountable circumstances; the Pirate King's sensitivities vs. his piratical leanings. This show is also about how one small piece of missing information can change your whole perspective on people and who they are. 

**Welihinda**: *Pirates* is loosely based on the *Ballad of Bob the Burglar*, and a one - act they had previously produced called *Our Island Home*. Just like *Seinfeld* or *Curb Your Enthusiasm*, there are many story lines expertly crafted in the medium of a burlesque of Italian opera. It is the original "show about nothing" - light fluff that's quite the crowd pleaser, with lots of *deus ex machina* abound. As Dr. Sullivan referred to it, "it is an eccentric opera".

**Chan**: You could dissect *Pirates* and notice that there are a lot of topics that are being touched on - youth and maturity, honour and duty, young love and unrequited love, cultural status, and the notion of family and orphans. I like to think that all of these themes are wrapped up nicely in one big bundle of lighthearted entertainment. I believe an audience of all ages will enjoy the memorable music and the nonsensical comedy that "Pirates" has to offer.
