+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-10-19T22:43:00-04:00"
lastmod = "2015-10-21T09:38:00-04:00"
preamble = "On November 7th, the [Canadian Art Song Project](/scene/companies/canadian-art-song-project/) presents a concert of new music, featuring some of my favourite artists. Sopranos [Ambur Braid](/talking-with-singers-ambur-braid/) and [Carla Huhtanen](/scene/people/carla-huhtanen/) join pianist [Steven Philcox](http://www.canadianartsongproject.ca/about/) and dancer [Jennifer Nichols](https://twitter.com/JennEMethod) in a showcase of a brand new song cycle by Erik Ross *The Living Spectacle*, and music by Brian Harman (*Sewing the Earthworm*), Libby Larsen, and Richard Strauss. I spoke with Canadian Art Song Project co-founders Lawrence Wiliford and Steven Philcox, and composers Erik Ross and Brian Harman about putting this evening together to showcase Canadian music and the people that create it.\n\n*The Living Spectacle* happens November 7th at 7:30pm at The Extension Room, 30 Eastern Ave. For details and tickets, follow the box office links below."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445308457010/spectacle.jpg.jpg"
primary_image_credit = "Clockwise from top left: Carla Huhtanen, soprano, Jennifer Nichols, dancer, Ambur Braid, soprano, Steven Philcox, pianist."
publishDate = "2015-10-21T09:38:00-04:00"
related_companies = ["scene/companies/canadian-art-song-project.md"]
related_people = ["scene/people/lawrence-wiliford.md","scene/people/carla-huhtanen.md","scene/people/ambur-braid.md","scene/people/jennifer-nichols.md","scene/people/steven-philcox.md"]
short_description = "On November 7th, the Canadian Art Song Project presents a concert of new music, featuring some of my favourite artists. Sopranos Ambur Braid and Carla Huhtanen join pianist Steven Philcox and dancer Jennifer Nichols in a showcase of a brand new song cycle by Erik Ross The Living Spectacle, and music by Brian Harman (Sewing the Earthworm), Libby Larsen, and Richard Strauss."
slug = "dont-miss-the-living-spectacle"
title = "Don&#039;t miss: The Living Spectacle"
+++

## 1. Can you tell us about programming this concert?

**Lawrence Wiliford and Steven Philcox**: The programming for this concert came about in a meeting where we discussed the theme of women in extreme situations - pushed to the limits of life. Carla and Ambur came to mind as performers because they are both forces to be reckoned with and have an incredible intensity when they perform. Carla and Steven had recently recorded Brian Harman’s *Sewing the Earthworm* for [Centrediscs](https://itunes.apple.com/ca/album/brian-harman-sewing-earthworm/id982346381) and it was screaming to be included on such a program. Since its premier in 2012 (CASP’s first commission), Carla and Steven have really connected with Brian’s music and we thought it would be great to program it again for CASP’s first official recital season - a full circle moment. We have always felt that the dramatic nature of the piece lends itself to theatricality so we have invited Jennifer Nichols to add the element of movement to the work alongside Carla in a bold new interpretation. We think that the Strauss Ophelia Lieder are a perfect vehicle for Carla and a nice contrast in character too. She jumped at the idea and that was that! 

When programming for Ambur, we wanted to find something that would allow our audience to be lost in her chameleon-like ability to inhabit an incredible range of characters. We found that in Libby Larsen's *Try Me, Good King* which takes its texts from the last letters of five of the wives of Henry VIII. A visceral and often moving cycle, we thought it would be the perfect showcase for Ambur's voice and dramatic temperament. Having Ambur on the program also meant that we could program the world premiere of a new song cycle written for her by Erik Ross. *The Living Spectacle* (which, incidentally, is the name we have chosen for the whole evening) is a must-hear cycle that explores Baudelaire’s fascination with death in a beautiful English translation by Roy Campbell. 

One of the things that we find most exciting about the programming for this concert is the balance of Canadian and non-Canadian works. The Canadian repertoire is of a standard that it deserves to be heard next to established repertoire. It gives all of us an opportunity to hear these new works in context with the broader repertoire and creates a global and temporal conversation over the evening. We are hoping to help revitalize the voice and piano recital in Toronto by creating environments that compliment the repertoire of specific concerts - so the studio atmosphere of The Extension Room is perfect for this program.

### 2. What is significant for you about the death poetry of Charles Beaudelaire?

**Erik Ross, composer,** ***The Living Spectacle***: This project's inspiration for poetry came from Ambur, so she would be an interesting person to ask about this as well. 

For my part, I loved setting this poetry because of its dynamic range of emotion amongst the characters that are portrayed. From the *Death of Artists*' lightly wafting scents to its bannered flames; the Evil Monk's tumultuous conflict and perceived fall from grace simply because of the love of his eye, something he believes that all must see, his "living spectacle"; the *Death of Artists*' consummation of subtle schemes to its hammering of brows and bosom! 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445310486554/pasted-graphic-1.jpg.jpg)
<figcaption>Erik Ross, composer. Photo courtesy of erikrossmusic.com.</figcaption>
</figure>

### 3. What can you tell us about *Sewing the Earthworm*?

**Brian Harman, composer**: The setting for *Sewing the Earthworm* was inspired by an anecdote about Albert Einstein: he loved to garden, but couldn’t bear the accidental killing of creatures living in the ground. *Sewing the Earthworm* begins with a lonely woman contemplating her garden as a haven for both herself and the many forms of life she tends to within it.

This physically deteriorating woman remains thankful that her hands can still control larger clumps of dirt in the maintenance of her private garden. She remembers her former abilities, especially with finer manual endeavours, and laments that her mind has remained long enough to know her body’s condition.

When she accidentally cuts an earthworm in half while gardening, she decides to
attach the pieces with needle and thread to save its life. The seemingly futile attempt is compounded by her desire to prove that physical control has not abandoned her, and the piece makes a rapid shift both musically and textually as a mental struggle takes over.

### 4. What’s it like to write for specific singers, like Lawrence Wiliford and Ambur Braid?

**Erik**: It is a gift. A remarkable gift. I think that the incredible part is how much you learn about each singer in how they interact with your music and the text of the poet. You can discover their personality and their character in how they interpret the score and how that is delivered through their personal voice. There are these intense moments when you get to know and love individual voices...  the power and force of Lance's high range and the beauty and subtlety in his phrasing. Simply gorgeous. After listening to the recording of Lance and Steven's premiere of the *Sun Rising* many times (my iTunes counter currently says 83) I wrote them a letter of thank you that I won't include in it's entirety, but it did contain the following line: "My god, the two of you together... I hope that you never stop." 

Ambur is also sublime. I have only met with Ambur one time and as soon as she started singing I had to fight myself to not melt into the piano as I played. A gorgeous sound and tenacious spirit. She is also remarkable in saying quips, such as (after singing so many high C sharps in row and I suggest a break):  "I don't get tired".  Who says that?! They both, as so many musicians do, have an intense passion an incredible dedication to their art forms. Glorious people to know and work with. 

### 5. What’s it like to compose for a singer like Carla Huhtanen, and work with writer David Brock?

**Brian**: These two collaborators have been incredible to work with. Carla introduced and matched David and I for this project, and we immediately had great chemistry as artistic collaborators, which is extremely rare. We’re both openminded and are constantly bouncing ideas off each other. We’re interested in similar themes, but at the same time we push each other in new directions. David is very skilled at creating text that works very well musically, which makes my job a lot easier.

Carla is an incredible performer, but I describe her moreso as an interpreter. She doesn’t just sing the music you give her — she delves deep into the reasons for musical and textual decisions, and truly transforms into the character she is asked to portray. Because of her vast experience, she also provided valuable feedback during the creative process about text, pacing, vocal writing and lots of other tricky things that composers and writers are required to navigate. She is also a pleasure to write for because she has such a versatile voice that can portray so many different emotions with great subtlety. She tackled all the vocal challenges I wrote into the piece and made it her own.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445310539657/Brian-Photo-Tangent-Ensemble-2.jpg.jpg)
<figcaption>Brian Harman, composer. Photo courtesy of portmanto.ca.</figcaption>
</figure>

### 6. How do you anticipate *Sewing the Earthworm* will complement Jennifer Nichols’ choreography?

**Brian**: I’m really excited about [Jennifer](https://twitter.com/JennEMethod)’s choreography adding a whole other dimension to *Sewing the Earthworm* in performance. Like Carla, she has taken the time to absorb everything in the work and understands it so well. Her presence in the performance will amplify and strengthen the concepts that David and I worked with, and will give more dimension to the main character in the work, as if we’re able to see this character from two sides at once. I’m also excited to see what new elements the choreography brings to the piece. Jennifer and Carla are pushing each other as artists in many ways in their development of this performance, since this is a new collaborative experience for both of them.

### 7. Why is art song relevant or is art song relevant? Do you see art song differently from other vocal chamber music?

**Erik**: There is an intimacy to art song that makes it unique. It seems obvious, but the fact that it is a dance of only two makes it incredibly intimate for the performers. In addition to this, performers who have done this art form for a long time are astounding to watch in that they quite literally breathe together, and they feel every phrase together in a very personal way.

**Brian**: I don’t like to get too hung up on genre categories — art song vs. vocal chamber music vs. opera. All of these can have different meanings and different results in the hands of different composers and librettists/writers/poets. All of them can be incredibly relevant as long as they are approached in a thoughtfully modern way, and they address themes or ideas that are relevant to modern society.

The works that are the most interesting to me blur the boundaries between these genre boxes. In creating *Sewing the Earthworm*, David and I rarely talked about genre, and I think the result is a work that sometimes acts like an art song, sometimes an opera and sometimes chamber music that is slightly more abstract. As a composer I like to be able to move between these different modes of expression. The added dance element in this upcoming performance will even further distort genre, perhaps bringing it closer to the opera world.

>The Living Spectacle happens November 7th at 7:30pm at The Extension Room, 30 Eastern Ave. For details and tickets, follow the box office links below.
