+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-02-02T21:26:00-05:00"
lastmod = "2018-02-03T11:11:00-05:00"
preamble = "Following their opera mash-ups with physical theatre ([*Revolutions*, 2013](/in-review-tapex-revolutions/)), turntablism ([*Tables Turned*, 2014](/in-review-tapex-tables-turned-or-go-see-this-show/)), and punk rock ([*Metallurgy*, 2015](/he-saidshe-said-tapex-metallurgy/)), Tapestry Opera continues its *Tap:Ex* series with [*Forbidden*](https://tapestryopera.com/tapex-forbidden/), **February 8-10, 8pm**, **February 11, 4pm**. The \"21st Century Hip Hop Opera\" features music by Iranian-born composer Afarin Mansouri, and a libretto by Afro-Caribbean hip hop artist Donna-Michelle St. Bernard; singers Neema Bickersteth, [Alexander Hajek](/spotlight-on-alexander-hajek/), and Shirin Eskandani join Farsi spoken-word artist Saye Sky. Tapestry Artistic Director [Michael Mori](/scene/people/michael-mori/) directs, with music direction by [Michael Shannon](/michael-shannon-the-opera-pianist/).\n\nWe spoke with Mansouri and Eskandani about this one-of-a-kind event, and their unexpected connection in Iran."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1517624490236/sq---TapEx.jpg.jpg"
publishDate = "2018-02-02T22:04:00-05:00"
related_articles = ["articles/he-saidshe-said-tapex-metallurgy.md","articles/in-review-tapex-tables-turned-or-go-see-this-show.md"]
related_companies = ["scene/companies/tapestry-opera.md"]
short_description = "&quot;As a female composer with a Persian background, I have the privilege to be able to see the performance of my opera. It brings tears to my eyes, knowing many Iranian music masters who have written great operas that are forbidden to be performed on stage. Having this privilege, it is my responsibility to create.&quot;"
slug = "dont-miss-tapex-forbidden-we-are-tough-and-resilient"
title = "Don&#039;t miss Tap:Ex Forbidden: &quot;We are tough and resilient.&quot;"
+++

## Can you tell us about the chance discovery of your connection in Iran?

**Afarin Mansouri**: Michael Mori introduced Shirin to me. I was so excited to meet an Iranian opera singer of such a high artistic calibre. I was interested to learn more about her, and that's when I found the magical link between us. Shirin is the granddaughter of Khatereh Parvaneh, one of the most well-known Iranian singers. 

Khatereh was the lifelong artistic partner of my piano instructor, Ophelia Partov. They used to perform together around the country and on TV programs but after the revolution, female musicians went through many hardships. Singing solo became a forbidden act for women. After years of sacrifice and effort, finally Khatereh and Ophelia received permission to arrange concerts for female audiences only, and they could perform again together on the stage. Ophelia is one of my greatest role models. I remember attending the performances of these two wonderful women, and I was amazed by their energy, love and passion. 

**Shirin Askandani**: Afarin and I connected through Michael after he had approached me to be part of *Forbidden*.  Michael sent an introductory email, and that's when things took off.  Afarin had googled me and discovered that my grandmother was Khatereh Parvaneh, a famous classical Iranian singer.  Afarin had studied piano with my grandmother's pianist, Ophelia Partov.  My grandmother and Ophelia were incredibly close.  Not only had Afrain worked with one of my grandmother's closest friends and colleagues, but she had also had attended my grandmother's concerts in Iran.

**Afarin**: When I found out the connection with Shirin, it brought back so many memories from Iran.  I found a new meaning in composing Forbidden while remembering the efforts of these wonderful women. It gave me more strength.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1517624726311/afarin-shirin.jpg.jpg)
<figcaption>(l-r) Afarin Mansouri, composer, and Shirin Eskandani, mezzo-soprano.</figcaption>
</figure>
 
## What sort of relationship do you see between this production's theme of "Forbidden", and women's roles with classical music (both Persian and Western)?

**Afarin**: Historically female musicians have faced numerous obstacles, such as not being able to share their composed music (using their own names), sing, and perform.  Perhaps Western female musicians now have more privilege than many Eastern musicians - especially female musicians - considering that we are living in an era when equality is a significant consideration when it comes to musicians and their gender. We should ask ourselves, "what is our role as artists in advocating equity, regardless of gender?"

**Shirin**: My grandmother and Ophelia fought incredibly hard for female musicians in post-revolution Iran. My grandmother was a celebrity in Iran before the revolution. She and Ophelia traveled all over the world performing; they appeared often on Iranian radio and TV.  After the revolution, it was forbidden for Iranian women to sing solo on stage. Many female performers left Iran and continued their careers abroad.  My grandmother decided to stay, as Iran was home. She and Ophelia continued to collaborate and they taught the next generation of singers and pianists in their homes.  I have vivid memories of my grandmother being surrounded by women young and old around her dining room table.  She would teach them what her masters had taught her, ensuring that the knowledge and legacy would continue through them. Finally in the 90s it became legal for women to perform for female audiences, so my grandmother - in her 70s - started performing on stage again. Through it all, she and Ophelia were champions of women in the arts.

**Afarin**: To me, art is a transcendent expression of emotions, affections and human intellect, no matter what is the gender of an artist. Can anyone forbid those elements, or limit them based on gender and physical form?  History has shown this is impossible. 

**Shirin**: One thing that always stands out to me is that you cannot repress art. No matter how forbidden you may make it, no matter how harsh the punishments may be, people will continue to make and perform art.  Especially women; we are tough and resilient.

**Afarin**: As a female composer with a Persian background, I have the privilege to be able to see the performance of my opera. It brings tears to my eyes, knowing many Iranian music masters who have written great operas that are forbidden to be performed on stage. Having this privilege, it is my responsibility to create.

**Shirin**: While in the West there aren't as many things that are explicitly forbidden, I can't help but think of the lack of female representation in the world of classical music. Female musicians. Female conductors.  Female composers.  Female directors.  Female artistic/general directors.  That's why it's so exciting to work with Tapestry Opera on this project - I look around me and am surrounded by all these amazing female artists.  Sadly it's not the norm, but I hope that in the coming years, there will be a shift in our community.
 
**Afarin**: I have a personal experience from the recent ban Donald Trump placed on Persian-born people from entering the United States. It was issued at exactly the time when I was invited to hear the US premier of one of my orchestral pieces called *Natalis Solis Invicti* (*Birthday of Unconquered Sun*) in Memphis. Unfortunately I could not go, but the music was performed. Interestingly, the message of the piece was about love, written based on Rumi's poetry. This experience is the perfect illustration of my point that art cannot be suppressed, no matter the circumstances.
 
## What do you hope audiences take away from *Tap:Ex Forbidden*?

**Shirin**: I love that Afarin and Donna Michelle have created a work that explores universally forbidden subjects. They haven't focused on one country, and they touch upon issues that affect all of us - in the West, in the Middle East, all over the world. We all have to grapple with the idea of what the "forbidden" is, as imposed on us by our families, society, religion, etc.

**Afarin**: *Forbidden* has a universal language that applies to all cultures, religions, race, gender and beliefs. I hope audiences re-think their notions of what is "forbidden". What does that mean? Can some of the rules be re-written; re-created? What is the role of an individual in all of this, and what is that fine line that once crossed, can change a forbidden act to a forgiven act in today's world? 

>Tap:Ex Forbidden runs February 8-10, 8pm and February 11, 4pm at the Ernest Balmer Studio. For details and ticket information [click here.](https://tapestryopera.com/tapex-forbidden/)
