+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-05-19T17:00:00-04:00"
lastmod = "2017-05-22T22:28:00-04:00"
preamble = "*Songs of the Soul Beams*, the award-winning new song cycle by Felix Jarrar and Brittany Goodwin, is set for its world premiere at the Brooklyn Academy of Music, **June 4, 8pm**. The cycle deals with themes of grief and loss, and it features soprano [Corrine Byrne](/scene/people/corrine-byrne/), baritone [Jeremy Hirsch](/scene/people/jeremy-hirsch/), singing actors Goodwin and [Petra Jarrar](http://www.petrajarrar.com/), harpist [Mélanie Genin](http://melaniegenin.com/), and Felix Jarrar as pianist and music director.\n\nWe spoke with members of the creative team behind the debut performance for *Songs of the Soul Beams* about writing music for unique combinations of musicians, and why when it comes to grief, its \"OK to not be OK.\"\n"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1495227693161/2017-05-20---BAM-Jarrar.jpg.jpg"
publishDate = "2017-05-22T10:52:00-04:00"
related_people = ["scene/people/corrine-byrne.md","scene/people/felix-jarrar.md"]
short_description = "&quot;I want the audience to take away the fact that it is OK to talk about grief. It is OK to talk about loss. Most importantly, it is OK TO NOT BE OK. As the composer, I wanted to normalize the experience of grief through this musical work.&quot;"
slug = "dont-miss-songs-of-the-soul-beams"
title = "Don&#039;t miss: Songs of the Soul Beams"
+++

## What can you tell us about the subject of *Songs of the Soul Beams*?

**Felix Jarrar**: *Songs of the Soul Beams* is a theatrical song cycle that explores the depth of loss and mourning. Last year, during the production of my second opera, *The Fall of the House of Usher*, my collaborators and I experienced a series of personal losses. Brittany Goodwin, the director of the opera, lost her grandmother. Corrine Byrne, the soprano who created the role of Lady Madeline, lost her mother to cancer. My father passed away from cancer during this time period as well. These losses left us devastated, grieving, and struggling to pick up the pieces of our lives, which had been shattered by these profound losses. 

This past fall, Brittany came up with the concept of writing the libretto for a theatrical song cycle based on our own experiences with grief and those of our close friends. Each song is a story or a memory about a dead loved one. The title comes from a line of text from the fourth song, "Walking past a window". The line, "Where were the orb lit lanterns and swirling soul beams?", really resonated with our team of artistic collaborators. The idea of a soul beam became integral to the creative synthesis of the work. 

In each of the songs, the soprano and/or baritone projects the soul of each dead person. The work consists of nine songs. The singular theme in the song cycle of "where you go when you go" is expressed explicitly by all the performers in the first song, "After life", and the fifth song, "Disconnected". "Disconnected" is about the last time I saw my father before he passed away.

## What does the term "theatrical song cycle" mean to you?

**Brittany Goodwin**: Song cycles are these wonderful little vignettes of song and story that you can easily tune in and out of (e.g. "I like this one", "eh, this one's okay"), but in this world of a theatrical song cycle, each member of the ensemble participates to create the world each story lives in. It keeps things tight and unified, as well as satisfying the viewer on a higher plane. The theatricality and physical life our singers and instrumentalists create breaks the monotony of 'singer/instrument/audience' and makes it a special pocket in time. A personal one.

**Jarrar**: I believe the term "theatrical song cycle" best reflects the work's intersections between opera, theater, art song, melodramma, and the tone poem. The genre-straddling designation of the work also speaks to the work's diverse musical style. The musical language of the songs range from second song, "Having Mother's Hands", which is an introduction and fugue based on "O Death, where is thy sting?" from Handel's *Messiah*, to the eighth song, "Tina", which was inspired by Kanye West's song "Fade".

## How did you decide on this combination of instrumentation and voices?

**Jarrar**: *Songs of the Soul Beams* is written for a soprano, baritone, two singing actors, piano, and harp. The singers provide the perspectives of the *lyrisches ich*, the instrumentalists create the sonic world of death, and the singing actors add the element of theatricality. Since all of the deaths that inspired the work occurred during the production of *The Fall of the House of Usher*, I wanted to incorporate some of the voices that brought that work to life in *Songs of the Soul Beams*. Soprano Corrine Byrne and baritone Jeremy Hirsch each have unique timbres that provide me with opportunities as a composer to explore a plethora of dark colors I associate with grief.

The piano is my instrument, and my familiarity with the keyboard allows me to fully explore all of the emotions I feel about loss, mourning, anxiety, and depression. The harp is an instrument that I associate with ethereal, other worldly sounds. I believe that this instrument is the epitome of the afterlife. I wanted the two singing actors to portray Persephone, the goddess of the Underworld, and Melinoë, her chthonic, nymph-like daughter. Persephone, played by librettist Brittany Goodwin, introduces the souls each singer embodies through spoken-word beat poetry that is shared communally between all performers. 

Throughout the work, Melinoë, played by Petra Jarrar, comes across as a lythe and radiant spirit in Brittany’s staging. However, she brings nightmares to life musically and dramatically throughout the work and tortures the singers, the instrumentalists, and even her mother, Persephone, with her dark spells. One example of this occurs in "Tina". The song starts off as a minuet, but the music dramatically switches to a hip house song when Melinoë starts clapping the hip hop beat in a crazed, motoric fashion.

## What do you hope audiences will hear, or take away from the cycle's world premiere at BAM?

**Jarrar**: I want the audience to take away the fact that it is OK to talk about grief. It is OK to talk about loss. Most importantly, it is OK TO NOT BE OK. As the composer, I wanted to normalize the experience of grief through this musical work.

**Goodwin**: There will undoubtedly be two major demographics within our audience: avid opera goers and theatre junkies. I think both will be pleasantly surprised at the crossover and see things from a different lens for the evening. Each song is derived from a personal story - we know these people, we are these people. The audience is bound to find communion.

**Mélanie Genin**: *Songs of the Soul Beams* is unique in the sense that it is exploring our wounds and hopes. Brittany and Felix dig into our story and examine the things that individually shaped us as artists and human beings. I believe the veracity and honesty of these tales will touch the audience's soul. As a harpist, I love working with singers and theater, but I rarely have the opportunity to duet with the piano. It's a treat for me to intricate my sound with the piano. Although the instruments look so different and carry different identities, the audience will be surprised by how similar they are. It is like having a slightly distorted mirror where both instruments reflect each other.

**Corrine Byrne**: The audience for *Songs of the Soul Beams* will feel uncomfortable at times by the rawness of Brittany Goodwin's poetry and Felix Jarrar's settings; these powerful songs, based on true stories, stream of conscious reactions and descriptive images from our own grief and suffering and that of our loved ones, certainly do not apologize or tread too carefully. At other times, the audience will feel embraced by this, as we hope that some of the universal truths, ugliness and beauty alike, are felt in the process of exposing our stories unapologetically.
