+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-05-05T17:01:00+01:00"
lastmod = "2016-05-06T14:18:00+01:00"
preamble = "This month, [Tapestry Opera](/scene/companies/tapestry-opera/) presents the world premiere of *Rocking Horse Winner*, a co-commission with [Scottish Opera](/scene/companies/scottish-opera/) by composer Gareth Williams and librettist [Anna Chatterton](/scene/people/anna-chatterton/). The new opera is an adaptation of D.H. Lawrence's short story of the same name, a tale of skewed ideas of love and luck, about a family's constant struggles with money, and their son Paul, who has a curious knack for predicting winning horses at the betting tracks. Tapestry's [Michael Mori](//michael-mori-on-contemporary-opera/) directs, and Conductor-in-Residence [Jordan de Souza](/at-the-podium-jordan-de-souza/) leads a solid cast, including soprano [Carla Huhtanen](/scene/people/carla-huhtanen/), tenor [Keith Klassen](/scene/people/keith-klassen/), baritone [Peter McGillivray](/talking-with-singers-peter-mcgillivray/), and tenor [Asitha Tennekoon](/scene/people/asitha-tennekoon/), who makes his professional debut with the company.\n\nWe spoke with Michael Mori and librettist Anna Chatterton about *Rocking Horse Winner*, and what the piece says about mental health, luck, and wealth disparity."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1462464596116/2016-05-06---Rocking-Horse-Winner-Press-Photo.jpg.jpg"
publishDate = "2016-05-06T14:10:00+01:00"
related_articles = ["articles/in-review-rocking-horse-winner.md"]
related_companies = ["scene/companies/tapestry-opera.md","scene/companies/indie-opera-to.md","scene/companies/scottish-opera.md"]
related_people = ["scene/people/michael-mori.md","scene/people/anna-chatterton.md","scene/people/peter-mcgillivray.md","scene/people/carla-huhtanen.md","scene/people/keith-klassen.md","scene/people/asitha-tennekoon.md","scene/people/jordan-de-souza.md"]
short_description = "This month, Tapestry Opera presents the world premiere of Rocking Horse Winner, a co-commission with Scottish Opera by composer Gareth Williams and librettist Anna Chatterton. The new opera is an adaptation of D.H. Lawrence&#039;s short story of the same name, a tale of skewed ideas of love and luck, about a family&#039;s constant struggles with money, and their son Paul, who has a curious knack for predicting winning horses at the betting tracks. "
slug = "dont-miss-rocking-horse-winner"
title = "Don&#039;t miss: Rocking Horse Winner"
+++

## What prompted you to choose D.H. Lawrence's story as the source of an opera? 

**Anna**: The composer Gareth William proposed adapting D.H. Lawrence's haunting short story as he felt it was implicitly musical. We were struck by the vulnerability of the young boy at the heart of the story  - vulnerability is an interesting aspect to explore in the genre of opera - with those powerful, cast iron voices bouncing off each other. There is also a real lack of understanding and communication between the mother and her son.  The libretto keeps her tight lipped while the score almost pleads with her to open up.

**Michael**: When the opportunity to produce this piece arose, I had a great conversation with the librettist Anna Chatterton and composer Gareth Williams about their ideas. I wanted to know (as we always ask at Tapestry), "what about this story makes it an opera?" Two things came to the fore that excited me: the beautiful and complicated relationship between mother and son; and the opportunity to cast the voice of the family's house as a chorus, which offers wonderful dramatic possibilities. Also, Anna and Gareth's decision to characterize Paul as a young man on the autism spectrum — instead of a child, as he is in the story — made the dynamic of the relationships even more interesting and current.

## What does "luck" mean, or symbolize, in this story? 

**Michael**: Love? Winning? Money? Paul's love feeds the magic that allows him to "help" his mother by winning money for her, after she keeps singing about always needing more. But is that luck? Since we find ourselves in an era of significant wealth disparity today, I think these are poignant and timely questions to consider.

**Anna**: To Ava (the mother) it means money, to Paul it means love, or lack thereof.

## What is the significance of Paul's developmental challenges? 

**Anna**: Paul is originally a young boy in Lawrence's short story and is incredibly sensitive, which makes him able to be clairvoyant. We felt in order for the story to work on stage, and be contemporary, that Paul should be older. So we made Paul a young man who is on the autistic spectrum, and the gardener in the original story his caregiver. *Rocking Horse Winner* is about a mother who can't feel love for her son - and all the complexities that come with that disconnect. The fact that her son is on the spectrum makes their relationship even more layered and complicated. It is important to note that we don’t directly reference Paul's autism in the opera, it is apparent by how he responds to the people around him and the world. 

**Michael**: My mother was a teacher who regularly worked with students who had developmental challenges. In my lifetime, public opinion and policy on the issues surrounding disabilities have improved dramatically, but they remain poorly understood. In some ways, the story is less about Paul's challenges than Ava's (his mother). If life gave her the entitlements she expected, would she love him any more? Would that love be any easier? I think this storyline quite beautifully underscores the importance of love over status quo and societal pressures, but it also points out the deep complications present in all of our lives as we grapple with these issues.

## In writing the libretto, what challenges are unique to adapting existing literature into a new form?

**Anna**: For me the biggest challenge is figuring out – why now? Why is it important to adapt this text today? I look to find ways to update the story and make it resonate with a contemporary audience. Also, a libretto is a very short text, and must be very spare in order to leave room for the music to tell the story. So it is always a challenge to distill the original source down to the most important dramatic actions.

## This is Tapestry's fourth collaboration with Scottish Opera. What makes the two companies good collaborators?

**Michael**: The whisky! And a more sober commitment to nurturing a living genre.  I have so much respect for Scottish Opera's General Director, Alex Reedijk. He has risked a lot by investing in new works and creative artists, giving them the right canvases to achieve important and great things. This is what drives Tapestry's mission as well, so our partnership is a natural fit. Erm…on reflection, that sounds a bit too earnest. It's the whisky.

>Rocking Horse Winner runs May 27 (preview performance) to June 4 at the Berkeley Street Theatre. For full details and ticket information, follow our box office links below.
