+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-05-21T21:45:00-04:00"
lastmod = "2018-05-28T11:42:00-04:00"
preamble = "If you've ever considered what \"Canadian music\" sounds like, you know that the answer is layered and diverse. on Saturday, **June 2 at 8pm** at Alliance Française Theatre, an all-female trio of musicians answer for themselves, in a program of new music entitled [*No Place Like Home*](http://spectrummusic.ca/event/details/no-place-like-home/). Presented by Spectrum Music and the Toronto Composers Collective, Patty Chan (Erhu), Di Zhang (Yangqin), and Zimen Qin (Gu Zheng) perform distinctly Canadian music that reflects on individual stories of origin.\n\nWe spoke with two of the event's composers (Shannon Graham and Chelsea McBridge) and with Patty Chan about this unique program, and what it means to tell stories of home in Canada."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526953531288/Spectrum-NoPlaceLikeHome.jpg.jpg"
publishDate = "2018-05-24T13:51:00-04:00"
short_description = "&quot;And to have a home, it&#039;s also important to have a place that is not-home - which is easy enough to define if you only feel at home in one place, but much more difficult when, say, you fly across the world and feel like you understand the heartbeat of a totally foreign city. That feeling isn&#039;t home-as-a-place, that feeling is home-as-a-mental-state.&quot;"
slug = "dont-miss-no-place-like-home"
title = "Don&#039;t miss: No Place Like Home"
+++

## Where did the idea of *No Place Like Home* come from?

**Shannon Graham, Spectrum Music Artistic Director and Composer**: It's been a long road to this concert. I initially met performer Di Zhang (who plays the Yangqin) at York University where we were both pursuing graduate studies. I approached her about performing in a Spectrum Music concert. She was enthusiastic about the idea. She had recently moved here from China and mentioned it's her passion to promote Chinese culture. She connected us with the other performers for the concert, Cynthia Qin and Patty Chan. Patty also turned out to be a kindred spirit to this concert idea; she encourages Canadian composers to write new music for Chinese instruments.

The theme "No Place Like Home" came from the ideas of birth place, diaspora, tradition, evolution, and identity.

**Patty Chan, Concertmaster of the Toronto Chinese Orchestra (Erhu)**: To me, home is wherever your heart is. It's not a specific place. I believe that home is where you are loved and where you feel safe. The two pieces that I have written were inspired by searching for commonalities in different cultures, but also celebrating their diversity. In multicultural Canada, I think this is one of our strengths.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526953361486/PattyChan.jpg.jpg)
<figcaption>Patty Chan, Concertmaster of the Toronto Chinese Orchestra (Erhu).</figcaption>
</figure>

## What do you think makes your repertoire "distinctly Canadian"?

**Shannon**: This concert is a great example of a distinctly Canadian repertoire. Composers and performers from different backgrounds (both culturally and musically) are collaborating on a repertoire that's completely new but ultimately a reflection of each ones individuality. Like the Canadian cultural mosaic ideal, at Spectrum Music different genres (be it classical, jazz, or pop) and different cultures (in the last two years we've worked with Israeli, Metis, Ojibwe, Chinese, and Francophone artists) fuse to create a new sound in concert music.

## What stories of home will you tell in this concert?

**Chelsea McBride, Spectrum Artistic Producer and Composer for *No Place Like Home***: I'm excited to tell the stories of home that have nothing to do with home as a place. I've always been deeply attached to the city that I grew up in as home, but the more I grow and travel, the more I realize that it's not so cut and dry - and that our memories of home-as-a-place can often be seen through rose-coloured glasses, or through a kaleidoscope lens. Home can be a person; home can be a state of mind; home can be not as awesome as you thought it was. 

And to have a home, it's also important to have a place that is not-home - which is easy enough to define if you only feel at home in one place, but much more difficult when, say, you fly across the world and feel like you understand the heartbeat of a totally foreign city. That feeling isn't home-as-a-place, that feeling is home-as-a-mental-state.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1526953414622/SpectrumTrio.jpg.jpg)
<figcaption>(l-r) Cynthia Qin (Gu Zheng/Chinese Harp) and Di Zhang (Yangqin/Chinese Dulcimer), members of the Toronto Chinese Orchestra, performing *No Place Like Home*.</figcaption>
</figure>

**Patty**: The *Chan Kol Nidre* is based on the Jewish prayer that is sung on the eve of Yom Kippur. It is a prayer asking God for forgiveness for all our wrongdoings and broken promises so that we can begin anew with a clean slate. It explores the themes of forgiveness, redemption and reconciliation which are common in all cultures. Originally written for erhu and viola da gamba, it is an intimate and gentle dialogue between God and human that ends with hope and compassion.

In *Lullaby*, I have used the melodies of the Lakota People and a Northwestern Chinese folk song and wove them together with voice, zhonghu, and cello. Lullabies are sung around the world to soothe babies, and expresses the love the caregiver feels for the child, promising peaceful slumber and the reassurance that they are safe.

Both the *Chan Kol Nidre* and *Lullaby* have been arranged by Chelsea McBride for erhu, yangqin and guzheng. These pieces express elements of home to me. They are songs of my heart.

>For details and ticket information for No Place Like Home on June 2, [click here.](http://spectrummusic.ca/event/details/no-place-like-home/)
