+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-06-26T12:07:00-04:00"
lastmod = "2018-06-26T12:47:00-04:00"
preamble = "This month, Pacific Opera Project presents the west coast premiere of Rossini's lesser-known opera buffa, [*La gazzetta*](https://www.pacificoperaproject.com/lagazzettarossini). The opera tells the story of Lisetta, whose father Don Pomponio Storione, travels the world putting ads in newspapers in order to find her a \"suitable\" husband.\n\nPOP Artistic Director Josh Shaw designs and directs this production, [running **June 28 to July 7**](https://www.pacificoperaproject.com/lagazzettarossini) at LA's Highland Park Ebell Club. We spoke with Shaw about directing opera, and the freedom that comes with an obscure work like *La gazzetta*."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1530030888966/sqJShaw2018.jpg.jpg"
primary_image_credit = "Josh Shaw, Artistic Director of Pacific Opera Project."
publishDate = "2018-06-26T12:37:00-04:00"
related_articles = ["articles/la-gazzetta-the-funny-papers.md"]
short_description = "&quot;I look at an opera like Gazzetta as a special case for myself and for the POP audience. It&#039;s almost certain that no one in the audience will have every seen this opera, and the story is pretty easy to relate to - a father seeking fame and fortune puts his daughter out in public to gain attention for himself - so I feel comfortable keeping the concept pretty &#039;traditional&#039;.&quot;"
slug = "dont-miss-la-gazzetta-"
title = "Don&#039;t miss: La gazzetta "
+++

### Why do you think *La gazzetta* did not see the popularity of some of Rossini's other opera buffas, like *Il barbiere di Siviglia* or *La cenerentola*?

I think there are probably many reasons for this. First, Rossini had no problem reusing material from other operas. (And I say good for him - you know, opera used to be a business that made money.) So when he went to Naples, he knew that audiences there had not yet heard *Barber of Seville*, so he borrowed from that. In subsequent years when *Barber* became more and more popular, that material "belonged" to *Barber*. (Conversely, things in *Gazzetta* were used in later operas - like the overture which is now known as the overture for *Cenerentola*.)

Secondly, *Gazzetta* was written very specifically for the audience in Naples. The main character was a prominent Neapolitan comedic singer whose part is written almost completely in Neapolitan. It turns out Neapolitan isn't that similar to Italian. So before the invent of supertitles, the main character of the opera is speaking a language the audience can't understand. 

The plot of *Gazzetta* is no more thin (and actually much more believable) than say, *Barbiere*, but it is less direct perhaps. In *Barbiere*, guy wants girl and disguises himself to get here - the end. In *Gazzetta* there is a secondary couple, a father/daughter relationship, and other side plots that kind of distract from the main simplistic plot. I think this makes for a better story, but maybe not. And of course *Cenerentola*'s plot is a classic fairytale, so it was known already.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1530030928524/sqLa-gazzetta.jpg.jpg)
</figure>

## What do you think *La gazzetta* says about women and the concept of marriage?

I don't think the opera has anything of importance to say about that issue. In this opera, Pomponio's advertising of his daughter in the paper is just a quick way to get several characters involved in a silly plot. I don't believe there was any agenda beyond making some laughs and some beautiful music. And by the way, Lisetta gives it back, just as good as she gets it from her father.

## What sort of responsibility does an opera director have in reviving a lesser-known work by a well-known composer?

I wouldn't use the word "responsibility", because I think a director can do whatever he or she wants with a piece if the composer/librettist isn't alive to object. Of course I'm known as a director who likes to update and reimagine operas. I do that for two reasons:  1. To give new opera audiences something they can quickly relate to and identify with to get them in the door.  2. To give seasoned viewers a reason so come see "Opera X" for the twelfth time. 

However, I look at an opera like *Gazzetta* as a special case for myself and for the POP audience. It's almost certain that no one in the audience will have every seen this opera, and the story is pretty easy to relate to - a father seeking fame and fortune puts his daughter out in public to gain attention for himself - so I feel comfortable keeping the concept pretty "traditional".

>Pacific Opera Project's *La gazzetta* runs June 28 to July 7. For details and tickets, [click here.](https://www.pacificoperaproject.com/lagazzettarossini)
