+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-05-30T13:29:00-04:00"
lastmod = "2017-05-31T21:10:00-04:00"
preamble = "June 3rd (St. John Smith's Square, London) and June 4th (Symphony Hall, Birmingham), the [Aurora Orchestra](/scene/companies/aurora-orchestra/) offer up a refreshingly [creative programme with an Alpine theme](http://www.auroraorchestra.com/event/inthealps/). Along with Brahms' *Symphony No. 1 in C minor*, Op. 68, the Orchestra under conductor Nicholas Collon is joined by soprano [Mary Bevan](/scene/people/mary-bevan/) for Richard Ayres' *No. 42: In the Alps*; the \"playful, beautiful and zany piece\" tells the story of a girl on a mountain, who learns to sing to animals and who grows to love the trumpet-playing of a boy in the valley below.\n\nThe Aurora Orchestra is making a name for itself not just with its interesting programming, but with its memorised performances of orchestral staples, as they'll do later this season with Beethoven's *Eroica* Symphony. Ahead of her [first collaboration](http://www.auroraorchestra.com/event/inthealps/) with the Orchestra, Mary Bevan chats about the benefits of memorised performances, and the curious Alpine girl in Ayres' unique piece."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1496250608264/2017-05-31---Bevan-Alps04a.jpg.jpg"
publishDate = "2017-05-31T20:54:00-04:00"
related_articles = ["articles/aurora-orchestra-fun-frankenstein.md","articles/three-big-things-we-can-all-learn-from-singers.md"]
related_companies = ["scene/companies/aurora-orchestra.md"]
related_people = ["scene/people/mary-bevan.md"]
short_description = "&quot;The girl in the Ayres piece In the Alps is a rather odd character; sometimes comic, sometimes sad but also whimsical and passionate. She has been brought up by goats in the wilds of the mountains and at the start, can only sing as the animals do. But then as she grows up, so her longing for human contact also grows and she is drawn to the sounds of the bugle coming from the town below.&quot;"
slug = "dont-miss-in-the-alps-with-the-aurora-orchestra"
title = "Don&#039;t miss: In the Alps with the Aurora Orchestra"
+++

### From a singer's point of view, what can you say about the advantages and challenges of performing music from memory, as the Aurora Orchestra has made it a point to do in recent seasons?

The obvious challenge to learning something from memory as a singer and also as an instrumentalist is that it takes a lot of time. There's no substitute for just sitting down and learning the music, in as many ways as possible. This is the main challenge for any musician - we're all so busy and it can be difficult to find time to sit down for what amounts to quite a few hours to learn something by heart. 

However the benefits far outweigh the challenges. Concerts are more rewarding for the audience and for the performer if there is true communication between the performers themselves and between what is happening on stage and the people watching. The music can really come alive when there is no barrier of music and a stand and you can see everyone's eyes. Emotion in the music is transmitted immediately and the piece can really "take off". 

If I had time I would like to sing everything off by heart but sadly this just isn't possible! Which is why it's great to have learning time actually programmed into rehearsals as Aurora do. Music goes into the memory much more quickly in a rehearsal situation rather than when you're alone with distractions all around. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1496250659881/2017-05-31---Mary-Bevan-7056_-credit-Victoria-Cadisch.jpg.jpg)
<figcaption>Mary Bevan, soprano. Photo by Victoria Cadisch.</figcaption>
</figure>
 
### What can you tell us about the girl in Ayres' *In the Alps*?

The girl in the Ayres piece *In the Alps* is a rather odd character; sometimes comic, sometimes sad but also whimsical and passionate. She has been brought up by goats in the wilds of the mountains and at the start, can only sing as the animals do. But then as she grows up, so her longing for human contact also grows and she is drawn to the sounds of the bugle coming from the town below. She is lonely and longs for the family she lost as a baby and for a soulmate, something which she sees all around her in nature but is unable to enjoy herself. 
 
### How does a piece like this compare to performing a fully-realised role in an opera?

Performing this piece is really only different to performing in a fully-staged opera in that I am on stage all the time for the concert version, and there is less rehearsal time and I am not expected to know the music off-copy. In every other way (i.e. how much I "perform", how I engage with the music and the audience) it is the same as performing on a stage with a director. 

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/D4wmn2LdCRU" frameborder="0" allowfullscreen></iframe>
</figure>

>Aurora Orchestra performs In The Alps June 3-4 at London's St. John Smith's Square, and Birmingham's Symphony Hall. For details and tickets, [click here.](http://www.auroraorchestra.com/event/inthealps/)
