+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-07-08T13:40:00-04:00"
lastmod = "2017-07-10T21:52:00-04:00"
preamble = "At this summer's [Tête à Tête](/scene/companies/tete-a-tete/) opera festival, you can catch the debut performance of [*ID, Please*](http://www.tete-a-tete.org.uk/event/id-please/), the new opera by composer Soosan Lolavar and librettist Daniel Hirsch. With terms like \"Brexit\" and \"Muslim ban\" at the front of our minds, *ID, Please* tells a particularly timely story of unnamed characters at an unknown border control station.\n\n\"*ID, Please* has become a complex process through which I work through my feelings of instability in the new world order, my fears for immigrant communities across the world and my concerns for the safety of my family and friends,\" says British-Iranian composer Soosan Lolavar, who herself was almost prevented from attending rehearsals of her opera in the United States following the first \"Muslim ban\" in early 2017.\n\nLolavar speaks eloquently about her work, and the troubling contemporary history that inspires its story."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499724189237/2017-07-10---Airport.jpg.jpg"
publishDate = "2017-07-10T21:50:00-04:00"
related_articles = ["articles/art-is-not-action.md","articles/tete-a-tete.md","articles/when-art-is-not-enough-opera-activism.md","articles/aams-king-arthur-a-missed-brexit.md"]
related_companies = ["scene/companies/tete-a-tete.md"]
short_description = "&quot;I hope the music takes us through many of the emotions experienced by those crossing borders: fear, hope, suspicion, regret, anger, boredom, alienation and joy. We see glimpses into the lives of many passengers played by two singers and yet we never really find out what happens to them; whether they make it across the border or are stuck in the perjury of border control forever.&quot;"
slug = "dont-miss-id-please"
title = "Don&#039;t miss: ID, Please"
+++

## What is it about the issues relating to xenophobia and suspicion of migrants that you thought would adapt well into an operatic performance?

Myself and my librettist Daniel Hirsch came up with the idea for the opera in April 2016 while I was living in the US. The presidential primaries were in full swing, and the xenophobic rhetoric swirling around them made it a pretty disturbing time to be living there as an immigrant, especially given my Iranian background. We very briefly considered writing a piece about Trump, but this was the point when we all thought he would never receive the nomination. Some of my democrat friends were even hoping that he would get nominated, secure in the knowledge that he could never win and the GOP would be annihilated come election day. 

Of course, we all know what happened next, and in a way I'm glad we didn't base our piece on Trump as I'm not sure I could have stomached a whole year of trying to get inside the mind of his character. In any case, we wanted to produce something with more universal themes. Trump and his agenda are only temporary, but anxieties over borders and foreigners are timeless. 

As such, while the piece focuses on people trying to cross a border, it's more broadly about liminality and the alienation that comes from existing in a space between states. This draws very strongly on my background as someone who grew up across British and Iranian culture. I've spent a lifetime trying to work out how to fit in in both places and I'm not sure I'm ever going to find the answer I'm looking for. I've come to an acceptance that liminality is my default experience and so I suppose it's unsurprising that I seek artistic projects to explore this.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499723497986/2017-07-10---Lolavar-Soosan.jpg.jpg)<figcaption>Soosan Lolavar, British-Iranian composer of *ID, Please*.</figcaption>
</figure>

## How have you portrayed such a contemporary and ongoing story in the form of opera?

To include verbatim text and original research we composed an online questionnaire seeking personal experiences related to crossing international borders. We received about two dozen responses from people in all kinds of situations - from the amusing to the terrifying - and several direct quotes from the questionnaire were included in the libretto. Daniel was also constantly revising the libretto to take account of contemporary events. He added a line about "building walls", as well as one about "checking the teeth" of migrants. This drew on my experiences of visiting the Calais refugee camp where myself and my family carried out some translation work, mostly with Dari-speaking Afghanis. On returning home I was horrified to hear MP David Davis suggest we should be checking the teeth of unaccompanied children brought to the UK for fear that they may be too old. It was such an invasive, cruel suggestion that I felt it had to go in the libretto.

And then when Trump instigated his Muslim Ban mark 1, the whole project came into terrifingly sharp focus when I was temporarily banned from entering the US due to my Iranian passport. There was a worrying few days when I was due to fly out for rehearsals and had no idea if I would be allowed to enter the country. And even more concerning was watching the stories of families separated, refugees refused after two years of background checks and Iranian friends of mine in the US terrified to leave the country for fear they wouldn't be allowed back in. In the end I was able to travel, but while I was standing in line at immigration at JFK, scared and with my legs shaking, a key line from the libretto was ringing in my ears with newfound relevance - "I clutch my passport so hard it makes my hand hurt". 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499723180708/2017-07-10---idplease.jpg.jpg)
<figcaption></figcaption>
</figure>

## What do you hope will be the role of the music in *ID, Please*?

In terms of the music, I was keen to produce an environment of instability through complex rhythms that disrupt the sense of pulse, as well as microtones and glissandi which problematise a stable sense of pitch. Many of these techniques come from my study of Iranian classical music and I thought it aesthetically relevant that a piece like this should draw on the multiple musical traditions that make up my mixed heritage. 

As well as a sense of uncertainty I was keen to bring to light the how static borders can be. I was spending a great deal of time in airports at this time and was struck by how time sitting in the airport was barely, in the real sense, "time" at all. It was a kind of dead zone in which you didn't really exist but were simply waiting for the moment when you would arrive at your destination and, therefore, exist again. As such the music contrasts moments of real tension with moments of stillness and waiting.

I hope the music takes us through many of the emotions experienced by those crossing borders: fear, hope, suspicion, regret, anger, boredom, alienation and joy. We see glimpses into the lives of many passengers played by two singers and yet we never really find out what happens to them; whether they make it across the border or are stuck in the perjury of border control forever. I hope that this gives the piece a timeless quality in which we consider the human experience of border crossing of all kinds - physical, emotional, cultural, psychological - across time and space.

>ID, Please plays on July 25, 9:15pm at Robin Howard Dance Theatre, The Place, 17 Duke’s Rd, London, WC1H 9PY. Tickets start at just £5, and you can find [full details here.](http://www.tete-a-tete.org.uk/event/id-please/)
