+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-01-10T18:39:00-05:00"
lastmod = "2018-01-11T20:27:00-05:00"
preamble = "For one night only on **January 27**, Nashville Opera presents a unique operatic event not to be missed. [*Hercules vs Vampires*](http://www.nashvilleopera.org/hercules), the opera by composer Patrick Morganelli, is inspired by the 1961 cult-classic film by Mario Bava, *Hercules in the Underworld* (*Ercole al centro della terra*); Bava's film is projected in its entirety, and Morganelli's opera - conducted by Kelly Corcoran and directed by John Hoomes - provides a new original soundtrack.\n\nWe spoke with Morganelli about this ingenious project, and the fun combination of film and opera."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1515626811573/2018-01-10---sq---Hercules-Vampires.jpg.jpg"
publishDate = "2018-01-11T20:27:00-05:00"
related_articles = ["articles/opera-meets-cult-film-hercules-vs-vampires.md"]
related_companies = ["scene/companies/nashville-opera.md"]
short_description = "&quot;There will certainly be places in the work where people will laugh at things onscreen which are unintentionally funny. This is a great thing, and I want audiences to laugh if they feel inclined, I want them to cheer Hercules and to boo the forces of evil.&quot;"
slug = "dont-miss-hercules-vs-vampires"
title = "Don&#039;t miss: Hercules vs Vampires"
+++

## What's the most interesting part about combining opera with a film like *Hercules in the Underworld*?
 
Possibly the most interesting part of the experience was in being in the world of film and television scoring and crossing over into the world of opera.  I've been a classical musician my whole life but entering the opera world at the professional level was a new and frankly wonderful experience.  The world of film and television is VERY different.  I should probably let it go at that!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1515627119164/2018-01-10---HERCULES---Hercules-and-Dianara.jpg.jpg)
<figcaption>Hercules (Reg Park) and Deianira (Leonora Ruffo) in *Hercules in the Underworld* (*Ercole al centro della terra*), 1961, directed by Mario Bava</figcaption>
</figure>
 
## What does opera have in common with film?
 
At the most fundamental level both opera and film tend to be based on one thing: storytelling.  And storytelling is still the most compelling aspect of any narrative art form.  Certainly, there are successful - even famous - operas built on stories that are fairly weak in this regard, and without a doubt there is no shortage of movies that lack a discernible story.  But though music and visuals can grip the attention of an audience, no narrative work like opera or film can rise above the rest without a story that resonates for a wide swath of humanity.
 
## What are some unique challenges for you as a composer with a work like *Hercules vs Vampires*?
 
The word unique covers a lot of territory, but I can certainly think of a few key areas.  For me, the technical challenge of creating a work like this was formidable to say the least, and harder than I initially expected.  Many of the techniques and processes that film composers use every day in their work were used here, but the level of complexity was much higher, as I had to get the music to synch with the mouth movements of the characters (to the extent that it's possible) instead of just the action on the screen.  The other challenging aspect of the technical challenge was that the work had to be performable live.
 
Another area of great interest was in working with operatic voices, which, truthfully, I hadn't done before.  Of course I wasn't starting from zero - I'd been a huge opera fan my whole life and I think I knew the literature of opera fairly well - but there's a world of difference between listening to, say, *Parsifal*, and being able to write an opera that isn't grossly incompetent.  The learning curve here was steep, but I was lucky enough to have a couple of friends who have been in the world of professional opera for many years and they helped me along.  I'm deeply grateful for their help!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1515626949983/2018-01-10---ACW2014_PatrickMorganelli-IMG-1930.jpg.jpg)
<figcaption>Patrick Morganelli, composer. Photo: Anna Webber.</figcaption>
</figure>
 
## What can audiences expect from this production at Nashville Opera?
 
Many people think that *Hercules vs Vampires* was done as a way of mocking the original film and making a certain amount of comedic fun out of it.  That's actually not true.  I tried to bring the same spirit to the opera that I believe director Mario Bava brought to the film, namely, to tell an adventure story with many emotional undertones and themes.  That being said, there will certainly be places in the work where people will laugh at things onscreen which are unintentionally funny.  This is a great thing, and I want audiences to laugh if they feel inclined, I want them to cheer Hercules and to boo the forces of evil.  Well, okay, I guess they could also cheer the forces of evil!  Come to the opera and have fun.

>Nashville Opera's [*Hercules vs Vampires*](http://www.nashvilleopera.org/hercules) plays for one night only on Janaury 27, 8pm, at Jackson Hall, Tennessee Performing Arts Center. For details and ticket information, follow our box office links below.
