+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-09-30T11:08:00+01:00"
lastmod = "2016-10-01T21:48:00+01:00"
preamble = "On October 13, in the Natural History Gallery of London's Horniman Museum, [Gestalt Arts](/scene/companies/gestalt-arts/) presents \"Feet,\" a new opera installation for the Museum's [Magic Late](http://www.horniman.ac.uk/visit/events/magic-late) event. Tickets are just £5.\n\n\"Old English cunning folk often used animal parts to create curative charms to ward off a range of ills. But what happened to the animals they left behind?\" With music by [Oliver Leith](http://www.oliverchristopheleith.com/home.html), and text and direction by Ruth Mariner, soprano [Héloise Werner](http://heloisewerner.com/) performs \"Feet\" with the help of the Museum's handling collection of instruments, transformed for the first time through electronic composition.\n\n\"Feet\" will take place on the hour between [6:30-9:30pm, October 13](http://www.horniman.ac.uk/visit/events/magic-late) at the Horniman Museum. We spoke with Ruth Mariner, Artistic Director of Gestalt Arts, about the curious nature of the show, and the \"privileged\" process of working in the Natural History Gallery."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1475227043563/2016-09-30---Feet-Image.jpg.jpg"
primary_image_credit = "Photo courtesy of Gestalt Arts."
publishDate = "2016-10-01T15:02:00+01:00"
related_articles = ["articles/dont-miss-boys-of-paradise.md"]
related_companies = ["scene/companies/gestalt-arts.md"]
short_description = "&quot;It was this juxtaposition, and the indignity of an animal losing its feet for a reason we would now consider to be quite minor, which formed the basis of the idea. Our main character, the pigeon (sorry, rock dove) just wants to tell her story and get a bit of attention for once.&quot;"
slug = "dont-miss-feet-at-the-horniman-museum"
title = "Don&#039;t miss: &quot;Feet&quot; at the Horniman Museum"
+++

## What can you tell us about *Feet* and what makes it an "opera installation"?

Our brief was to create something around the theme of 'magic' for the [Horniman Museum's Late](http://www.horniman.ac.uk/visit/events/magic-late) event. We gained special access to the collections and curators the museum has to offer which has made for an extremely interesting (and very privileged!) creative process. 

We've spoken to Emma Nicholls about magical links to the animals in the [Natural History Gallery](http://www.horniman.ac.uk/visit/displays/natural-history), and to Tom Crowley who gave us a tour of the Horniman's [charms collection](http://www.horniman.ac.uk/collections/stories/magic-charms-and-amulets/story-chapter/keep-safe-and-well-working-magic-into-charms-and-amulets), which features a fascinating array of magical objects including a sheep's heart stuffed with nails. In addition, we also spoke to Maria Magill, primary school learning coordinator, who showed us through the Horniman's [handling collection](http://www.horniman.ac.uk/collections/handling-collection), letting us explore objects by touching them, and play any instrument we wished. 

We ended up selecting just one object which has formed the conceptual basis of the piece: a single dried pigeon's foot which was said to cure cramp. There were many possible avenues to explore, and many themes that emerged that became 'lenses' through which we viewed the other objects to tie them together. 

The pigeon's feet seemed to speak for lots of reasons. In London, pigeons are the most commonplace bird, treated as vermin, yet they are closely related to doves which have a rich symbolic associations and have been glorified throughout history. Within the Horniman's collections, there are a number of 'fancy' pigeons with beautiful feathers (a Victorian obsession) and a Chinese pigeon whistle -- an object which would be attached to pigeon's backs to make music when they flew. 

It was this juxtaposition, and the indignity of an animal losing its feet for a reason we would now consider to be quite minor, which formed the basis of the idea. Our main character, the pigeon (sorry, rock dove) just wants to tell her story and get a bit of attention for once. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1475227023647/2016-09-30---Horniman-Museum.jpg.jpg)<figcaption>The Horniman Museum, London.</figcaption>
</figure>

We called it an "opera installation," because it's a short piece that occurs 3 times throughout the evening, but the performer will also be around other areas of the museum (mainly pecking and insulting and moaning about the other exhibits) when she's not performing her main piece.

## How common is it for site-specific theatre and opera in London? What do you enjoy about the process?

It's pretty common to have operas in unusual spaces, but I guess being specific to a place or a collection is slightly rarer. I've really enjoyed this process, meeting people, getting a sense of the space, its qualities, its atmosphere, looking through the objects and collecting these scraps of tiny stories or themes. 

It could be quite overwhelming in a way, but as long as I have enough time (and actually I only had 2 weeks) I just absorb and daydream and eventually a clear theme presents itself to me, then a structure, and then after that everything becomes quite easy. I think the point is to trust your brain to make the most interesting connections and make work that celebrates the material you have, using any limitation as a source of creative fuel rather than an obstacle.

>[Click here](http://www.horniman.ac.uk/visit/events/magic-late) to get your tickets (just £5!) to the Horniman Museum's Magic Late event, October 13, 6:30-9:30pm.
