+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-05-15T16:41:00-04:00"
lastmod = "2017-05-18T09:47:00-04:00"
preamble = "For the first time, the Hong Kong Arts Development Council is presenting the Hong Hong Music Series in London, **July 7-28**. Part of the Series includes the European premiere of *Datong: The Chinese Utopia*, the opera by composer Chan Hing-Yan and librettist Evans Chan, which chronicles the life of Chinese scholar Kang Youwei.\n\nThe performances happen **July 27-28** at the Richmond Theatre, and it's a rare opportunity to see and hear the work of Hong Kong-based singers and creative artists, tell a story which may be obscure for European audiences.\n\nWe spoke with librettist Evans Chan and Tisa Ho Executive Director of the Hong Kong Arts Festival, about the genesis of *Datong: The Chinese Utopia*, and its much-anticipated Western premiere. For more details and to purchase tickets [click here.](http://hongkongmusicseries.hk/datong-the-chinese-utopia.html)"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1494882648563/2017-05-14---Datong-Square.jpg.jpg"
primary_image_credit = "An image from Datong: The Chinese Utopia. Photo by Yankov Wong, courtesy of Hong Kong Arts Festival Society Limited."
publishDate = "2017-05-16T09:44:00-04:00"
short_description = "&quot;The Kang Youwei story, especially the Hundred Days Reform, has riveted modern Chinese audiences for more than a century, probably as a reminder of the setback for China&#039;s political modernization. The incident has been reimagined in movies many times.&quot;"
slug = "dont-miss-datong-the-chinese-utopia"
title = "Don&#039;t miss Datong: The Chinese Utopia"
+++

## Why are you proud to present *Datong* in London?

**Tisa Ho**: Together with the Hong Kong Arts Development Council, I'm proud and delighted to be able to bring to London audiences an exquisite work created and performed by talent from Hong Kong, which marries east and west, in terms of form and content, in a story dealing with an important moment in Chinese history which also shows, among other things, ways in which the thinking of this great Asian philosopher (Kang Youwei) has intersected with values that are also important in occidental frameworks to this day.

## What is it about the life of Kang Youwei that translates well into an operatic setting?

**Evans Chan**: Even in his own lifetime, Kang Youwei 康有為 (1858-1927) had been legendary enough to be the subject of a Peking opera. One of his poems was about being overcome with emotion while seeing, by accident, his own struggle to reform China being reenacted on stage. 

He was a pioneering constitutional reformer during the waning days of China's *ancien régime*, and the author of *The Book of Datong* 大同書 -- modern China's first Utopian text. For most Chinese, he was best known as the architect of the Hundred Days Reform 百日維新 of 1898, which was the first serious attempt to modernize Qing 清朝, the last dynasty of imperial China. This well-known episode, ending in bloodshed in a crackdown unleashed by the Empress Dowager Cixi 慈禧太后, was evoked in Act One of the *Datong* opera. 

Fleeing the bloody crackdown on reform, Kang went into 16 years of exile, during which he had been treated as China's virtual prime-minister- in-exile. From overseas he orchestrated the anti-American boycott (1905-1906) to thwart the Chinese Exclusion Act in the US. Kang's influence -- more than that of the imperial Chinese government, which put a price on his head -- was such that a reconciliatory President Theodore Roosevelt met Kang twice, and agreed to soften the harsh impact of Chinese Exclusion.

## Does the language barrier present problems to an English-speaking audience?

**TH**: Not at all, opera is enjoyed in many languages, and indeed there is an increasing interest in Mandarin, so this opera might be of interest also from an non-operatic perspective, on top of which, we will be providing excellent subtitles during the performance and a synopsis in the house programme.

## What sort of message does this story tell in its operatic form?

**EC**: I decided to frame Kang Youwei's story through his daughter Kang Tongbi, a pioneering Chinese feminist, whose remarkable life story also began to surface around the time of my research. Tongbi was the first Asian woman to enroll at Barnard College in New York in 1907, and worked on suffragist issues for Chinese women in subsequent decades. She had accompanied her father to drum up international support for reviving stalled reform – such as holding parliamentary elections -- in China. She was her father's comrade-in-arms and eventually a fierce defender of her father's legacy. In Act One of the opera, I used Tongbi's journey to Malaysia to join her ailing father in 1901 to evoke the Hundred Days Reform, as well as another significant achievement of Kang – his enterprising efforts to end foot-binding for Chinese women.

Act Two is set in the US State Department when Kang met Roosevelt. This meeting of two civilizations also marked one of Kang's crowning achievement as a politician.

Act Three leaps to the Cultural Revolution when Tongbi was on her death bed, and her frightened daughter, hoping against hope that she could survive as a Kang descendent at a time when the surrounding political calamity had been inaugurated by a Criticize Kang campaign.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1494883760715/2017-05-14---Datong.jpg.jpg)
<figcaption>An image from *Datong: The Chinese Utopia*. Photo by Yankov Wong, courtesy of Hong Kong Arts Festival Society Limited.</figcaption>
</figure>

## How is the story of *Datong: The Chinese Utopia* perceived in Hong Kong?

**EC**: The Kang Youwei story, especially the Hundred Days Reform, has riveted modern Chinese audiences for more than a century, probably as a reminder of the setback for China's political modernization. The incident has been reimagined in movies many times. *Sorrows of the Forbidden City 清宮秘史* (1947), the pioneering film in dramatizing the Hundred Days, became the target of a campaign in 1967 that escalated the Cultural Revolution. Qing history from the Hundred Days on was adapted into a series of high profile historical films in Hong Kong during the 1970s. In 2003, *Toward the Republic 走向共和*, a mini TV series covering the same terrain, was aired in China, with its last episode being banned. My own docu-dramatic film, *Datong: The Great Society 大同：康有為在瑞典* (2011), focusing on Kang's years of exile, was named the Chinese-language movie of the year by the PRC newspaper, [*Southern Metropolitan Daily 南方都市報*](http://filmint.nu/?p=3847), for "returning fuller memories and humanity to modern Chinese history". 

My film caught the attention of So Kwok-wan, Associate Programme Director of the Hong Kong Arts Festival (HKAF). Subsequently, Kwok-wan approached me to adapt my Kang research into a libretto, and he retained Chan Hing-yan as the composer. The HKAF's 2015 premiere of the Datong opera was a totally sold-out and critically acclaimed event. *The Financial Times* found it "musically intriguing," and [*Bachtrack*](https://bachtrack.com/review-datong- chinese-utopia- hong-kong- festival-march- 2015) hailed it as "a major new opera… that resonates in the Chinese political climate today".

## What do the artists hope to bring to European audiences?

**EC**: I believe the entire *Datong* team would like to remind European audiences about the wealth and vitality of talents in Asia, and the imaginative legitimacy and artistic integrity of inflecting and recreating a Western art form for our own purposes.

Speaking for myself, from the Brexit vote to the election of Donald Trump as the US President, one could recognize a deep discontent about globalization, in the sense that rampant worldwide inequality is exerting a tremendously painful impact on individual sectors of individual nations.

And China, though now regarded as the second largest economy in the world, has been experiencing economic polarization. Part of my interest in conjuring Kang Youwei from the mist of history is to evoke that humanistic, utopian yearning at the origin of the Chinese civilization. Utopia may not be achievable, and its ruthless pursuit through social engineering has presumably caused unimaginable devastation in global modernity.

However, it's been said that progress is the movement toward utopia. And there is always some room for hope even in the darkest times – for me, if *Datong* ends in political tragedy and death, it also ends with mankind's enduring dream.

Below is the ancient verse spelling out the vision of *Datong* -- reactivated by Kang Youwei at the turn of the twentieth century, and set beautifully to music by Chan Hing-yan, which ends the opera:

<br> When the Way prevails,
<br> The world belongs to all.
<br>The able and the good are chosen,
<br>Integrity, accomplishment and harmony are honored.
<br>People care not only for their elders, but other elders as well;
<br>And nurture not only their children, but other children as well.
<br>The elderly end their days in dignity,
<br>The able-bodied are usefully at work,
<br>And the young have good prospects.
<br>Widows, widowers, orphans, the sick and the disabled
<br>Are all taken care of…
