+++
author = ["authors/jenna.md"]
categories = "News"
date = "2016-05-26T21:43:00+01:00"
lastmod = "2016-05-27T13:11:00+01:00"
preamble = "The [Toronto Festival of Children's Opera](http://www.canadianchildrensopera.com/content/TFCO.html) continues on **May 31** with [Composers (of the) Roundtable](http://www.canadianchildrensopera.com/content/composers-roundtable.html), a discussion led by Canadian Music Centre Associate Composer [James Rolfe](/scene/people/james-rolfe/). He'll be joined by [Dean Burry](/scene/people/dean-burry/), Artistic Director of the [Canadian Children's Opera Company](/scene/people/canadian-childrens-opera-company/), as well as several young CCOC performers, for a discussion offering insights, trading ideas and skills, and opportunities for networking.\n\nThe Roundtable happens at the Canadian Music Centre, 20 St. Joseph St., from 7-8pm on May 31. Registration for the event is free, and you can [sign up right here](https://musiccentre.secure.force.com/ticket/#sections_a0F1a000004CS3qEAG).\n\nWe spoke with Rolfe and Matthew Fava, Ontario Regional Director of the Canadian Music Centre, about what they think is valuable and vital to the understanding of writing opera for young audiences."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1464295239271/2016-05-27---James-Rolfe.jpg.jpg"
publishDate = "2016-05-27T13:01:00+01:00"
related_articles = ["articles/the-tfco-kicks-off-with-tolkien.md","articles/the-tfco-a-young-peoples-opera-blitz.md","articles/tfco-opera-trek-the-next-generation.md"]
related_companies = ["scene/companies/canadian-childrens-opera-company.md"]
related_people = ["scene/people/james-rolfe.md","scene/people/dean-burry.md"]
short_description = "&quot;Children express themselves through singing, play-acting, dancing, making up stories, dressing up, and generally being over-the-top - which is pretty much what opera is all about. So a medium which might seem elitist and esoteric to adults comes naturally to children. Kids especially love storytelling, and opera is a great way to tell stories. &quot;"
slug = "dont-miss-composers-of-the-roundtable"
title = "Don&#039;t miss: Composers (of the) Roundtable"
+++

## What is important about writing opera for children?

**James Rolfe**: Children express themselves through singing, play-acting, dancing, making up stories, dressing up, and generally being over-the-top - which is pretty much what opera is all about. So a medium which might seem elitist and esoteric to adults comes naturally to children. Kids especially love storytelling, and opera is a great way to tell stories. 

**Matthew Fava**: Within literature and comics there is a lot of emphasis on works for young readers—the amount of youth programming at The Toronto Comic Arts Festival is a brilliant indication of this. The publishing industry has recognized that readers respond to various styles of story-telling, and a number of artists and authors are generating breathtaking written and illustrated works. Some of the most adventurous design and inspiring visual art that I encounter in my day exist within the pages of the books my daughter picks out at the library.

Writing opera for children is important because any time we allow ourselves to consider the lens through which a young person views, experiences, and represents their reality, we have a more meaningful experience with our own. Opera, as an immersive and collaborative art form, has incredible range and has been a ready outlet for contemporary composers wanting to connect with young audiences and musicians.

## What do composers need to consider when writing opera for children?

**Fava**: From the vantage point of a non-composing adult, I feel that the treatment of the text is vital. Even with minimal staging a young mind can build an entire world from spoken and sung text. Similarly, never underestimate the sophisticated ear of a young person and their curiosity regarding sonic and structural elements that play with convention. And generally, consider the fact that children’s literature now actively engages with issues around gender identity, race, and other complex topics, but in a thoughtful way and not merely in a *curriculum* way. How can we create space within opera to address the issues that young people are dealing with every day? Ultimately, can a young person see opera as a medium for their own story-telling?

**Rolfe**: First, clarity! Make sure the words can be heard, and keep the musical language direct and simple (but not simplistic). If kids (or any audience) must struggle to comprehend, they will tune out.

Second, keep it moving. Kids are physical beings and respond to pulse and forward motion; if the story is monotonous or halting, their attention will wander.

Third, have a story and characters that connect with kids. They won't have much patience for grown-up worries and philosophizing, but they can deal with all kinds of "heavy" issues as long as they're presented through their own eyes and experience.

Last and most important, never talk down. Kids are very tuned into being patronized, from years of experience, and will detect it immediately. They are as sophisticated and as discerning an audience as any (and as enthusiastic if they like something). If we want the best for our children, then the art we make for them (and with them) should also be the best.

>[Register right here](https://musiccentre.secure.force.com/ticket/#sections_a0F1a000004CS3qEAG) for Composers (of the) Roundtable, May 31, 7-8pm at the Canadian Music Centre.
