+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-08-16T10:19:00-04:00"
lastmod = "2017-08-18T18:25:00-04:00"
preamble = "Next month, [re:Naissance Opera](/scene/companies/renaissance/) & BC Living Arts present an adaptation of Handel's *Acis & Galatea* that's both contemporary, and century-spanning. [*Acis & Galatea: A Gender Liberation Opera*](https://www.reopera.com/acis-galatea) plays at the Orpheum Annex Theatre in Vancouver, **September 15-17**; Alan Corbishley directs the cast of Debi Wong (Acis), Rachel Fenlon (Galatea), and Peter Monaghan (Polyphemus).\n\n\"Our re-conceptualization, is set in the 19th but both Acis and Galatea are portrayed by and depicted as women.\" Handel's story of the two lovers pulled apart by Galatea's jealous admirer, is re-imagined as a tale of two people who search for a community that accepts their expressions of gender and sexual orientation, and of Polyphemus' violent opposition to their choices and love.\n\nWe spoke with Wong (who also adapted the libretto) and Corbishley about re:Naissance's *Acis & Galatea*, and the intertwined histories of opera and the LGBTQ+ communities."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502928514801/2017-08-16---Square---Acis-Galatea-Poster.jpg.jpg"
publishDate = "2017-08-18T09:39:00-04:00"
related_companies = ["scene/companies/renaissance.md"]
short_description = "&quot;In the world of opera and classical music, we tell a version of history that neglects LGBTQ+ people (as well as women and people of colour) and this is not because these communities and identities did not exist. It&#039;s because they were not treated equally and therefore were not as prominent in society or they assumed or feigned other identities to fit into society. Today, we embrace and celebrate diverse identities, but this is not reflected enough in our storytelling and programming in the operatic world.&quot;"
slug = "dont-miss-acis-galatea-a-gender-liberation-opera"
title = "Don&#039;t miss Acis &amp; Galatea: A Gender Liberation Opera"
+++

## What can you tell us about your newly adapted libretto for *Acis and Galatea*, and how it fits into the musical world created by Handel?

**Debi Wong**: When I am adapting a show, I like to look at the libretto first and see how far I can break it down.  Before changing or adapting anything, I want to be able to summarize the story in one or two lines. When I have the heart of the story, I can start playing with it and translating it into storylines that speak to contemporary issues:

"*Acis & Galatea* is about a demigod and a shepherd who are persecuted for their relationship."

Unfortunately, we can replace "demigod" and "shepherd" with a lot of words that would make this summary a very contemporary story. 

I've adapted this libretto to tell the story of two women in the 19th century who fall in love and are persecuted for their relationship. 

In putting the score together, I decided to pull movements from all the different versions of *Acis & Galatea* that we have music for. And I admit, I stole a duet from Handel’s *Rodelinda*. And we are also composing a new recitative... But this practice of swapping certain arias out for others, transposing for different voice types, reworking existing pieces, and writing entirely new ones, was very common in the 18th century, and very common for Handel. They weren’t in a habit of preserving and presenting the same works in the same way over and over again. Their practice was to adapt productions and materials for the context they were performing in and for the performers at their disposal.

The show will sound and feel like a baroque opera and musically, it will resemble other productions of Handel's *Acis & Galatea*, but the story, I hope, will ring louder with a contemporary audience. 

## How do you feel that the LGBTQ+ communities are under- or misrepresented in the opera world?

**Debi**: I'm having a hard time tackling this question because it is so big. I hope it is one that will get discussed in more detail as we (the opera and classical music community) begin acknowledging and tackling the issues of certain people being underrepresented and misrepresented in our productions and organizations. 

When I think about this question, I think about history and storytelling. We tend to think of history as something that is linear and fixed: we can't change the past, what's done is done. The future is our blank canvas: we can do anything, we can be anything, we can right the wrongs of the past. But I don't think these things are completely true. I think the past, the present and the future are constantly moving and working in tandem and I think the past, too, is a blank canvas. I see history as a form of storytelling. It is a curated series of events and characters, told from the contemporary perspective of the storyteller; and the ways in which we depict our history directly affects our present and our future. 

In the world of opera and classical music, we tell a version of history that neglects LGBTQ+ people (as well as women and people of colour) and this is not because these communities and identities did not exist. It's because they were not treated equally and therefore were not as prominent in society or they assumed or feigned other identities to fit into society. Today, we embrace and celebrate diverse identities, but this is not reflected enough in our storytelling and programming in the operatic world. I think that is because we have not created a space for LGBTQ+ communities in the way we recount the history of opera and classical music.  

**Alan Corbishley**: Within the world of opera, there is a strong tradition of women playing male roles - the "pants roles".  Cherubino, the unctuous teenage boy who is in love with the countess is a common example.  Here we are asked as an audience to suspend our disbelief that this women, dressed as a man, is yearning for another woman, as a man.  Or how about the relationship of the Marschallin and Octavian (a "pants role") in *Der Rosenkavalier*?  The gay overtones inherent to the operatic gender bending tradition is thick, and yet, it is exceptionally rare, if ever, that the characters themselves are infact portrayed as gay - nor are the subverted gay plots ever brought to the foreground.  

The operatic canon is ripe with exotic and passionate stories of heterosexual desires and therefore, it is often difficult to allow gay characteristics to permeate through.  One of the few exceptions has been the gay undertones of *Eugene Onegin* and his counterpart Lenski where it is becoming more commonplace to clearly allude to their homosexual leanings.  Even within operas written by openly gay composers such as Benjamin Britten, the messaging of LGBTQ+ characters or plot points is clouded in shame.  Take *Billy Budd* for example: an opera written entirely for male characters, is set on a ship, is filled with sexually frustrated sailors, and all the men sing to express their feelings.  This environment is clearly ripe for gay subplots (at least), but is instead fixed on the reality of homosexuality and only offers a grey mist of closeted sexual innuendo through the abuses of power.  Here, even a gay composer prevents his own compositions from directly reflecting his own reality in life, preventing the plot to reflect his loving relationships and community.  

So through a sinister irony, the genre that is often loved by the gay community, is written by the gay community, and in itself presents overtly gay traditions, rarely actually reflects the gay community but instead, subverts it through a heterosexual lens. There is an inherent irony within opera when it comes to gender bending and unintentional gay interactions on stage - especially when we are discussing how the LGBTQ is under represented within the genre.

## What topics do you hope to raise during the production's complementary symposium on Identity and Authenticity?

**Debi**: One of the beautiful things about art, any form of art, is that it possesses an inherent ability to transcend the everyday, to transcend reality, to exist in a world outside of our own. Art can be anything it, it can say anything and because of that, it is a very powerful vehicle for illuminating the challenges and values of our world. 

We can create art for art’s sake - it can exist as something beautiful and transcendental. But we can also create art that reflects the diversity, the grittiness, the humanity of our world and what I want to pose in this symposium - and to everyone reading this - is:

What are our responsibilities as artists, as producers to create, curate and program art that reflects that diversity, that grittiness, that humanity in our communities? Do we even have a responsibility in this regard?

re:Naissance is commissioning new works but also reimagining historical works and in the world of classical music, we have a habit of depicting a history that misrepresents and under-represents diverse identities. As a result, we are in a current practice of producing operatic and other musical works that exclude LGBTQ+ identities and relationships, that depict women in specific kinds roles (on and off stage), and cast productions that neglect people of colour. When we do this, what are we saying to and about these people? What kind of cultural values are we promoting (whether conscious of not)?

We also have a lot of traditions and practices that we preserve in the world of classical music through repetition. So the symposium aims to shed light on those traditions and practices and see if we can find a way to balance tradition and our notions of authenticity with our current cultural values - the ones that celebrate diverse identities.

>Acis & Galatea runs September 15-17 at the Orpheum Annex Theatre. For full details and ticket information, [click here](https://www.reopera.com/acis-galatea).
