+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-07-12T17:33:00-04:00"
lastmod = "2017-07-16T10:46:00-04:00"
preamble = "This year's performance season for [Summer Opera Lyric Theatre](/scene/companies/summer-opera-lyric-theatre/) (SOLT) kicks off on **July 28**, with a [Canadian double-bill](http://www.solt.ca/performances.html): John Beckwith's *Night Blooming Cereus* and Michael Rose's *A Northern Light's Dream*. The latter is a new SOLT commission that sees its world premiere this summer; it draws inspiration from Shakespeare's *A Midsummer Night's Dream*, and the Ontario-set *Northern Lights Dream* - a man's coming-out story, told from the vantage point of his wife - holds a similar balance of earthiness and magic.\n\nRose chats about storytelling, inspiration from the greats, and why opera should be seen and not simply heard.\n\n\n"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499895712218/2017-07-12---Michael-Rose.jpg.jpg"
publishDate = "2017-07-16T10:21:00-04:00"
short_description = "&quot;To tell the story of a wife coming to the realization that her husband is gay, you need a catalyst. Something must happen to put the idea into her head, when every fibre of her being wants to deny the possibility. Then she needs time to deal with it. To do all this within the limits of a one-act play is a huge challenge. &quot;"
slug = "dont-miss-a-northern-lights-dream"
title = "Don&#039;t miss: A Northern Lights Dream"
+++

## What can you tell us about *A Northern Lights Dream*?

Last August, [SOLT General Director] Guillermo Silva-Marin asked me if I would be interested in writing a new piece for Summer Opera Lyric Theatre, to be performed in the 2017 summer festival. He wanted to present a one-act opera written in the 1950's by James Reaney and John Beckwith, called *Night Blooming Cereus*. But he needed something to go with it. I told him I'd have to think about it, then immediately blurted, "Yes, yes, yes!"

Although it's not stated in the opera, when I read the published libretto for *Cereus*, I discovered that the story was set in the town of Shakespeare, Ontario. As soon as I saw that, I knew what I wanted to do. For a long time, I had wanted to write a story about a married man coming to terms with his homosexuality. But I wanted to write it from the wife's point of view. I've always felt that her side of the story has been unjustly ignored. There are many wonderful versions of his story, but few - if any at all - about her. And yet her story is so full of dramatic potential! So, when I started thinking about Shakespeare – both the town and the writer – I knew I had a way to tell that story. I would use Shakespeare's Robin (Puck), from *A Midsummer Night's Dream*, as its dramatic engine.

Originally, I wanted to use the same voice types that John Beckwith used in *Cereus*. This seemed practical, given that both shows would be performed together. But in writing the music, I discovered that one of the voices – a bass – didn't fit. I didn't need a bass. I needed a tenor. But for this one exception, both works can be performed with the same cast.

Musically, the piece is a hybrid, straddling sounds and structures that people will associate with opera and with musical theater. The degree of opera-ness and musical-ness depends on the nature of the character. The more other-worldly the character (a handmaiden to the goddess Aurora, for instance), the more operatic the sound. There is also a lot of spoken dialogue. In this sense, it has much in common with a play.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499896209895/2017-07-12---IMG_5748.jpg.jpg)<figcaption>In rehearsal for *A Northern Lights Dream*. Photo courtesy of Summer Opera Lyric Theatre.</figcaption>
</figure>

## How have you paired a contemporary, Canadian-set story with inspiration from Shakespeare and mythology?

To tell the story of a wife coming to the realization that her husband is gay, you need a catalyst. Something must happen to put the idea into her head, when every fibre of her being wants to deny the possibility. Then she needs time to deal with it. To do all this within the limits of a one-act play is a huge challenge. 

But not so much, if you can use magic! So, I invented a goddess who loves to open the eyes of mismatched lovers. And I let her do all the work – with the help of Shakespeare's Puck, from *A Midsummer Night's Dream*, who is now four hundred years old and enjoying modern life in Shakespeare, Ontario.

## What do you think makes a story "operatic"?

I think opera, like any dramatic form, requires a story that needs to be seen and not just heard. Otherwise, it's a radio play. Or a radio opera (if such a thing exists). But that’s also true of plays, musicals, and movies. All of them require something visual or theatrical. 

Opera, or any kind of music theatre must also have an inner emotional story that is best portrayed through music. But this could also be said of film. Music scoring for film is horribly undervalued. But it makes the art of film the closest relative to opera. Closer than plays, I would say. Most films would be as dull as dirt without the music. A brilliant film director – Hitchcock, for instance – knows its value. He may have been the most operatic of all film directors. Music can move things forward, create suspense, and let us feel in a direct way what the characters are feeling. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499896183948/2017-07-12---NorthernLightsCast.jpg.jpg)
<figcaption>The *Northern Lights Dream* team, clockwise from top left: Suzy Smith (music director & pianist), Grace Quinsey (Helen), Shaelyn Archibald (Helen), Logan Hickey (Taylor), Jenny Cohen (Mrs. Duke), Rosalind McArthur (Mrs. Duke).</figcaption>
</figure>

## What do you hope audiences will take away from the world premiere run of *A Northern Lights Dream*?

It's a comedy, so I hope people will laugh! I would be incredibly happy just to hear laughter. But I also hope the audience will be touched by the story in some way. What more could a writer want?

>The SOLT line-up also includes Bizet's *Carmen* and Mozart's *The Marriage of Figaro*; performances run from July 28 to August 6. For details and tickets, [click here.](http://www.solt.ca/performances.html)

