+++
author = ["authors/carly-gordon.md"]
categories = "Review"
date = "2019-02-20T00:36:44+00:00"
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1550623120/media/2019/02/sqDonPasquale.jpg"
primary_image_credit = "Laura León as Norina and Paul La Rosa as Dr. Malatesta in Don Pasquale, Opera Fusion, 2019. Photo: Chris Barbu."
related_articles = ["articles/shades-of-opera-how-to-tell-your-buffo-from-your-bel-canto.md", "articles/don-pasquale-a-colorful-season-starter-at-minnesota-opera.md"]
related_companies = ["scene/companies/opera-fusion.md"]
related_people = ["scene/people/paul-la-rosa.md", "scene/people/laura-león.md"]
short_description = "Accompanied by a chamber orchestra seated on stage, the show had all the grand, theatrical trappings of opera, sized down into a portable, affordable package."
slug = "small-company-big-laughs-opera-fusions-don-pasquale"
title = "Small company, big laughs: Opera Fusion's Don Pasquale"
youtube_url = ""

+++
While residents of Pompano Beach, Florida can choose to travel forty minutes north to Palm Beach or south to Miami to attend performances of national renown, this smaller city played host to its very own cultural gem on February 16, when [Opera Fusion](/scene/companies/opera-fusion/) presented a lively _Don Pasquale_ that racked up laughs and delivered tender musical moments, building a sense of community along the way.

Opera Fusion is a small company with a big heart. Their mission is "\[to make\] the classical voice more accessible and affordable in South Florida by showcasing local talent in intimate and non-traditional venues," according to their program notes. "We're proving to audiences that classical music isn't stuffy or elitist."

> Baritone Paul La Rosa's Doctor Malatesta checked all the buffo boxes: sarcastic, scheming, swooping in with a mischievous smile.

From the moment guests entered the lobby of the Pompano Beach Cultural Centre – a multipurpose community arts complex adjacent to a public library branch and mere steps from City Hall – this mission sprang into action. Instead of a brigade of uniformed ushers, a single greeter with a friendly smile escorted ticket holders to their seats one by one. The 400-seat theatre didn't sell out, but an ample audience made for a pleasant camaraderie that kept laughter churning from the downbeat to final bows.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1550623300/media/2019/02/TonyDillonPaulLaRosaLauraLeonZackeryMorris_.jpg){{% /md %}}

<figcaption>(l-r) Tony Dillon (Pasquale), Paul La Rosa (Malatesta), Laura León (Norina), and Zackery Morris (Ernesto) in Don Pasquale, Opera Fusion, 2019. Photo: Chris Barbu.</figcaption>

</figure>

South Florida favourite [Laura Léon](/scene/people/laura-leon/) sang a sharp-witted Norina with an agile soprano voice and crowd-pleasing charm. Her animated acting and playful interpretation were matched by tenor Zackery Morris, whose warm tone softened an emotive Ernesto's youthful melodrama – "I'll search for a far off land so I can moan unnoticed," he laments upon his self-sacrificing break-up with Norina – with a balance of humour and genuine tenderness.

Baritone [Paul La Rosa](/scene/people/paul-la-rosa/)'s Doctor Malatesta checked all the buffo boxes: sarcastic, scheming, swooping in with a mischievous smile and an elaborate plot to hoodwink the titular Don and reunite the stymied lovers. La Rosa sang with a rich voice and a smart sense of comic timing. Joined by bass Tony Dillon in the title role, the duo's impressive, rapid-fire patter song in "Cheti, cheti immantinente" was an audience favourite.

> Opera Fusion achieved a lot with a little, proving that even on a small stage, for a small crowd, with a small budget, opera can still stir up big feelings.

In _Don Pasquale_, old-fashioned tropes abound, Norina posing as a timid, obedient bride turned unbearable shrew – but the character Léon brought to life was neither end of this false dichotomy. "I've a head for whimsy, but an excellent heart," she mused in her introductory aria, an autobiographical quip easy to imagine headlining Norina's Bumble profile. Léon’s Norina was strong and self-assured with a streak of silly, taking antiquated ideals to task with a little help from Doctor Malatesta, but mostly with her own sense of candour, humour, and justice.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1550623616/media/2019/02/LeftTonyDillonPaullaRosaLauraLeonNorina.jpg){{% /md %}}

<figcaption>(l-r) Tony Dillon (Pasquale), Paul La Rosa (Malatesta) and Laura León (Norina) in Don Pasquale, Opera Fusion, 2019. Photo: Chris Barbu.</figcaption>

</figure>

The performance was a co-production with Gulfshore Opera, a company serving communities on Florida's west coast with projects tailor-made for outreach and engagement. Impressively detailed and versatile set design by Ardean Landhuis captured big imagination on a small scale, with the chorus – an energetic crew of students from Ave Maria University – rotating walls and doors during scenic transitions to transform Don Pasquale's pink-walled parlor into Norina's chambers or an ivy-covered garden. Accompanied by a chamber orchestra seated on stage, the show had all the grand, theatrical trappings of opera, sized down into a portable, affordable package.

Pompano Beach may not be home to its own grand opera company or luxurious concert hall, but the audience gathered on Saturday night didn't seem to mind. [Opera Fusion](/scene/companies/opera-fusion/) achieved a lot with a little, proving that even on a small stage, for a small crowd, with a small budget, opera can still stir up big feelings, big laughs, and plenty of smiles.