+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-04-15T21:30:00-04:00"
lastmod = "2018-04-19T10:48:00-04:00"
preamble = "Heartbeat Opera Co-Music Director Daniel Schlosberg is ready for the company's fourth annual Spring Festival, where he'll unveil his new arrangement of Mozart's [*Don Giovanni*](https://www.heartbeatopera.org/don-giovanni). The composer and pianist has taken on operatic classics in past seasons, experimenting with percussion with *Lucia di Lammermoor* and adding jazz into *Carmen*; for this *Don Giovanni*, directed by Heartbeat Opera Co-Artistic Director Louisa Proske, he gets creative with the clarinet.\n\nWe spoke with Schlosberg about telling stories with orchestral instruments, and how to keep classic operas from becoming \"museum pieces\"."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523842120929/sqBoyle_MAC_HeartbeatOpera_0303.jpg.jpg"
primary_image_credit = "Daniel Schlosberg, composer, pianist, and Co-Music Director of Heartbeat Opera."
publishDate = "2018-04-19T10:48:00-04:00"
related_articles = ["articles/a-truly-otherworldly-space-heartbeat-operas-drag-extravaganza.md","articles/heartbeats-giovanni-successfully-bucks-tradition.md"]
related_companies = ["scene/companies/heartbeat-opera.md"]
short_description = "&quot;These classic opera scores, like any art form, are never static, and I believe they are strengthened by reinterpretation. We&#039;ve all become used to hearing them in a certain way over the years, with the same orchestration, to the point that they have become museum pieces. My intention is to breathe new life into the scores, and I hope that audiences are able to gain a fresh perspective on the music as a result.&quot;"
slug = "don-giovanni-strengthened-by-reinterpretation"
title = "Don Giovanni: &quot;strengthened by reinterpretation.&quot;"
+++

## What inspired you to create your own arrangement of *Don Giovanni*?

Heartbeat Opera creates radical new adaptations of classic operas for intimate venues, giving our audiences a chance to experience the gripping drama of these masterworks close-up. As a major part of our process of adaptation, I create new chamber orchestrations of the scores to reflect the dramatic impetus of the production. For *Lucia di Lammermoor*, which we mounted two years ago, I tinkered with a menagerie of percussion instruments, including vibraphone, crotales, ratchet, flexatone, and toy piano, to mirror Lucia's descent into madness. Last year, we set *Carmen* on the U.S.-Mexico border, and I wrote a jazz-infused score that featured saxophone, electric guitar, and drum kit.

*Don Giovanni*, in Louisa's production, is a complicated figure, both a shapeshifter and a social outcast. I decided to spotlight the clarinet, not only because of Mozart's growing fascination with the instrument late in life, but also because like *Don Giovanni*, it has a unique ability to both stick out and blend in. Pairing the clarinet with string quartet and bass produces a concerto-like texture that mimics a relationship of the individual to society that we're interested in exploring.

These classic opera scores, like any art form, are never static, and I believe they are strengthened by reinterpretation. We've all become used to hearing them in a certain way over the years, with the same orchestration, to the point that they have become museum pieces. My intention is to breathe new life into the scores, and I hope that audiences are able to gain a fresh perspective on the music as a result.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523841860251/Boyle_MAC_HeartbeatOpera_0303.jpg.jpg)
<figcaption>Daniel Schlosberg, composer, pianist, and Co-Music Director of Heartbeat Opera.</figcaption>
</figure>

## What do you know about Mozart's relationship with the clarinet?

I am by no means an expert, but Mozart was apparently fascinated with the clarinet — he incorporated it into his works throughout his career. In his later years, he began featuring the clarinet more and more, eventually writing his Clarinet Quintet and Clarinet Concerto, two absolute gems and touchstones of the repertoire. I was particularly inspired by the Quintet in my own re-orchestration, and specifically the way Mozart plays out the social drama of clarinet versus strings, of individual versus society. Mozart certainly pushed the virtuosic capacity of the clarinet at the time, and I intend to carry on that gauntlet by stretching the bounds of what we're used to hearing from a clarinet in an 18th-century composition.

## How have you created a character out of the clarinet?

My orchestration casts the clarinet, like Don Giovanni himself, as an outsider. As I mentioned above, the clarinet has a unique dual capacity both to be the loudest, most strident sound in the ensemble as well as to blend in almost to the point of being imperceptible. Like Giovanni, the clarinet is a shapeshifter. My orchestration will dig into the relationship between the clarinet and strings, which, like those around Giovanni, attempt to constrain and confine a social outcast.

Not to give too much away, but the production will feature an enormous dramatic "break" between Acts 1 and 2. The music will change quite significantly after this break, with the clarinet taking on even more of a leading — and disruptive — role. I am very excited to explore the dramatic and musical possibilities that result from this conceptual shift. The audience can certainly expect some unusual sounds and even nontraditional instruments to come to the fore.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523841868663/beforehighline.jpg.jpg)
<figcaption>Daniel Schlosberg (centre) before Heartbeat Opera's opera drag show, *The High Line*.</figcaption>
</figure>

### What do you think *Don Giovanni* - and Heartbeat Opera's current production - says about men who behave like Giovanni, and the women who hang around them?

I'd say — come see our production! Louisa is interested in complicating the stereotypes associated with these characters, making the individuals more three-dimensional by grounding them in human problems and desires. I'm proud to take part in creating a *Don Giovanni* for 2018.
