+++
author = ["authors/laura-attridge.md"]
categories = "Op-ed"
date = "2018-07-24T10:33:00-04:00"
lastmod = "2018-07-26T20:29:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1532442674436/sqWaterperryDonGiovanniGraphic.jpg.jpg"
primary_image_credit = "Image courtesy of Waterperry Opera Festival."
publishDate = "2018-07-26T20:29:00-04:00"
related_articles = ["articles/concept-production-real-reason.md","articles/in-review-tcherniakovs-don-giovanni.md"]
short_description = "And, let&#039;s be honest, we&#039;ve all seen these productions, in which even basic narrative details of a piece are obscured, confused, ignored or senselessly &quot;deconstructed&quot; with sometimes baffling outcomes."
slug = "don-giovanni-in-2018-in-search-of-a-concept"
title = "Don Giovanni in 2018: in search of a &quot;concept&quot;"
+++

**concept**<br>
*noun*<br>
<li class="nospace">
1. an abstract idea.
"structuralism is a difficult concept"
<li>2. a plan or intention.
"the centre has kept firmly to its original concept"
<li>3. an idea or invention to help sell or publicize a commodity.
"a new concept in corporate hospitality"
</li>

I have an admission: when speaking the word "concept" aloud in reference to my own work as a director, I have increasingly found myself accompanying it with apologetic air quotes and a tone of self-deprecating irony. It is a term I struggle with for numerous reasons, not least the weight added to it by its regular use in criticism of opera productions: "the concept was overcomplicated"; "the concept got in the way of the music"; "everything was fantastic apart from the concept". 

In these cases "concept" is more often than not being used to refer to the fallout of a director's-vision-above-all approach: a self-indulgent way of working which leaves little – if any – room for anything beyond the director's ego. And, let's be honest, we've all seen these productions, in which even [basic narrative details of a piece are obscured](/in-review-tcherniakovs-don-giovanni/), confused, ignored or senselessly "deconstructed" with sometimes baffling outcomes.

Shows like this can be dreadfully frustrating, but I would suggest that rather than blaming the individual director we should blame a wider misunderstanding of what a director's contribution to a production actually ought to be – a misunderstanding that is signalled by using word "concept" to describe said contribution. The term itself is highly reductive, with no room to encompass practical elements like collaboration and facilitation which are essential to a director's role, not to mention creative results like clarity, illumination, focus or depth; above all, it makes no reference in the slightest to a sense of responding to a stimulus, which is surely at the heart of what a director does. 

To reduce a director's job to the responsibility for coming up with – and imposing – a concept, therefore, almost always produces poor direction, and a poor production. Small wonder that audiences are so often disappointed.

A clever directorial vision, however, can be seductive. When tackling a piece firmly placed within the operatic repertoire, how can one resist the temptation to want to do something new with it – something no one has done before? After all, this approach fulfils all three parts of the definition above, both for an individual director and for the company hiring them: the excitement of a bright idea, the assurance of a clear plan, and the guarantee of bums on seats. When interviewing for directing work, I've often had to pitch a specific concept for a piece, presumably to prove I am capable of delivering these components safely. 

While on the surface this appears perfectly logical, it suggests a limited expectation of the directorial role itself, both practically and creatively; it is also asking for an artistic interpretation of a piece conceived in isolation, without input from other members of a creative team (designer, conductor, and so on) and without taking into account many of the circumstances of an individual production such as venue and casting. It is furthermore expecting a director to do a great deal of work without being paid, but that is another article for
another day...

In any case, this is where the seeds of "concept" are often planted: at interview, or at the very least in initial discussions between company and director. To subsequently hold a director to an idea (however good the idea!) originating under these conditions is likely to confine a production to being simply the product of just that – an idea – rather than allowing it the possibility to become, and exceed, the sum of its parts. 

In this time of turmoil for opera, when its validity and place in the world are being questioned, it is entirely reasonable for companies and individual artists to want to reinvigorate what they have to offer. However, to do so by putting faith only in a "concept", for the sake purely of originality, is to lose confidence in the art form itself. As a result, you get innovation without integrity: a production without a heart.

By contrast, when I was invited some months ago to interview to direct [*Don Giovanni* for Waterperry Opera Festival](http://www.waterperryoperafestival.co.uk/dongiovanni.html)'s inaugural season this August, I was not asked to prepare a detailed concept pitch for the production. Refreshingly, my experience of the meeting was of a dialogue with fellow artists – the creative and production team members leading the festival – about *Don Giovanni* as a piece: our shared and respective responses. We found common ground in a
connection to it from a modern viewpoint: in particular the contemporary resonances of the female characters' narratives, and of Don Giovanni himself as an embodiment of toxic male entitlement.

We also found ourselves agreeing when discussing ways of working creatively, so when I was offered the job – although there was no cut-and-dried "concept" ready for a creative team and cast to carry out – there was instead a strong starting point in a shared understanding of what it is to make work for the stage. What we agreed was this: collaboration is at the heart of opera, conceived as it is in the partnership between (ideally!) a librettist and composer; a director and conductor come together into another partnership to interpret the resulting relationship between words and music; other collaborators include a designer, lighting designer, movement director, and so on; the cast are collaborators; the audience are collaborators. 

It is therefore not only a great waste of resources to impose a pre-conceived directorial "concept" upon a production, but doing so displays a fundamental
misunderstanding of the riches of opera as an art form.

However, to come to a production without a flashy concept already on the table raises the question of trust: it does not immediately offer a company – or a director – the apparent security of making something guaranteed to be "original". It requires a leap of faith, one which Waterperry Opera Festival have taken by placing their trust in me and in a more nuanced way of working; they are thereby putting their trust in opera, and investing in the art form for the long term. 

In his book *The Actor and the Target*, celebrated director Declan Donnellan (who works primarily in theatre and film) makes an excellent case against the demand for "originality": to strive towards originality for its own sake is to seek validation above everything else, and to work from a basis of fear – fear of inadequacy, of the humdrum. On the other hand, to work from a place of trust offers the potential for "uniqueness": by embracing the singularity of a particular production's elements – personnel as well as circumstances such as venue, geographic location, calendar year – you work towards something unique. 

This offers a much richer process as well as a richer result. A unique production is more often than not also original, by way of its own virtues.
Although taking on a piece as famous and frequently performed as *Don Giovanni* (an opera dubbed "the director's graveyard") might initially be an intimidating prospect, I know I can trust not only in my own instincts, skill and experience but also those of my creative team and my cast.

These elements alone already offer their own natural pointers towards an interpretation of the piece: I, for example, am a young female (and feminist) director; how could these facts not directly influence my personal responses, especially to a piece like *Don Giovanni*? There are outside factors, too: for example, it is the year 2018; not only does awareness of current cultural, political and social dialogues affect every person involved in the production, but so, too, our audiences members. It would be a waste not to capitalise upon these influences if one is hoping to make work which successfully speaks to everyone who sees it.

None of what I am saying is revolutionary: the best stage directors have always worked this way. I am, however, responding to what seems at this moment in the history of opera to be an extraordinary lack of dialogue surrounding the role of the director – at least in the UK – and the power this role has to move opera forwards into a successful future. But unless opera companies invest in both innovation and integrity, this cannot happen. 

[My 2018 *Don Giovanni*](http://www.waterperryoperafestival.co.uk/dongiovanni.html) (running August 17-19) will attempt to make the most of what is on offer in the unique conditions of this particular production: Waterperry House and Gardens' extraordinary setting and bijoux amphitheatre as performance venue; the generous and forward-looking approach of Waterperry Opera Festival; the dynamic collaborators on the creative team; the talented and intelligent performers in the cast; the diverse and vivid imaginations of the audience members; and much, much more. By placing my trust in these elements, I hope to be offering something even better than a "concept": I hope to be actually doing my job as a director.

>Waterperry Opera Festival's production of *Don Giovanni* runs August 17-19 at the Waterperry Amphitheatre. For details and ticket information, [click here.](http://www.waterperryoperafestival.co.uk/dongiovanni.html)
