+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-07-12T16:14:00-06:00"
lastmod = "2015-07-15T21:28:00-06:00"
preamble = "Baritone [John Holland](/scene/people/john-holland/) wrote me recently from Prague, Czech Republic (one of my favourite cities). He was there until recently as part of the [Prague Summer Nights Young Artist Music Festival](/scene/companies/prague-summer-nights/), singing Masetto in *Don Giovanni*. John got to go to a beautiful city to sing in a masterpiece opera, in a production directed by the formidable [Sherrill Milnes](/scene/people/sherrill-milnes/); best of all he got to do it in the Estates Theatre, where Mozart conducted the premiere performance of *Giovanni*. I made sure to visit the theatre during my own travels to Prague (with buddy and fellow [blogger](http://www.ragstoreasonable.com/), [Christopher Enns](/scene/people/christopher-enns/)), and I remember imagining Mozart walking the same streets on his way to opening night. I was so glad John reached out to tell me about his historically overflowing operatic experience."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1436740327148/Narodni_Divadlo_Estates_Theater_Prague_-_8648.jpg.jpg"
publishDate = "2015-07-16T07:28:00-06:00"
related_articles = ["articles/opera-on-steroids-budapest.md","articles/who-cares-what-mozart-loved.md","articles/watch-rolando-villazon-brings-don-giovanni-to-life.md"]
related_companies = ["scene/companies/prague-summer-nights.md"]
related_people = ["scene/people/john-holland.md"]
short_description = "Baritone John Holland wrote me recently from Prague, Czech Republic (one of my favourite cities). He was there until recently as part of the Prague Summer Nights Young Artist Music Festival, singing Masetto in Don Giovanni. Sure, John got to go to a beautiful city to sing in a masterpiece opera, but he got to do it in the Estates Theatre, where Mozart conducted the premiere performance of Giovanni."
slug = "don-giovanni-at-the-estates-theatre"
title = "Don Giovanni at the Estates Theatre"
+++

### On the Estates Theatre

First off, the Estates Theatre is simple a beautiful building! It is 18th century architecture, having opened in 1783, just four years before the the premiere of *Don Giovanni*. While walking towards it, one can remember seeing it form scenes in *Amadeus*, and *Immortal Beloved*. 

What surprised me about the building is that it is relatively narrow, but very long. The architecture is all original, and it is amazing to think that Mozart would recognize every inch of this theatre were he alive today. The stage itself is very deep, which make for interesting acoustics. If you are at the proscenium arch, or in front of it, the sound rings throughout the theatre, but back behind it, or further upstage, the sound can get lost in the wings or the fly gallery. 

The directors of the production, Sherrill Milnes and Maria Zouves made sure to put us in the best singing positions as possible. As singers, we have to remember our training, and to trust the conductor as delays with the sound can happen when too far upstage. From the audience, there isn’t a bad seat in the house. The theatre seats 659 people, with seating on the main floor an the rest in boxes or upper floor galleries. The sound carries well in the theatre, but while on stage, you can sometimes wonder where your sound is going. It is a dry acoustic, but still a wonderful space for singing.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1436740479563/GiovanniShot.jpg.jpg)
<figcaption>Carina DiGianfilippo (Zerlina), Tae-eun Moon (Don Giovanni), John Holland (Masetto) in the Prague Summer Nights Music Festival's production of *Don Giovanni*. Photo: Bel Canto Photography.</figcaption>
</figure>

### On history and performance pressure

I don’t know if I would say pressure, but there is an onus on the musicians to make sure we do justice to Mozart’s music in his theatre. The Estates Theatre is the only remaining theatre in the world where Mozart conducted, and the fact that I was singing in Don Giovanni, where Mozart conducted the premiere in 1787, gave me added incentive to to bring my ‘A’ game. For our entire cast, we realized that anything less than our best wouldn’t be good enough for this space, and it inspired us in our singing, character development, and overall performance. 

In all honesty, it was an amazing feeling to know that Mozart had stood there and conducted Don Giovanni in that very theatre. Prague also has a history of high-calibre music, so there is an extra special feeling about making music in that city. I had the privilege to sing at BachFest Leipzig last year, and sand a foot from where Bach is buried in the Thomaskirche. Singing in Mozart’s theatre was such an amazing experience.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1436741951932/GiovanniCast.jpg.jpg)
<figcaption>Conductor John Nardolillo takes a bow with the cast of *Don Giovanni*.<figcaption>
</figure>

### On historical performances and "the original"

Well, one thing I have learned about being "true to the original" is in regards to making sure you learn ALL of the music for every role. As you know, with Mozart operas, there are often cuts to the recitatives, or even to the musical numbers themselves. 

Before arriving in Prague, the cast was given a cuts list, which included the Epilogue, meaning the opera would end with Don Giovanni descending to hell, and those final strong chords, as had been done in the Prague premiere. Upon arriving, director Sherrill Milnes and conductor John Nardolillo decided that they wanted part of the Epilogue in to close out the show. The cast learned the final fugue section quickly and incorporated it in. 

As I was singing Masetto, there aren’t many opportunities to cut my music, but many of the the other cast had to be prepared to sing of not sing certain arias. The theatre is a wonderful space for music, and I believe Mozart enjoyed it as he had attended productions of *Le Nozze di Figaro* there, before the *Don Giovanni* commission came. While much is made about Mozart and Vienna, Mozart and Prague have perhaps a greater connection. Prague was a city that embraced Mozart, and while Prague was a smaller city, it still had the musical resources to fulfill, and in some cases, exceed Mozart’s needs. The wind musicians in Prague were regarded as the finest in Europe at that time, and this is evident in *Don Giovanni*’s score. Also, there was no Imperial Court to impress or dictate styles and tastes. In Prague, Mozart could be himself, and compose whatever he wanted. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1436742104075/IMG_0493.jpg.jpg)
<figcaption>John Holland poses in the historically rich Estates Theatre, in Prague, Czech Republic.</figcaption>
</figure>

### Enjoying Prague, outside the Estates

While the production process was very intense and compact, I was able to make some lifetime friendships with cast and crew. We often spent meals together exploring the indigenous cuisine, such as goulash, dumplings, roast pork, and of course, the famous Czech beers. While there wasn’t much time to explore Prague, we did have trips to the Castle, and toured Old Town, and some of the other sites. Mozart and Dvořák are my two favourite composers, so being in a city with strong ties to both, was exciting!

Singing in *Don Giovanni*, in the Estates Theatre, and with the tremendous cast and crew that we had, was a lifetime experience, and something I will never forget. I am honoured and humbled to be one of the few Canadians to have sung on the stage at the Estates Theatre and I will forever remember the time I made music in the place Mozart had as well. 
