+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2015-06-30T19:11:00-06:00"
lastmod = "2015-06-30T22:49:00-06:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1435725451072/BoosterShots-2.jpg.jpg"
primary_image_credit = "Keith Klassen & Carla Huhtanen in The Whisky Opera by Hannah Moscovitch & Benton Roark, Tapestry Opera, 2014. Photo: Dahlia Katz"
publishDate = "2015-07-01T07:00:00-06:00"
related_articles = ["articles/the-future-of-opera-is-indie.md","articles/who-cares-what-bring-on-the-why.md","articles/in-review-mdea-undone.md","articles/the-bicycle-opera-project-at-21c.md","articles/conductors-what-else-do-they-tell-us.md"]
related_companies = ["scene/companies/tapestry-opera.md","scene/companies/indie-opera-to.md","scene/companies/against-the-grain-theatre.md","scene/companies/the-bicycle-opera-project.md","scene/companies/opera-5.md","scene/companies/essential-opera.md","scene/companies/loose-tea-music-theatre.md"]
related_people = ["scene/people/carla-huhtanen.md","scene/people/keith-klassen.md"]
short_description = "In a competitive industry, I&#039;m fine with the concept of promoting singers who have acting skills and can learn music fast enough to fit into the woefully short rehearsal time many companies are afforded. Survival of the fittest, I say, and new opera is a beautiful and direct route to honing those skills."
slug = "does-new-opera-raise-the-bar-for-performers"
title = "Does new opera raise the bar for performers?"
+++

When I say the words, "new opera," what comes to mind? Atonality? Complicated rhythms? Progressive and unexpected stories? Extended vocal techniques?

I hear you, and I'll not say you're wrong. The problem comes when the above arguments are used as armour *against* performing a new opera, or against putting in the time to find the real stuff of a fresh piece. Simply put, new opera and its stereotypical difficults do nothing but raise the bar for opera, and its performers.

In the obvious sense, singers have to work harder at learning new opera. There are no previous recordings (let along a definitive one), and the tunes certainly ain't Mozart. Singers have to count more, and find new ways of finding their pitches. Difficult as it may be, there's something about new opera that's similar to riding a bike; once you've got it, you've *really* got it.

New opera also means new ways of performing traditional opera. Compact, intimate opera companies use smaller venues with and audience that's close to the performers. It's a huge part of opera's forward evolution, to place opera singers mere feet away from listeners; I've argued before that watching big-budget opera from far away in a huge opera house often can't match the accessibility and relevance of other media. If you want grand, watch *Game of Thrones*, or go catch a full-scale production of *Les misérables*. What can't be replaced by HBO, etc., is the power of a live, acoustic voice, and the awe that listeners experience when hearing it up close. Intimate opera is a powerful tool in these days of waning interest, but it demands from the singers strong acting skills and extreme comfort onstage.

Writing chamber operas, creating controversial characters, writing evocative, rhythmically obscure music; these are all devices used by composer and librettists today that ensure opera stays relevant. Simply put, *Lucia di Lammermoor* may be easier to learn, but there's no gain at the end of it all if the audience can't identify with Lucia. So, if you're going to do the enormous amount of work it takes to learn *any* operatic role, doesn't it make sense to direct that work towards an opera that will a) squash stereotypes of parking and barking in a foreign language, and b) reach a contemporary audience?

What I'm trying to say is not that we should throw out *bel canto* and Mozart, but that the challenges of new opera are worth taking on. They're worth it for gaining and keeping new audiences, and they're worth it for the personal development of your craft. The bar certainly is raised these days; as much as we all love listening to Pavarotti and Kiri te Kanewa, singers today have broader training available to them, and they're capable of being truly versatile artists who can sing, act, move well onstage, and do it all while counting in 5/8. In a competitive industry, I'm fine with the concept of promoting singers who have acting skills and can learn music fast enough to fit into the woefully short rehearsal time many companies are afforded. Survival of the fittest, I say, and new opera is a beautiful and direct route to honing those skills.

Finally, I'll cede that not every new opera is a great one. I'll skip the argument about why this is *not a problem* (people seem to think that the great Verdi and Puccini operas were the only ones being written in those years, and the 19th century was nothing but hits). I think it's incredibly valuable for singers to give feedback to composers and librettists about what's good vocal writing, what words are good to sing, etc. The catch is, your feedback isn't worth much until you've really *tried*.

So, dig away a little longer at those weird-sounding, I'll-never-learn-these-notes operas. There's something in all of them; at the very least, there's the germ of a fantastic idea. To today's opera creators, we owe second glances and educated questions, because that's how we ended up with *Rigoletto* and *Le nozze di Figaro*.
